/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TextEditorBackgroundHighlighter
implements BackgroundEditorHighlighter {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.TextEditorBackgroundHighlighter");
    private static final int[] EXCEPT_OVERRIDDEN = new int[]{1, 3, 4, 7, 12, 8};
    private final Project myProject;
    private final Editor myEditor;
    private final Document myDocument;
    private PsiFile myFile;
    private boolean myCompiled;

    public TextEditorBackgroundHighlighter(@NotNull Project project2, @NotNull Editor editor) {
        if (project2 == null) {
            TextEditorBackgroundHighlighter.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            TextEditorBackgroundHighlighter.$$$reportNull$$$0(1);
        }
        this.myProject = project2;
        this.myEditor = editor;
        this.myDocument = this.myEditor.getDocument();
        this.renewFile();
    }

    private void renewFile() {
        if (this.myFile == null || !this.myFile.isValid()) {
            this.myFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myDocument);
            this.myCompiled = this.myFile instanceof PsiCompiledFile;
            if (this.myCompiled) {
                this.myFile = ((PsiCompiledFile)this.myFile).getDecompiledPsiFile();
            }
            if (this.myFile != null && !this.myFile.isValid()) {
                this.myFile = null;
            }
        }
        if (this.myFile != null) {
            this.myFile.putUserData(PsiFileEx.BATCH_REFERENCE_PROCESSING, (Object)Boolean.TRUE);
        }
    }

    @NotNull
    List<TextEditorHighlightingPass> getPasses(@NotNull int[] passesToIgnore) {
        if (passesToIgnore == null) {
            TextEditorBackgroundHighlighter.$$$reportNull$$$0(2);
        }
        if (this.myProject.isDisposed()) {
            List<TextEditorHighlightingPass> list2 = Collections.emptyList();
            if (list2 == null) {
                TextEditorBackgroundHighlighter.$$$reportNull$$$0(3);
            }
            return list2;
        }
        Document[] uncommitted = PsiDocumentManager.getInstance((Project)this.myProject).getUncommittedDocuments();
        LOG.assertTrue(uncommitted.length == 0, (Object)("Uncommitted documents: " + Arrays.asList(uncommitted)));
        this.renewFile();
        if (this.myFile == null) {
            List<TextEditorHighlightingPass> list3 = Collections.emptyList();
            if (list3 == null) {
                TextEditorBackgroundHighlighter.$$$reportNull$$$0(4);
            }
            return list3;
        }
        if (this.myCompiled) {
            passesToIgnore = EXCEPT_OVERRIDDEN;
        } else if (!DaemonCodeAnalyzer.getInstance((Project)this.myProject).isHighlightingAvailable(this.myFile)) {
            List<TextEditorHighlightingPass> list4 = Collections.emptyList();
            if (list4 == null) {
                TextEditorBackgroundHighlighter.$$$reportNull$$$0(5);
            }
            return list4;
        }
        TextEditorHighlightingPassRegistrarEx passRegistrar = TextEditorHighlightingPassRegistrarEx.getInstanceEx(this.myProject);
        List<TextEditorHighlightingPass> list5 = passRegistrar.instantiatePasses(this.myFile, this.myEditor, passesToIgnore);
        if (list5 == null) {
            TextEditorBackgroundHighlighter.$$$reportNull$$$0(6);
        }
        return list5;
    }

    @NotNull
    public TextEditorHighlightingPass[] createPassesForVisibleArea() {
        TextEditorHighlightingPass[] textEditorHighlightingPassArray = this.createPassesForEditor();
        if (textEditorHighlightingPassArray == null) {
            TextEditorBackgroundHighlighter.$$$reportNull$$$0(7);
        }
        return textEditorHighlightingPassArray;
    }

    @NotNull
    public TextEditorHighlightingPass[] createPassesForEditor() {
        List<TextEditorHighlightingPass> passes = this.getPasses(ArrayUtil.EMPTY_INT_ARRAY);
        TextEditorHighlightingPass[] textEditorHighlightingPassArray = passes.isEmpty() ? TextEditorHighlightingPass.EMPTY_ARRAY : passes.toArray(new TextEditorHighlightingPass[passes.size()]);
        if (textEditorHighlightingPassArray == null) {
            TextEditorBackgroundHighlighter.$$$reportNull$$$0(8);
        }
        return textEditorHighlightingPassArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "passesToIgnore";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/TextEditorBackgroundHighlighter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/TextEditorBackgroundHighlighter";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPasses";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createPassesForVisibleArea";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createPassesForEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPasses";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

