/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.actions;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSuppressByNoInspectionCommentFix
extends SuppressIntentionAction {
    @NotNull
    protected final String myID;
    private final boolean myReplaceOtherSuppressionIds;

    @Nullable
    protected abstract PsiElement getContainer(PsiElement var1);

    public AbstractSuppressByNoInspectionCommentFix(@NotNull String ID2, boolean replaceOtherSuppressionIds) {
        if (ID2 == null) {
            AbstractSuppressByNoInspectionCommentFix.$$$reportNull$$$0(0);
        }
        this.myID = ID2;
        this.myReplaceOtherSuppressionIds = replaceOtherSuppressionIds;
    }

    protected final void replaceSuppressionComment(@NotNull PsiElement comment) {
        if (comment == null) {
            AbstractSuppressByNoInspectionCommentFix.$$$reportNull$$$0(1);
        }
        SuppressionUtil.replaceSuppressionComment(comment, this.myID, this.myReplaceOtherSuppressionIds, this.getCommentLanguage(comment));
    }

    protected void createSuppression(@NotNull Project project2, @NotNull PsiElement element, @NotNull PsiElement container) throws IncorrectOperationException {
        if (project2 == null) {
            AbstractSuppressByNoInspectionCommentFix.$$$reportNull$$$0(2);
        }
        if (element == null) {
            AbstractSuppressByNoInspectionCommentFix.$$$reportNull$$$0(3);
        }
        if (container == null) {
            AbstractSuppressByNoInspectionCommentFix.$$$reportNull$$$0(4);
        }
        SuppressionUtil.createSuppression(project2, container, this.myID, this.getCommentLanguage(element));
    }

    @NotNull
    protected Language getCommentLanguage(@NotNull PsiElement element) {
        if (element == null) {
            AbstractSuppressByNoInspectionCommentFix.$$$reportNull$$$0(5);
        }
        Language language = element.getLanguage();
        if (language == null) {
            AbstractSuppressByNoInspectionCommentFix.$$$reportNull$$$0(6);
        }
        return language;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement context) {
        if (project2 == null) {
            AbstractSuppressByNoInspectionCommentFix.$$$reportNull$$$0(7);
        }
        if (context == null) {
            AbstractSuppressByNoInspectionCommentFix.$$$reportNull$$$0(8);
        }
        return context.isValid() && context.getManager().isInProject(context) && this.getContainer(context) != null;
    }

    public void invoke(@NotNull Project project2, @Nullable Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        boolean caretWasBeforeStatement;
        PsiElement container;
        block8: {
            if (project2 == null) {
                AbstractSuppressByNoInspectionCommentFix.$$$reportNull$$$0(9);
            }
            if (element == null) {
                AbstractSuppressByNoInspectionCommentFix.$$$reportNull$$$0(10);
            }
            if ((container = this.getContainer(element)) == null) {
                return;
            }
            List<? extends PsiElement> comments = this.getCommentsFor(container);
            if (comments != null) {
                for (PsiElement psiElement : comments) {
                    if (!(psiElement instanceof PsiComment) || !SuppressionUtil.isSuppressionComment(psiElement)) continue;
                    this.replaceSuppressionComment(psiElement);
                    return;
                }
            }
            caretWasBeforeStatement = editor != null && editor.getCaretModel().getOffset() == container.getTextRange().getStartOffset();
            try {
                this.createSuppression(project2, element, container);
            }
            catch (IncorrectOperationException incorrectOperationException) {
                if (ApplicationManager.getApplication().isUnitTestMode() || editor == null) break block8;
                Messages.showErrorDialog((Component)editor.getComponent(), (String)InspectionsBundle.message((String)"suppress.inspection.annotation.syntax.error", (Object[])new Object[]{incorrectOperationException.getMessage()}));
            }
        }
        if (caretWasBeforeStatement) {
            editor.getCaretModel().moveToOffset(container.getTextRange().getStartOffset());
        }
        UndoUtil.markPsiFileForUndo((PsiFile)element.getContainingFile());
    }

    @Nullable
    protected List<? extends PsiElement> getCommentsFor(@NotNull PsiElement container) {
        PsiElement prev;
        if (container == null) {
            AbstractSuppressByNoInspectionCommentFix.$$$reportNull$$$0(11);
        }
        if ((prev = PsiTreeUtil.skipWhitespacesBackward((PsiElement)container)) == null) {
            return null;
        }
        return Collections.singletonList(prev);
    }

    @NotNull
    public String getFamilyName() {
        String string = InspectionsBundle.message((String)"suppress.inspection.family", (Object[])new Object[0]);
        if (string == null) {
            AbstractSuppressByNoInspectionCommentFix.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ID";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 2: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/actions/AbstractSuppressByNoInspectionCommentFix";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/actions/AbstractSuppressByNoInspectionCommentFix";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentLanguage";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "replaceSuppressionComment";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createSuppression";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCommentLanguage";
                break;
            }
            case 6: 
            case 12: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCommentsFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

