/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.actions;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.actions.AbstractBatchSuppressByNoInspectionCommentFix;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.storage.ClassPathStorageUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuppressFix
extends AbstractBatchSuppressByNoInspectionCommentFix {
    private String myAlternativeID;

    public SuppressFix(@NotNull HighlightDisplayKey key2) {
        if (key2 == null) {
            SuppressFix.$$$reportNull$$$0(0);
        }
        this(key2.getID());
        this.myAlternativeID = HighlightDisplayKey.getAlternativeID((HighlightDisplayKey)key2);
    }

    public SuppressFix(@NotNull String ID2) {
        if (ID2 == null) {
            SuppressFix.$$$reportNull$$$0(1);
        }
        super(ID2, false);
    }

    @Override
    @NotNull
    public String getText() {
        String myText = super.getText();
        String string = StringUtil.isEmpty((String)myText) ? InspectionsBundle.message((String)"suppress.inspection.member", (Object[])new Object[0]) : myText;
        if (string == null) {
            SuppressFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public PsiJavaDocumentedElement getContainer(PsiElement context) {
        if (context == null || !context.getManager().isInProject(context)) {
            return null;
        }
        PsiFile containingFile = context.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        if (!containingFile.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE) || context instanceof PsiFile) {
            return null;
        }
        PsiElement container = context;
        while (container instanceof PsiAnonymousClass || !(container instanceof PsiJavaDocumentedElement) || container instanceof PsiTypeParameter) {
            if ((container = PsiTreeUtil.getParentOfType((PsiElement)container, PsiJavaDocumentedElement.class)) != null) continue;
            return null;
        }
        return container instanceof SyntheticElement ? null : (PsiJavaDocumentedElement)container;
    }

    @Override
    public boolean isAvailable(@NotNull Project project2, @NotNull PsiElement context) {
        PsiJavaDocumentedElement container;
        boolean isValid;
        if (project2 == null) {
            SuppressFix.$$$reportNull$$$0(3);
        }
        if (context == null) {
            SuppressFix.$$$reportNull$$$0(4);
        }
        boolean bl = isValid = (container = this.getContainer(context)) != null && (!(container instanceof PsiMethod) || !(container instanceof SyntheticElement));
        if (!isValid) {
            return false;
        }
        if (container instanceof PsiJavaModule) {
            this.setText(InspectionsBundle.message((String)"suppress.inspection.module", (Object[])new Object[0]));
        } else if (container instanceof PsiClass) {
            this.setText(InspectionsBundle.message((String)"suppress.inspection.class", (Object[])new Object[0]));
        } else if (container instanceof PsiMethod) {
            this.setText(InspectionsBundle.message((String)"suppress.inspection.method", (Object[])new Object[0]));
        } else {
            this.setText(InspectionsBundle.message((String)"suppress.inspection.field", (Object[])new Object[0]));
        }
        return true;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public void invoke(@NotNull Project project2, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project2 == null) {
            SuppressFix.$$$reportNull$$$0(5);
        }
        if (element == null) {
            SuppressFix.$$$reportNull$$$0(6);
        }
        if (this.doSuppress(project2, this.getContainer(element))) {
            return;
        }
        UndoUtil.markPsiFileForUndo((PsiFile)element.getContainingFile());
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = InspectionsBundle.message((String)"suppress.inspection.member", (Object[])new Object[0]);
        if (string == null) {
            SuppressFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    private boolean doSuppress(@NotNull Project project2, PsiJavaDocumentedElement container) {
        if (project2 == null) {
            SuppressFix.$$$reportNull$$$0(8);
        }
        assert (container != null);
        if (container instanceof PsiModifierListOwner && this.use15Suppressions(container)) {
            PsiModifierListOwner modifierOwner = (PsiModifierListOwner)container;
            PsiModifierList modifierList = modifierOwner.getModifierList();
            if (modifierList != null) {
                JavaSuppressionUtil.addSuppressAnnotation(project2, (PsiElement)container, modifierOwner, this.getID((PsiElement)container));
            }
        } else {
            WriteCommandAction.runWriteCommandAction((Project)project2, null, null, () -> {
                if (project2 == null) {
                    SuppressFix.$$$reportNull$$$0(14);
                }
                this.suppressByDocComment(project2, container);
            }, (PsiFile[])new PsiFile[]{container.getContainingFile()});
        }
        return false;
    }

    private void suppressByDocComment(@NotNull Project project2, PsiJavaDocumentedElement container) {
        PsiDocComment docComment;
        if (project2 == null) {
            SuppressFix.$$$reportNull$$$0(9);
        }
        if ((docComment = container.getDocComment()) == null) {
            String commentText = "/** @noinspection " + this.getID((PsiElement)container) + "*/";
            docComment = JavaPsiFacade.getElementFactory((Project)project2).createDocCommentFromText(commentText);
            PsiElement firstChild = container.getFirstChild();
            container.addBefore((PsiElement)docComment, firstChild);
        } else {
            PsiDocTag noInspectionTag = docComment.findTagByName("noinspection");
            if (noInspectionTag != null) {
                String tagText = noInspectionTag.getText() + ", " + this.getID((PsiElement)container);
                noInspectionTag.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)project2).createDocTagFromText(tagText));
            } else {
                String tagText = "@noinspection " + this.getID((PsiElement)container);
                docComment.add((PsiElement)JavaPsiFacade.getElementFactory((Project)project2).createDocTagFromText(tagText));
            }
        }
    }

    protected boolean use15Suppressions(@NotNull PsiJavaDocumentedElement container) {
        if (container == null) {
            SuppressFix.$$$reportNull$$$0(10);
        }
        return JavaSuppressionUtil.canHave15Suppressions((PsiElement)container) && !JavaSuppressionUtil.alreadyHas14Suppressions(container) && !SuppressFix.isInjectedToStringLiteral(container);
    }

    private static boolean isInjectedToStringLiteral(@NotNull PsiJavaDocumentedElement container) {
        if (container == null) {
            SuppressFix.$$$reportNull$$$0(11);
        }
        return JavaResolveUtil.findParentContextOfClass((PsiElement)container, PsiLiteralExpression.class, true) != null;
    }

    private String getID(@NotNull PsiElement place) {
        String id;
        if (place == null) {
            SuppressFix.$$$reportNull$$$0(12);
        }
        return (id = SuppressFix.getID(place, this.myAlternativeID)) != null ? id : this.myID;
    }

    @Nullable
    static String getID(@NotNull PsiElement place, String alternativeID) {
        Module module2;
        if (place == null) {
            SuppressFix.$$$reportNull$$$0(13);
        }
        if (alternativeID != null && (module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)place)) != null && ClassPathStorageUtil.isClasspathStorage(module2)) {
            return alternativeID;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ID";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/actions/SuppressFix";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/actions/SuppressFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 7: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doSuppress";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "suppressByDocComment";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "use15Suppressions";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isInjectedToStringLiteral";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getID";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doSuppress$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

