/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.JavaProjectModelModificationService;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

class AddExtLibraryDependencyFix
extends OrderEntryFix {
    private final Module myCurrentModule;
    private final ExternalLibraryDescriptor myLibraryDescriptor;
    private final DependencyScope myScope;
    private final String myQualifiedClassName;

    public AddExtLibraryDependencyFix(PsiReference reference, Module currentModule, ExternalLibraryDescriptor descriptor2, DependencyScope scope, String qName) {
        super(reference);
        this.myCurrentModule = currentModule;
        this.myLibraryDescriptor = descriptor2;
        this.myScope = scope;
        this.myQualifiedClassName = qName;
    }

    @Nls
    @NotNull
    public String getText() {
        String string = "Add '" + this.myLibraryDescriptor.getPresentableName() + "' to classpath";
        if (string == null) {
            AddExtLibraryDependencyFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            AddExtLibraryDependencyFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            AddExtLibraryDependencyFix.$$$reportNull$$$0(2);
        }
        return !project2.isDisposed() && !this.myCurrentModule.isDisposed();
    }

    public void invoke(@NotNull Project project2, final Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            AddExtLibraryDependencyFix.$$$reportNull$$$0(3);
        }
        JavaProjectModelModificationService.getInstance(project2).addDependency(this.myCurrentModule, this.myLibraryDescriptor, this.myScope).done(aVoid -> new WriteAction(){

            protected void run(@NotNull Result result2) {
                if (result2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    OrderEntryFix.importClass(AddExtLibraryDependencyFix.this.myCurrentModule, editor, AddExtLibraryDependencyFix.this.restoreReference(), AddExtLibraryDependencyFix.this.myQualifiedClassName);
                }
                catch (IndexNotReadyException e) {
                    Logger.getInstance(AddExtLibraryDependencyFix.class).info((Throwable)e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/daemon/impl/quickfix/AddExtLibraryDependencyFix$1", "run"));
            }
        }.execute());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/AddExtLibraryDependencyFix";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/AddExtLibraryDependencyFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

