/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.JavaProjectModelModificationService;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AddLibraryDependencyFix
extends OrderEntryFix {
    private final Module myCurrentModule;
    private final Library myLibrary;
    private final DependencyScope myScope;
    private final boolean myExported;
    private final String myQualifiedClassName;

    public AddLibraryDependencyFix(PsiReference reference, Module currentModule, Library library, DependencyScope scope, boolean exported, String qName) {
        super(reference);
        this.myCurrentModule = currentModule;
        this.myLibrary = library;
        this.myScope = scope;
        this.myExported = exported;
        this.myQualifiedClassName = qName;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("orderEntry.fix.add.library.to.classpath", LibraryUtil.getPresentableName((Library)this.myLibrary));
        if (string == null) {
            AddLibraryDependencyFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("orderEntry.fix.family.add.library.to.classpath", new Object[0]);
        if (string == null) {
            AddLibraryDependencyFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            AddLibraryDependencyFix.$$$reportNull$$$0(2);
        }
        return !project2.isDisposed() && !this.myCurrentModule.isDisposed() && !((LibraryEx)this.myLibrary).isDisposed();
    }

    public void invoke(@NotNull Project project2, @Nullable Editor editor, PsiFile file2) {
        if (project2 == null) {
            AddLibraryDependencyFix.$$$reportNull$$$0(3);
        }
        WriteAction.run(() -> {
            if (project2 == null) {
                AddLibraryDependencyFix.$$$reportNull$$$0(4);
            }
            JavaProjectModelModificationService.getInstance(project2).addDependency(this.myCurrentModule, this.myLibrary, this.myScope, this.myExported);
        });
        if (this.myQualifiedClassName != null && editor != null) {
            AddLibraryDependencyFix.importClass(this.myCurrentModule, editor, this.restoreReference(), this.myQualifiedClassName);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/AddLibraryDependencyFix";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/AddLibraryDependencyFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invoke$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

