/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddMethodQualifierFix
implements IntentionAction {
    private static final boolean UNIT_TEST_MODE = ApplicationManager.getApplication().isUnitTestMode();
    private final SmartPsiElementPointer<PsiMethodCallExpression> myMethodCall;
    private List<PsiVariable> myCandidates;

    public AddMethodQualifierFix(PsiMethodCallExpression methodCallExpression) {
        this.myMethodCall = SmartPointerManager.getInstance((Project)methodCallExpression.getProject()).createSmartPsiElementPointer((PsiElement)methodCallExpression);
    }

    @NotNull
    public String getText() {
        if (this.myCandidates == null || this.myCandidates.isEmpty()) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                if ("" == null) {
                    AddMethodQualifierFix.$$$reportNull$$$0(0);
                }
                return "";
            }
            throw new IllegalStateException();
        }
        if (this.myCandidates.size() == 1) {
            String string = QuickFixBundle.message("add.method.qualifier.fix.text", this.myCandidates.get(0).getName());
            if (string == null) {
                AddMethodQualifierFix.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = this.getFamilyName();
        if (string == null) {
            AddMethodQualifierFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("add.method.qualifier.fix.family", new Object[0]);
        if (string == null) {
            AddMethodQualifierFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        PsiMethodCallExpression element;
        if (project2 == null) {
            AddMethodQualifierFix.$$$reportNull$$$0(4);
        }
        if ((element = (PsiMethodCallExpression)this.myMethodCall.getElement()) == null || !element.isValid()) {
            return false;
        }
        if (this.myCandidates == null) {
            this.myCandidates = this.findCandidates(SearchMode.MAX_2_CANDIDATES);
        }
        return !this.myCandidates.isEmpty();
    }

    private List<PsiVariable> findCandidates(@NotNull SearchMode mode) {
        if (mode == null) {
            AddMethodQualifierFix.$$$reportNull$$$0(5);
        }
        ArrayList<PsiVariable> candidates = new ArrayList<PsiVariable>();
        PsiMethodCallExpression methodCallElement = (PsiMethodCallExpression)this.myMethodCall.getElement();
        String methodName = methodCallElement.getMethodExpression().getReferenceName();
        if (methodName == null) {
            return Collections.emptyList();
        }
        for (PsiVariable var : CreateFromUsageUtils.guessMatchingVariables((PsiExpression)methodCallElement)) {
            PsiClass resolvedClass;
            PsiType type2;
            if (var.getName() == null || !((type2 = var.getType()) instanceof PsiClassType) || (resolvedClass = ((PsiClassType)type2).resolve()) == null || resolvedClass.findMethodsByName(methodName, true).length <= 0) continue;
            candidates.add(var);
            if (mode != SearchMode.MAX_2_CANDIDATES || candidates.size() < 2) continue;
            return candidates;
        }
        return candidates;
    }

    public List<PsiVariable> getCandidates() {
        return this.findCandidates(SearchMode.FULL_SEARCH);
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        if (currentFile == null) {
            AddMethodQualifierFix.$$$reportNull$$$0(6);
        }
        return this.myMethodCall.getElement();
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        List<PsiVariable> candidates;
        if (project2 == null) {
            AddMethodQualifierFix.$$$reportNull$$$0(7);
        }
        if ((candidates = this.findCandidates(SearchMode.FULL_SEARCH)).size() == 1 || UNIT_TEST_MODE) {
            this.qualify(candidates.get(0), editor);
        } else {
            this.chooseAndQualify(editor, candidates);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    private void chooseAndQualify(final Editor editor, List<PsiVariable> candidates) {
        BaseListPopupStep<PsiVariable> step = new BaseListPopupStep<PsiVariable>(QuickFixBundle.message("add.qualifier", new Object[0]), candidates){

            public PopupStep onChosen(PsiVariable selectedValue, boolean finalChoice) {
                if (selectedValue != null && finalChoice) {
                    AddMethodQualifierFix.this.qualify(selectedValue, editor);
                }
                return FINAL_CHOICE;
            }

            @NotNull
            public String getTextFor(PsiVariable value2) {
                String string = value2.getName();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            public Icon getIconFor(PsiVariable aValue) {
                return aValue.getIcon(0);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddMethodQualifierFix$1", "getTextFor"));
            }
        };
        ListPopupImpl popup2 = new ListPopupImpl((ListPopupStep)step);
        popup2.showInBestPositionFor(editor);
    }

    private void qualify(PsiVariable qualifier, Editor editor) {
        WriteCommandAction.runWriteCommandAction((Project)qualifier.getProject(), () -> {
            String qualifierPresentableText = qualifier.getName();
            PsiMethodCallExpression oldExpression = (PsiMethodCallExpression)this.myMethodCall.getElement();
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)qualifier.getProject());
            PsiExpression expression2 = elementFactory.createExpressionFromText(qualifierPresentableText + "." + oldExpression.getMethodExpression().getReferenceName() + "()", null);
            PsiElement replacedExpression = oldExpression.replace((PsiElement)expression2);
            editor.getCaretModel().moveToOffset(replacedExpression.getTextOffset() + replacedExpression.getTextLength());
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/AddMethodQualifierFix";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/AddMethodQualifierFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findCandidates";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum SearchMode {
        MAX_2_CANDIDATES,
        FULL_SEARCH;

    }
}

