/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.AddExceptionToThrowsFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class AddRuntimeExceptionToThrowsAction
implements IntentionAction {
    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("add.runtime.exception.to.throws.text", new Object[0]);
        if (string == null) {
            AddRuntimeExceptionToThrowsAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            AddRuntimeExceptionToThrowsAction.$$$reportNull$$$0(1);
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        PsiClassType aClass = AddRuntimeExceptionToThrowsAction.getRuntimeExceptionAtCaret(editor, file2);
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)AddRuntimeExceptionToThrowsAction.elementAtCaret(editor, file2), PsiMethod.class);
        AddExceptionToThrowsFix.addExceptionsToThrowsList(project2, method, Collections.singleton(aClass));
    }

    private static boolean isMethodThrows(PsiMethod method, PsiClassType exception) {
        PsiClassType[] throwsTypes;
        for (PsiClassType throwsType : throwsTypes = method.getThrowsList().getReferencedTypes()) {
            if (!throwsType.isAssignableFrom((PsiType)exception)) continue;
            return true;
        }
        return false;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            AddRuntimeExceptionToThrowsAction.$$$reportNull$$$0(2);
        }
        if (!(file2 instanceof PsiJavaFile)) {
            return false;
        }
        PsiClassType exception = AddRuntimeExceptionToThrowsAction.getRuntimeExceptionAtCaret(editor, file2);
        if (exception == null) {
            return false;
        }
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)AddRuntimeExceptionToThrowsAction.elementAtCaret(editor, file2), PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiLambdaExpression.class});
        if (method == null || !method.getThrowsList().isPhysical()) {
            return false;
        }
        return !AddRuntimeExceptionToThrowsAction.isMethodThrows(method, exception);
    }

    private static PsiClassType getRuntimeExceptionAtCaret(Editor editor, PsiFile file2) {
        PsiElement element = AddRuntimeExceptionToThrowsAction.elementAtCaret(editor, file2);
        if (element == null) {
            return null;
        }
        PsiThrowStatement expression2 = (PsiThrowStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiThrowStatement.class);
        if (expression2 == null) {
            return null;
        }
        PsiExpression exception = expression2.getException();
        if (exception == null) {
            return null;
        }
        PsiType type2 = exception.getType();
        if (!(type2 instanceof PsiClassType)) {
            return null;
        }
        if (!ExceptionUtil.isUncheckedException((PsiClassType)type2)) {
            return null;
        }
        return (PsiClassType)type2;
    }

    private static PsiElement elementAtCaret(Editor editor, PsiFile file2) {
        int offset = editor.getCaretModel().getOffset();
        return file2.findElementAt(offset);
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("add.runtime.exception.to.throws.family", new Object[0]);
        if (string == null) {
            AddRuntimeExceptionToThrowsAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/AddRuntimeExceptionToThrowsAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/AddRuntimeExceptionToThrowsAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

