/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.quickfix.ChangeMethodSignatureFromUsageFix;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.util.RefactoringUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ChangeMethodSignatureFromUsageReverseOrderFix
extends ChangeMethodSignatureFromUsageFix {
    public ChangeMethodSignatureFromUsageReverseOrderFix(@NotNull PsiMethod targetMethod, @NotNull PsiExpression[] expressions2, @NotNull PsiSubstitutor substitutor, @NotNull PsiElement context, boolean changeAllUsages, int minUsagesNumberToShowDialog) {
        if (targetMethod == null) {
            ChangeMethodSignatureFromUsageReverseOrderFix.$$$reportNull$$$0(0);
        }
        if (expressions2 == null) {
            ChangeMethodSignatureFromUsageReverseOrderFix.$$$reportNull$$$0(1);
        }
        if (substitutor == null) {
            ChangeMethodSignatureFromUsageReverseOrderFix.$$$reportNull$$$0(2);
        }
        if (context == null) {
            ChangeMethodSignatureFromUsageReverseOrderFix.$$$reportNull$$$0(3);
        }
        super(targetMethod, expressions2, substitutor, context, changeAllUsages, minUsagesNumberToShowDialog);
    }

    @Override
    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            ChangeMethodSignatureFromUsageReverseOrderFix.$$$reportNull$$$0(4);
        }
        if (this.myTargetMethod.isValid() && this.myExpressions.length > this.myTargetMethod.getParameterList().getParametersCount() && super.isAvailable(project2, editor, file2)) {
            ArrayList<ParameterInfoImpl> result2 = new ArrayList<ParameterInfoImpl>();
            if (super.findNewParamsPlace(this.myExpressions, this.myTargetMethod, this.mySubstitutor, new StringBuilder(), new HashSet<ParameterInfoImpl>(), this.myTargetMethod.getParameterList().getParameters(), result2)) {
                if (this.myNewParametersInfo.length != result2.size()) {
                    return true;
                }
                int size = result2.size();
                for (int i = 0; i < size; ++i) {
                    ParameterInfoImpl info = result2.get(i);
                    info.setName(this.myNewParametersInfo[i].getName());
                    if (this.myNewParametersInfo[i].equals(info)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    protected boolean findNewParamsPlace(PsiExpression[] expressions2, PsiMethod targetMethod, PsiSubstitutor substitutor, StringBuilder buf, HashSet<ParameterInfoImpl> newParams, PsiParameter[] parameters2, List<ParameterInfoImpl> result2) {
        HashSet<String> existingNames = new HashSet<String>();
        for (PsiParameter parameter2 : parameters2) {
            existingNames.add(parameter2.getName());
        }
        int ei = expressions2.length - 1;
        int pi = parameters2.length - 1;
        PsiParameter varargParam = targetMethod.isVarArgs() ? parameters2[parameters2.length - 1] : null;
        ArrayList<String> params = new ArrayList<String>();
        while (ei >= 0 || pi >= 0) {
            PsiType type2;
            boolean parameterAssignable;
            PsiExpression expression2 = ei >= 0 ? expressions2[ei] : null;
            PsiParameter parameter3 = pi >= 0 ? parameters2[pi] : null;
            PsiType paramType = parameter3 == null ? null : substitutor.substitute(parameter3.getType());
            boolean bl = parameterAssignable = paramType != null && (expression2 == null || TypeConversionUtil.areTypesAssignmentCompatible((PsiType)paramType, (PsiExpression)expression2));
            if (parameterAssignable) {
                type2 = parameter3.getType();
                result2.add(0, new ParameterInfoImpl(pi, parameter3.getName(), type2));
                params.add(0, ChangeMethodSignatureFromUsageReverseOrderFix.escapePresentableType(type2));
                --pi;
                --ei;
                continue;
            }
            if (ChangeMethodSignatureFromUsageReverseOrderFix.isArgumentInVarargPosition(expressions2, ei, varargParam, substitutor)) {
                if (pi == parameters2.length - 1) {
                    assert (varargParam != null);
                    type2 = varargParam.getType();
                    result2.add(0, new ParameterInfoImpl(pi, varargParam.getName(), type2));
                    params.add(0, ChangeMethodSignatureFromUsageReverseOrderFix.escapePresentableType(type2));
                }
                --pi;
                --ei;
                continue;
            }
            if (expression2 == null) continue;
            if (varargParam != null && pi >= parameters2.length) {
                return false;
            }
            PsiType exprType = RefactoringUtil.getTypeByExpression(expression2);
            if (exprType == null) {
                return false;
            }
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)expression2.getProject());
            String name2 = ChangeMethodSignatureFromUsageReverseOrderFix.suggestUniqueParameterName(codeStyleManager, expression2, exprType, existingNames);
            ParameterInfoImpl newParameterInfo = new ParameterInfoImpl(-1, name2, exprType, expression2.getText().replace('\n', ' '));
            result2.add(0, newParameterInfo);
            newParams.add(newParameterInfo);
            params.add(0, "<b>" + ChangeMethodSignatureFromUsageReverseOrderFix.escapePresentableType(exprType) + "</b>");
            --ei;
        }
        if (result2.size() != expressions2.length && varargParam == null) {
            return false;
        }
        buf.append(StringUtil.join(params, (String)", "));
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetMethod";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/ChangeMethodSignatureFromUsageReverseOrderFix";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

