/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.GetterSetterPrototypeProvider;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateGetterOrSetterFix
implements IntentionAction,
LowPriorityAction {
    private final boolean myCreateGetter;
    private final boolean myCreateSetter;
    private final PsiField myField;
    private final String myPropertyName;

    public CreateGetterOrSetterFix(boolean createGetter, boolean createSetter, @NotNull PsiField field) {
        if (field == null) {
            CreateGetterOrSetterFix.$$$reportNull$$$0(0);
        }
        this.myCreateGetter = createGetter;
        this.myCreateSetter = createSetter;
        this.myField = field;
        this.myPropertyName = PropertyUtilBase.suggestPropertyName((PsiField)field);
    }

    @NotNull
    public String getText() {
        String what;
        if (this.myCreateGetter && this.myCreateSetter) {
            what = "create.getter.and.setter.for.field";
        } else if (this.myCreateGetter) {
            what = "create.getter.for.field";
        } else if (this.myCreateSetter) {
            what = "create.setter.for.field";
        } else {
            what = "";
            assert (false);
        }
        String string = QuickFixBundle.message(what, this.myField.getName());
        if (string == null) {
            CreateGetterOrSetterFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("create.accessor.for.unused.field.family", new Object[0]);
        if (string == null) {
            CreateGetterOrSetterFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            CreateGetterOrSetterFix.$$$reportNull$$$0(3);
        }
        if (!this.myField.isValid()) {
            return false;
        }
        PsiClass aClass = this.myField.getContainingClass();
        if (aClass == null) {
            return false;
        }
        if (this.myCreateGetter && (CreateGetterOrSetterFix.isStaticFinal(this.myField) || PropertyUtilBase.findPropertyGetter((PsiClass)aClass, (String)this.myPropertyName, (boolean)CreateGetterOrSetterFix.isStatic(this.myField), (boolean)false) != null)) {
            return false;
        }
        return !this.myCreateSetter || !CreateGetterOrSetterFix.isFinal(this.myField) && PropertyUtilBase.findPropertySetter((PsiClass)aClass, (String)this.myPropertyName, (boolean)CreateGetterOrSetterFix.isStatic(this.myField), (boolean)false) == null;
    }

    private static boolean isFinal(@NotNull PsiField field) {
        if (field == null) {
            CreateGetterOrSetterFix.$$$reportNull$$$0(4);
        }
        return field.hasModifierProperty("final");
    }

    private static boolean isStatic(@NotNull PsiField field) {
        if (field == null) {
            CreateGetterOrSetterFix.$$$reportNull$$$0(5);
        }
        return field.hasModifierProperty("static");
    }

    private static boolean isStaticFinal(@NotNull PsiField field) {
        if (field == null) {
            CreateGetterOrSetterFix.$$$reportNull$$$0(6);
        }
        return CreateGetterOrSetterFix.isStatic(field) && CreateGetterOrSetterFix.isFinal(field);
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        if (currentFile == null) {
            CreateGetterOrSetterFix.$$$reportNull$$$0(7);
        }
        return this.myField;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            CreateGetterOrSetterFix.$$$reportNull$$$0(8);
        }
        PsiClass aClass = this.myField.getContainingClass();
        ArrayList methods = new ArrayList();
        if (this.myCreateGetter) {
            Collections.addAll(methods, GetterSetterPrototypeProvider.generateGetterSetters(this.myField, true));
        }
        if (this.myCreateSetter) {
            Collections.addAll(methods, GetterSetterPrototypeProvider.generateGetterSetters(this.myField, false));
        }
        assert (aClass != null);
        JavaCodeStyleManager manager = JavaCodeStyleManager.getInstance((Project)aClass.getProject());
        for (PsiMethod method : methods) {
            PsiElement newMember = GenerateMembersUtil.insert(aClass, (PsiMember)method, null, true);
            manager.shortenClassReferences(newMember);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/CreateGetterOrSetterFix";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/CreateGetterOrSetterFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isFinal";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isStatic";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isStaticFinal";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

