/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.ArgumentFixerActionFactory;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;

public abstract class MethodArgumentFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance(MethodArgumentFix.class);
    protected final PsiExpressionList myArgList;
    protected final int myIndex;
    protected final ArgumentFixerActionFactory myArgumentFixerActionFactory;
    protected final PsiType myToType;

    protected MethodArgumentFix(@NotNull PsiExpressionList list2, int i, @NotNull PsiType toType, @NotNull ArgumentFixerActionFactory fixerActionFactory) {
        if (list2 == null) {
            MethodArgumentFix.$$$reportNull$$$0(0);
        }
        if (toType == null) {
            MethodArgumentFix.$$$reportNull$$$0(1);
        }
        if (fixerActionFactory == null) {
            MethodArgumentFix.$$$reportNull$$$0(2);
        }
        this.myArgList = list2;
        this.myIndex = i;
        this.myArgumentFixerActionFactory = fixerActionFactory;
        this.myToType = toType instanceof PsiEllipsisType ? ((PsiEllipsisType)toType).toArrayType() : toType;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            MethodArgumentFix.$$$reportNull$$$0(3);
        }
        return this.myToType != null && this.myToType.isValid() && this.myArgList.getExpressions().length > this.myIndex && this.myArgList.getExpressions()[this.myIndex] != null && this.myArgList.getExpressions()[this.myIndex].isValid();
    }

    public boolean startInWriteAction() {
        return true;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) {
        PsiExpression expression2;
        if (project2 == null) {
            MethodArgumentFix.$$$reportNull$$$0(4);
        }
        LOG.assertTrue((expression2 = this.myArgList.getExpressions()[this.myIndex]) != null && expression2.isValid());
        PsiExpression modified = this.myArgumentFixerActionFactory.getModifiedArgument(expression2, this.myToType);
        LOG.assertTrue(modified != null, (Object)this.myArgumentFixerActionFactory);
        expression2.replace((PsiElement)modified);
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("fix.argument.family", new Object[0]);
        if (string == null) {
            MethodArgumentFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixerActionFactory";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/MethodArgumentFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/MethodArgumentFix";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

