/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.StaticImportMemberFix;
import com.intellij.codeInsight.daemon.impl.quickfix.StaticImportMethodQuestionAction;
import com.intellij.codeInsight.daemon.impl.quickfix.StaticMembersProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Processor;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StaticImportConstantFix
extends StaticImportMemberFix<PsiField> {
    protected final SmartPsiElementPointer<PsiJavaCodeReferenceElement> myRef;

    public StaticImportConstantFix(@NotNull PsiJavaCodeReferenceElement referenceElement) {
        if (referenceElement == null) {
            StaticImportConstantFix.$$$reportNull$$$0(0);
        }
        this.myRef = SmartPointerManager.getInstance((Project)referenceElement.getProject()).createSmartPsiElementPointer((PsiElement)referenceElement);
    }

    @Override
    @NotNull
    protected String getBaseText() {
        String string = QuickFixBundle.message("static.import.constant.text", new Object[0]);
        if (string == null) {
            StaticImportConstantFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected String getMemberPresentableText(PsiField field) {
        String string = PsiFormatUtil.formatVariable((PsiVariable)field, (int)6145, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        if (string == null) {
            StaticImportConstantFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    protected List<PsiField> getMembersToImport(boolean applicableOnly, @NotNull StaticMembersProcessor.SearchMode searchMode) {
        String name2;
        if (searchMode == null) {
            StaticImportConstantFix.$$$reportNull$$$0(3);
        }
        Project project2 = this.myRef.getProject();
        PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)project2);
        PsiJavaCodeReferenceElement element = (PsiJavaCodeReferenceElement)this.myRef.getElement();
        String string = name2 = element != null ? element.getReferenceName() : null;
        if (name2 == null) {
            List<PsiField> list2 = Collections.emptyList();
            if (list2 == null) {
                StaticImportConstantFix.$$$reportNull$$$0(4);
            }
            return list2;
        }
        if (element instanceof PsiExpression && PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)element)) || element.getParent() instanceof PsiTypeElement || element.getParent() instanceof PsiAnnotation) {
            List<PsiField> list3 = Collections.emptyList();
            if (list3 == null) {
                StaticImportConstantFix.$$$reportNull$$$0(5);
            }
            return list3;
        }
        StaticMembersProcessor<PsiField> processor2 = new StaticMembersProcessor<PsiField>((PsiElement)element, this.showMembersFromDefaultPackage(), searchMode){

            @Override
            protected boolean isApplicable(PsiField field, PsiElement place) {
                PsiType expectedType = this.getExpectedType();
                return expectedType == null || TypeConversionUtil.isAssignable((PsiType)expectedType, (PsiType)field.getType());
            }
        };
        cache.processFieldsWithName(name2, (Processor)processor2, element.getResolveScope(), null);
        List<PsiField> list4 = processor2.getMembersToImport(applicableOnly);
        if (list4 == null) {
            StaticImportConstantFix.$$$reportNull$$$0(6);
        }
        return list4;
    }

    @NotNull
    protected StaticImportMethodQuestionAction<PsiField> createQuestionAction(List<PsiField> methodsToImport, @NotNull Project project2, Editor editor) {
        if (project2 == null) {
            StaticImportConstantFix.$$$reportNull$$$0(7);
        }
        StaticImportMethodQuestionAction<PsiField> staticImportMethodQuestionAction = new StaticImportMethodQuestionAction<PsiField>(project2, editor, methodsToImport, this.myRef){

            @Override
            @NotNull
            protected String getPopupTitle() {
                String string = QuickFixBundle.message("field.to.import.chooser.title", new Object[0]);
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportConstantFix$2", "getPopupTitle"));
            }
        };
        if (staticImportMethodQuestionAction == null) {
            StaticImportConstantFix.$$$reportNull$$$0(8);
        }
        return staticImportMethodQuestionAction;
    }

    @Override
    @Nullable
    protected PsiElement getElement() {
        return this.myRef.getElement();
    }

    @Override
    @Nullable
    protected PsiElement getQualifierExpression() {
        PsiJavaCodeReferenceElement element = (PsiJavaCodeReferenceElement)this.myRef.getElement();
        return element != null ? element.getQualifier() : null;
    }

    @Override
    @Nullable
    protected PsiElement resolveRef() {
        PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)this.getElement();
        return referenceElement != null ? referenceElement.advancedResolve(true).getElement() : null;
    }

    @Override
    protected boolean showMembersFromDefaultPackage() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceElement";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportConstantFix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchMode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportConstantFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberPresentableText";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMembersToImport";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createQuestionAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getMembersToImport";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createQuestionAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

