/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SurroundWithArrayFix
extends PsiElementBaseIntentionAction {
    private final PsiCall myMethodCall;
    @Nullable
    private final PsiExpression myExpression;

    public SurroundWithArrayFix(@Nullable PsiCall methodCall, @Nullable PsiExpression expression2) {
        this.myMethodCall = methodCall;
        this.myExpression = expression2;
    }

    @NotNull
    public String getText() {
        if ("Surround with array initialization" == null) {
            SurroundWithArrayFix.$$$reportNull$$$0(0);
        }
        return "Surround with array initialization";
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            SurroundWithArrayFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        if (project2 == null) {
            SurroundWithArrayFix.$$$reportNull$$$0(2);
        }
        if (element == null) {
            SurroundWithArrayFix.$$$reportNull$$$0(3);
        }
        return this.getExpression(element) != null;
    }

    @Nullable
    protected PsiExpression getExpression(PsiElement element) {
        if (this.myMethodCall == null || !this.myMethodCall.isValid()) {
            return this.myExpression == null || !this.myExpression.isValid() ? null : this.myExpression;
        }
        PsiMethod method = this.myMethodCall.resolveMethod();
        if (method != null) {
            PsiMethod psiMethod = method;
            return this.checkMethod(element, psiMethod);
        }
        if (this.myMethodCall instanceof PsiMethodCallExpression) {
            Collection<PsiElement> psiElements = TargetElementUtil.getInstance().getTargetCandidates((PsiReference)((PsiMethodCallExpression)this.myMethodCall).getMethodExpression());
            for (PsiElement psiElement : psiElements) {
                PsiExpression expression2;
                if (!(psiElement instanceof PsiMethod) || (expression2 = this.checkMethod(element, (PsiMethod)psiElement)) == null) continue;
                return expression2;
            }
        }
        return null;
    }

    @Nullable
    private PsiExpression checkMethod(PsiElement element, PsiMethod psiMethod) {
        PsiParameter[] psiParameters = psiMethod.getParameterList().getParameters();
        PsiExpressionList argumentList = this.myMethodCall.getArgumentList();
        int idx = 0;
        for (PsiExpression expression2 : argumentList.getExpressions()) {
            PsiType expressionType;
            PsiType paramType;
            if (element != null && PsiTreeUtil.isAncestor((PsiElement)expression2, (PsiElement)element, (boolean)false) && psiParameters.length > idx && (paramType = psiParameters[idx].getType()) instanceof PsiArrayType && (expressionType = TypeConversionUtil.erasure((PsiType)expression2.getType())) != null && PsiTypesUtil.isDenotableType((PsiType)expressionType) && expressionType != PsiType.NULL) {
                PsiType componentType = ((PsiArrayType)paramType).getComponentType();
                if (TypeConversionUtil.isAssignable((PsiType)componentType, (PsiType)expressionType)) {
                    return expression2;
                }
                PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)componentType);
                if (ArrayUtilRt.find((Object[])psiMethod.getTypeParameters(), (Object)psiClass) != -1) {
                    for (PsiClassType superType : psiClass.getSuperTypes()) {
                        if (!TypeConversionUtil.isAssignable((PsiType)superType, (PsiType)expressionType)) continue;
                        return expression2;
                    }
                }
            }
            ++idx;
        }
        return null;
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project2 == null) {
            SurroundWithArrayFix.$$$reportNull$$$0(4);
        }
        if (element == null) {
            SurroundWithArrayFix.$$$reportNull$$$0(5);
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
        PsiExpression expression2 = this.getExpression(element);
        assert (expression2 != null);
        PsiExpression toReplace = elementFactory.createExpressionFromText(SurroundWithArrayFix.getArrayCreation(expression2), element);
        JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences(expression2.replace((PsiElement)toReplace));
    }

    @NonNls
    private static String getArrayCreation(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            SurroundWithArrayFix.$$$reportNull$$$0(6);
        }
        PsiType expressionType = expression2.getType();
        assert (expressionType != null);
        PsiType arrayComponentType = TypeConversionUtil.erasure((PsiType)expressionType);
        return "new " + arrayComponentType.getCanonicalText() + "[]{" + expression2.getText() + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/SurroundWithArrayFix";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/SurroundWithArrayFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getArrayCreation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

