/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.quickFix;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.EmptyExpression;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.GenerateFieldOrPropertyHandler;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.GenerationInfo;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PropertyMemberType;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CreateFieldOrPropertyFix
implements IntentionAction,
LocalQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.codeInsight.daemon.quickFix.CreateFieldOrPropertyFix");
    private final PsiClass myClass;
    private final String myName;
    private final PsiType myType;
    private final PropertyMemberType myMemberType;
    private final PsiAnnotation[] myAnnotations;

    public CreateFieldOrPropertyFix(PsiClass aClass, String name2, PsiType type2, @NotNull PropertyMemberType memberType, PsiAnnotation[] annotations2) {
        if (memberType == null) {
            CreateFieldOrPropertyFix.$$$reportNull$$$0(0);
        }
        this.myClass = aClass;
        this.myName = name2;
        this.myType = type2;
        this.myMemberType = memberType;
        this.myAnnotations = annotations2;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message(this.myMemberType == PropertyMemberType.FIELD ? "create.field.text" : "create.property.text", this.myName);
        if (string == null) {
            CreateFieldOrPropertyFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            CreateFieldOrPropertyFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
        if (project2 == null) {
            CreateFieldOrPropertyFix.$$$reportNull$$$0(3);
        }
        if (descriptor2 == null) {
            CreateFieldOrPropertyFix.$$$reportNull$$$0(4);
        }
        this.applyFixInner(project2);
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            CreateFieldOrPropertyFix.$$$reportNull$$$0(5);
        }
        return true;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            CreateFieldOrPropertyFix.$$$reportNull$$$0(6);
        }
        this.applyFixInner(project2);
    }

    private void applyFixInner(final Project project2) {
        final PsiFile file2 = this.myClass.getContainingFile();
        final Editor editor = CodeInsightUtil.positionCursorAtLBrace(project2, this.myClass.getContainingFile(), this.myClass);
        if (editor != null) {
            new WriteCommandAction(project2, new PsiFile[]{file2}){

                protected void run(@NotNull Result result2) throws Throwable {
                    if (result2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    CreateFieldOrPropertyFix.this.generateMembers(project2, editor, file2);
                }

                protected boolean isGlobalUndoAction() {
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/daemon/quickFix/CreateFieldOrPropertyFix$1", "run"));
                }
            }.execute();
        }
    }

    private void generateMembers(Project project2, Editor editor, PsiFile file2) {
        try {
            List<? extends GenerationInfo> prototypes = new GenerateFieldOrPropertyHandler(this.myName, this.myType, this.myMemberType, this.myAnnotations).generateMemberPrototypes(this.myClass, ClassMember.EMPTY_ARRAY);
            prototypes = GenerateMembersUtil.insertMembersAtOffset(this.myClass, editor.getCaretModel().getOffset(), prototypes);
            if (prototypes.isEmpty()) {
                return;
            }
            PsiElement scope = prototypes.get(0).getPsiMember().getContext();
            assert (scope != null);
            EmptyExpression expression2 = new EmptyExpression(){

                @Override
                public com.intellij.codeInsight.template.Result calculateResult(ExpressionContext context) {
                    return new TextResult(CreateFieldOrPropertyFix.this.myType.getCanonicalText());
                }
            };
            TemplateBuilderImpl builder = new TemplateBuilderImpl(scope);
            boolean first = true;
            String TYPE_NAME_VAR = "TYPE_NAME_VAR";
            for (GenerationInfo generationInfo : prototypes) {
                PsiTypeElement typeElement = PropertyUtilBase.getPropertyTypeElement((PsiMember)generationInfo.getPsiMember());
                if (first) {
                    first = false;
                    builder.replaceElement((PsiElement)typeElement, "TYPE_NAME_VAR", (Expression)expression2, true);
                    continue;
                }
                builder.replaceElement((PsiElement)typeElement, "TYPE_NAME_VAR", "TYPE_NAME_VAR", false);
            }
            PsiDocumentManager.getInstance((Project)project2).doPostponedOperationsAndUnblockDocument(editor.getDocument());
            editor.getCaretModel().moveToOffset(scope.getTextRange().getStartOffset());
            TemplateManager.getInstance(project2).startTemplate(editor, builder.buildInlineTemplate());
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberType";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/quickFix/CreateFieldOrPropertyFix";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/quickFix/CreateFieldOrPropertyFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

