/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.hint.ParameterInfoController;
import com.intellij.codeInsight.hints.ParameterHintsPass;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaVarArgPrevParameterHandler
extends EditorActionHandler {
    private final EditorActionHandler myDelegate;

    public JavaVarArgPrevParameterHandler(EditorActionHandler delegate) {
        this.myDelegate = delegate;
    }

    protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        if (editor == null) {
            JavaVarArgPrevParameterHandler.$$$reportNull$$$0(0);
        }
        if (caret == null) {
            JavaVarArgPrevParameterHandler.$$$reportNull$$$0(1);
        }
        return this.myDelegate.isEnabled(editor, caret, dataContext);
    }

    protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
        Object exprList;
        PsiFile file2;
        if (editor == null) {
            JavaVarArgPrevParameterHandler.$$$reportNull$$$0(2);
        }
        int offset = caret != null ? caret.getOffset() : editor.getCaretModel().getOffset();
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 != null && (file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument())) instanceof PsiJavaFile && (exprList = ParameterInfoController.findArgumentList(file2, offset, -1)) instanceof PsiExpressionList) {
            ParameterInfoController controller;
            CharSequence text2 = editor.getDocument().getImmutableCharSequence();
            int next = CharArrayUtil.shiftForward((CharSequence)text2, (int)offset, (String)" \t");
            int prev = CharArrayUtil.shiftBackward((CharSequence)text2, (int)(offset - 1), (String)" \t");
            int rParOffset = exprList.getTextRange().getEndOffset() - 1;
            if ((offset == rParOffset + 1 || next == rParOffset && prev >= 0 && prev < text2.length() && text2.charAt(prev) == ',') && (controller = ParameterInfoController.findControllerAtOffset(editor, exprList.getTextRange().getStartOffset())) != null) {
                Object[] objects = controller.getObjects();
                Object highlighted = controller.getHighlighted();
                if (objects != null && objects.length > 0 && (highlighted != null || objects.length == 1)) {
                    PsiMethod currentMethod;
                    int currentIndex;
                    int n = currentIndex = highlighted == null ? 0 : ContainerUtil.indexOf(Arrays.asList(objects), (Object)highlighted);
                    if (currentIndex >= 0 && (currentMethod = (PsiMethod)((CandidateInfo)objects[currentIndex]).getElement()).isVarArgs()) {
                        boolean toReturn = false;
                        if (offset == rParOffset + 1) {
                            WriteAction.run(() -> {
                                if (editor == null) {
                                    JavaVarArgPrevParameterHandler.$$$reportNull$$$0(4);
                                }
                                editor.getDocument().insertString(rParOffset, (CharSequence)", ");
                            });
                        } else {
                            WriteAction.run(() -> {
                                if (editor == null) {
                                    JavaVarArgPrevParameterHandler.$$$reportNull$$$0(3);
                                }
                                editor.getDocument().deleteString(prev, next);
                            });
                            toReturn = true;
                        }
                        PsiDocumentManager.getInstance((Project)project2).commitDocument(editor.getDocument());
                        PsiElement call = exprList.getParent();
                        if (call != null) {
                            ParameterHintsPass.syncUpdate(call, editor);
                        }
                        if (toReturn) {
                            return;
                        }
                    }
                }
            }
        }
        this.myDelegate.execute(editor, caret, dataContext);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/JavaVarArgPrevParameterHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledForCaret";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doExecute";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$doExecute$1";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$doExecute$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

