/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.javadoc.PsiDocParamRef;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiInlineDocTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xml.util.HtmlUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavadocTypedHandler
extends TypedHandlerDelegate {
    private static final char START_TAG_SYMBOL = '<';
    private static final char CLOSE_TAG_SYMBOL = '>';
    private static final char SLASH = '/';
    private static final String COMMENT_PREFIX = "!--";

    public TypedHandlerDelegate.Result charTyped(char c, Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            JavadocTypedHandler.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            JavadocTypedHandler.$$$reportNull$$$0(1);
        }
        if (project2 == null) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        JavadocTypedHandler.insertClosingTagIfNecessary(c, project2, editor, file2);
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    private static boolean insertClosingTagIfNecessary(char c, @NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project2 == null) {
            JavadocTypedHandler.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            JavadocTypedHandler.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            JavadocTypedHandler.$$$reportNull$$$0(4);
        }
        if (c != '>' || !CodeInsightSettings.getInstance().JAVADOC_GENERATE_CLOSING_TAG || !(file2 instanceof PsiJavaFile)) {
            return false;
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        if (!JavadocTypedHandler.isAppropriatePlace(editor, file2)) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        String tagName = JavadocTypedHandler.getTagName(document.getText(), offset);
        if (tagName == null || HtmlUtil.isSingleHtmlTag(tagName) || tagName.startsWith(COMMENT_PREFIX)) {
            return false;
        }
        document.insertString(offset, (CharSequence)(String.valueOf('<') + '/' + tagName + '>'));
        return true;
    }

    @Nullable
    public static String getTagName(@NotNull CharSequence text2, int afterTagOffset) {
        if (text2 == null) {
            JavadocTypedHandler.$$$reportNull$$$0(5);
        }
        if (afterTagOffset > text2.length()) {
            return null;
        }
        int endOffset = afterTagOffset - 1;
        if (endOffset > 0 && text2.charAt(endOffset - 1) == '/') {
            return null;
        }
        for (int i = endOffset - 1; i >= 0; --i) {
            char c = text2.charAt(i);
            switch (c) {
                case '\n': {
                    return null;
                }
                case '>': {
                    return null;
                }
                case '<': {
                    if (text2.charAt(i + 1) == '/') {
                        return null;
                    }
                    return text2.subSequence(i + 1, endOffset).toString();
                }
                case '\t': 
                case ' ': {
                    endOffset = i;
                }
            }
        }
        return null;
    }

    private static boolean isAppropriatePlace(Editor editor, PsiFile file2) {
        PsiDocTag tag;
        PsiElement element;
        FileViewProvider provider = file2.getViewProvider();
        int offset = editor.getCaretModel().getOffset();
        PsiElement elementAtCaret = offset < editor.getDocument().getTextLength() ? provider.findElementAt(offset) : provider.findElementAt(editor.getDocument().getTextLength() - 1);
        for (element = elementAtCaret; element instanceof PsiWhiteSpace || element != null && CharArrayUtil.containsOnlyWhiteSpaces((CharSequence)element.getText()); element = element.getPrevSibling()) {
        }
        if (element == null) {
            return false;
        }
        if (element instanceof PsiDocParamRef) {
            element = element.getParent();
        }
        if (element instanceof PsiDocTag && "param".equals((tag = (PsiDocTag)element).getName()) && JavadocTypedHandler.isTypeParamBracketClosedAfterParamTag(tag, offset)) {
            return false;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)element, PsiInlineDocTag.class, (boolean)false) != null) {
            return false;
        }
        ASTNode node = element.getNode();
        return node != null && (JavaDocTokenType.ALL_JAVADOC_TOKENS.contains(node.getElementType()) || JavaDocElementType.ALL_JAVADOC_ELEMENTS.contains(node.getElementType()));
    }

    private static boolean isTypeParamBracketClosedAfterParamTag(PsiDocTag tag, int bracketOffset) {
        PsiElement paramToDocument = JavadocTypedHandler.getDocumentingParameter(tag);
        if (paramToDocument == null) {
            return false;
        }
        TextRange paramRange = paramToDocument.getTextRange();
        return paramRange.getEndOffset() == bracketOffset;
    }

    @Nullable
    private static PsiElement getDocumentingParameter(PsiDocTag tag) {
        for (PsiElement element : tag.getChildren()) {
            if (!(element instanceof PsiDocParamRef)) continue;
            return element;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/JavadocTypedHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "charTyped";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "insertClosingTagIfNecessary";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getTagName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

