/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.folding.impl.EditorFoldingInfo;
import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollapseBlockHandler
implements CodeInsightActionHandler {
    private static final String ourPlaceHolderText = "{...}";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.folding.impl.CollapseBlockHandler");

    public void invoke(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project2 == null) {
            CollapseBlockHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            CollapseBlockHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            CollapseBlockHandler.$$$reportNull$$$0(2);
        }
        int[] targetCaretOffset = new int[]{-1};
        editor.getFoldingModel().runBatchFoldingOperation(() -> {
            if (editor == null) {
                CollapseBlockHandler.$$$reportNull$$$0(4);
            }
            if (file2 == null) {
                CollapseBlockHandler.$$$reportNull$$$0(5);
            }
            EditorFoldingInfo info = EditorFoldingInfo.get(editor);
            FoldingModelEx model = (FoldingModelEx)editor.getFoldingModel();
            PsiElement element = file2.findElementAt(editor.getCaretModel().getOffset() - 1);
            if (!(element instanceof PsiJavaToken) || ((PsiJavaToken)element).getTokenType() != JavaTokenType.RBRACE) {
                element = file2.findElementAt(editor.getCaretModel().getOffset());
            }
            if (element == null) {
                return;
            }
            PsiCodeBlock block = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)element, PsiCodeBlock.class);
            FoldRegion previous = null;
            FoldRegion myPrevious = null;
            while (block != null) {
                int end;
                int start = block.getTextRange().getStartOffset();
                FoldRegion existing = FoldingUtil.findFoldRegion(editor, start, end = block.getTextRange().getEndOffset());
                if (existing != null) {
                    if (existing.isExpanded()) {
                        existing.setExpanded(false);
                        targetCaretOffset[0] = existing.getEndOffset();
                        return;
                    }
                    previous = existing;
                    if (info.getPsiElement(existing) == null) {
                        myPrevious = existing;
                    }
                    block = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)block, PsiCodeBlock.class);
                    continue;
                }
                if (model.intersectsRegion(start, end)) break;
                FoldRegion region = model.addFoldRegion(start, end, ourPlaceHolderText);
                LOG.assertTrue(region != null);
                region.setExpanded(false);
                if (myPrevious != null && info.getPsiElement(region) == null) {
                    info.removeRegion(myPrevious);
                    model.removeFoldRegion(myPrevious);
                }
                targetCaretOffset[0] = block.getTextRange().getEndOffset() < editor.getCaretModel().getOffset() ? start : end;
                return;
            }
            if (previous != null) {
                previous.setExpanded(false);
                if (myPrevious != null) {
                    info.removeRegion(myPrevious);
                    model.removeFoldRegion(myPrevious);
                }
                targetCaretOffset[0] = previous.getEndOffset();
            }
        });
        if (targetCaretOffset[0] >= 0) {
            editor.getCaretModel().moveToOffset(targetCaretOffset[0]);
        }
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        if (currentFile == null) {
            CollapseBlockHandler.$$$reportNull$$$0(3);
        }
        return null;
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/folding/impl/CollapseBlockHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getElementToMakeWritable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$invoke$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

