/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.surroundWith;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.generation.surroundWith.JavaBooleanExpressionSurrounder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class JavaWithIfExpressionSurrounder
extends JavaBooleanExpressionSurrounder {
    @Override
    public boolean isApplicable(PsiExpression expr) {
        if (!super.isApplicable(expr)) {
            return false;
        }
        if (!expr.isPhysical()) {
            return false;
        }
        PsiElement expressionStatement = expr.getParent();
        if (!(expressionStatement instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiElement statementParent = expressionStatement.getParent();
        return JavaWithIfExpressionSurrounder.isElseBranch(expr, statementParent) || statementParent instanceof PsiCodeBlock || FileTypeUtils.isInServerPageFile((PsiElement)statementParent) && statementParent instanceof PsiFile;
    }

    public TextRange surroundExpression(Project project2, Editor editor, PsiExpression expr) throws IncorrectOperationException {
        PsiExpressionStatement statement2;
        PsiStatement thenBranch;
        PsiManager manager = expr.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project2);
        String text2 = "if(a){\nst;\n}";
        PsiIfStatement ifStatement = (PsiIfStatement)factory.createStatementFromText(text2, null);
        PsiExpression condition2 = (ifStatement = (PsiIfStatement)codeStyleManager.reformat((PsiElement)ifStatement)).getCondition();
        if (condition2 != null) {
            condition2.replace((PsiElement)expr);
        }
        if ((thenBranch = (ifStatement = (PsiIfStatement)(statement2 = (PsiExpressionStatement)expr.getParent()).replace((PsiElement)ifStatement)).getThenBranch()) != null && thenBranch instanceof PsiBlockStatement) {
            PsiCodeBlock block = ((PsiBlockStatement)thenBranch).getCodeBlock();
            block = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(block);
            TextRange range = block.getStatements()[0].getTextRange();
            editor.getDocument().deleteString(range.getStartOffset(), range.getEndOffset());
            return TextRange.from((int)range.getStartOffset(), (int)0);
        }
        return TextRange.from((int)editor.getCaretModel().getOffset(), (int)0);
    }

    public String getTemplateDescription() {
        return CodeInsightBundle.message((String)"surround.with.if.expression.template", (Object[])new Object[0]);
    }

    private static boolean isElseBranch(@NotNull PsiExpression expression2, @NotNull PsiElement statementParent) {
        PsiStatement elseBranch;
        if (expression2 == null) {
            JavaWithIfExpressionSurrounder.$$$reportNull$$$0(0);
        }
        if (statementParent == null) {
            JavaWithIfExpressionSurrounder.$$$reportNull$$$0(1);
        }
        return statementParent instanceof PsiIfStatement && (elseBranch = ((PsiIfStatement)statementParent).getElseBranch()) != null && elseBranch.getFirstChild() == expression2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "expression";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "statementParent";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/generation/surroundWith/JavaWithIfExpressionSurrounder";
        objectArray[2] = "isElseBranch";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

