/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.TIntArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddOnDemandStaticImportAction
extends BaseElementAtCaretIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.AddOnDemandStaticImportAction");

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.add.on.demand.static.import.family", (Object[])new Object[0]);
        if (string == null) {
            AddOnDemandStaticImportAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public static PsiClass getClassToPerformStaticImport(@NotNull PsiElement element) {
        PsiFile file2;
        if (element == null) {
            AddOnDemandStaticImportAction.$$$reportNull$$$0(1);
        }
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)element)) {
            return null;
        }
        if (!(element instanceof PsiIdentifier) || !(element.getParent() instanceof PsiJavaCodeReferenceElement)) {
            return null;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)element, PsiErrorElement.class) != null) {
            return null;
        }
        PsiJavaCodeReferenceElement refExpr = (PsiJavaCodeReferenceElement)element.getParent();
        if (refExpr instanceof PsiMethodReferenceExpression) {
            return null;
        }
        PsiElement gParent = refExpr.getParent();
        if (gParent instanceof PsiMethodReferenceExpression) {
            return null;
        }
        if (!(gParent instanceof PsiJavaCodeReferenceElement) || AddOnDemandStaticImportAction.isParameterizedReference((PsiJavaCodeReferenceElement)gParent)) {
            return null;
        }
        PsiElement resolved = refExpr.resolve();
        if (!(resolved instanceof PsiClass)) {
            return null;
        }
        PsiClass psiClass = (PsiClass)resolved;
        if (PsiUtil.isFromDefaultPackage((PsiClass)psiClass) || psiClass.hasModifierProperty("private") || psiClass.getQualifiedName() == null) {
            return null;
        }
        PsiElement ggParent = gParent.getParent();
        if (ggParent instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)ggParent.copy();
            PsiElement qualifier = call.getMethodExpression().getQualifier();
            if (qualifier == null) {
                return null;
            }
            qualifier.delete();
            PsiMethod method = call.resolveMethod();
            if (method != null && method.getContainingClass() != psiClass) {
                return null;
            }
        } else {
            PsiElement refNameElement = ((PsiJavaCodeReferenceElement)gParent).getReferenceNameElement();
            if (refNameElement == null) {
                return null;
            }
            PsiJavaCodeReferenceElement copy = JavaPsiFacade.getElementFactory((Project)refNameElement.getProject()).createReferenceFromText(refNameElement.getText(), (PsiElement)refExpr);
            PsiElement target2 = copy.resolve();
            if (target2 != null && PsiTreeUtil.getParentOfType((PsiElement)target2, PsiClass.class) != psiClass) {
                return null;
            }
        }
        if (!((file2 = refExpr.getContainingFile()) instanceof PsiJavaFile)) {
            return null;
        }
        PsiImportList importList = ((PsiJavaFile)file2).getImportList();
        if (importList == null) {
            return null;
        }
        return psiClass;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        PsiClass classToImport;
        if (project2 == null) {
            AddOnDemandStaticImportAction.$$$reportNull$$$0(2);
        }
        if (element == null) {
            AddOnDemandStaticImportAction.$$$reportNull$$$0(3);
        }
        if ((classToImport = AddOnDemandStaticImportAction.getClassToPerformStaticImport(element)) != null) {
            String text2 = CodeInsightBundle.message((String)"intention.add.on.demand.static.import.text", (Object[])new Object[]{classToImport.getQualifiedName()});
            this.setText(text2);
        }
        return classToImport != null;
    }

    public static boolean invoke(Project project2, PsiFile file2, Editor editor, PsiElement element) {
        PsiJavaCodeReferenceElement refExpr = (PsiJavaCodeReferenceElement)element.getParent();
        final PsiClass aClass = (PsiClass)refExpr.resolve();
        if (aClass == null) {
            return false;
        }
        PsiClass containingClass = PsiUtil.getTopLevelClass((PsiElement)refExpr);
        if (aClass != containingClass) {
            PsiImportList importList = ((PsiJavaFile)file2).getImportList();
            if (importList == null) {
                return false;
            }
            boolean alreadyImported = false;
            for (PsiImportStaticStatement statement2 : importList.getImportStaticStatements()) {
                PsiClass staticResolve;
                if (!statement2.isOnDemand() || aClass != (staticResolve = statement2.resolveTargetClass())) continue;
                alreadyImported = true;
                break;
            }
            if (!alreadyImported) {
                PsiImportStaticStatement importStaticStatement = JavaPsiFacade.getInstance((Project)file2.getProject()).getElementFactory().createImportStaticStatement(aClass, "*");
                importList.add((PsiElement)importStaticStatement);
            }
        }
        final Ref conflict = new Ref((Object)false);
        List roots = file2.getViewProvider().getAllFiles();
        for (PsiFile root : roots) {
            PsiElement copy = root.copy();
            final PsiManager manager = root.getManager();
            final TIntArrayList expressionToDequalifyOffsets = new TIntArrayList();
            copy.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){
                int delta;

                public void visitReferenceElement(PsiJavaCodeReferenceElement expression2) {
                    if (AddOnDemandStaticImportAction.isParameterizedReference(expression2)) {
                        super.visitElement((PsiElement)expression2);
                        return;
                    }
                    PsiElement qualifierExpression2 = expression2.getQualifier();
                    if (qualifierExpression2 instanceof PsiJavaCodeReferenceElement && ((PsiJavaCodeReferenceElement)qualifierExpression2).isReferenceTo((PsiElement)aClass)) {
                        try {
                            PsiElement resolved = expression2.resolve();
                            int end = expression2.getTextRange().getEndOffset();
                            qualifierExpression2.delete();
                            this.delta += end - expression2.getTextRange().getEndOffset();
                            PsiElement after2 = expression2.resolve();
                            if (manager.areElementsEquivalent(after2, resolved)) {
                                expressionToDequalifyOffsets.add(expression2.getTextRange().getStartOffset() + this.delta);
                            } else {
                                conflict.set((Object)true);
                            }
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                    super.visitElement((PsiElement)expression2);
                }
            });
            expressionToDequalifyOffsets.forEachDescending(offset -> {
                PsiJavaCodeReferenceElement expression2 = (PsiJavaCodeReferenceElement)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)root, (int)offset, PsiJavaCodeReferenceElement.class, (boolean)false);
                if (expression2 == null) {
                    return false;
                }
                PsiElement qualifierExpression2 = expression2.getQualifier();
                if (qualifierExpression2 instanceof PsiJavaCodeReferenceElement && ((PsiJavaCodeReferenceElement)qualifierExpression2).isReferenceTo((PsiElement)aClass)) {
                    qualifierExpression2.delete();
                    if (editor != null) {
                        HighlightManager.getInstance((Project)project2).addRangeHighlight(editor, expression2.getTextRange().getStartOffset(), expression2.getTextRange().getEndOffset(), EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES), false, null);
                    }
                }
                return true;
            });
        }
        return (Boolean)conflict.get();
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project2 == null) {
            AddOnDemandStaticImportAction.$$$reportNull$$$0(4);
        }
        if (element == null) {
            AddOnDemandStaticImportAction.$$$reportNull$$$0(5);
        }
        AddOnDemandStaticImportAction.invoke(project2, element.getContainingFile(), editor, element);
    }

    private static boolean isParameterizedReference(PsiJavaCodeReferenceElement expression2) {
        PsiReferenceParameterList parameterList = expression2.getParameterList();
        return parameterList != null && parameterList.getFirstChild() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/AddOnDemandStaticImportAction";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/AddOnDemandStaticImportAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getClassToPerformStaticImport";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

