/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInsight.intention.impl.FieldFromParameterUtils;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssignFieldFromParameterAction
extends BaseIntentionAction {
    private static final Logger LOG = Logger.getInstance(AssignFieldFromParameterAction.class);

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        PsiClass targetClass;
        PsiType type2;
        PsiParameter myParameter;
        if (project2 == null) {
            AssignFieldFromParameterAction.$$$reportNull$$$0(0);
        }
        if (!FieldFromParameterUtils.isAvailable(myParameter = FieldFromParameterUtils.findParameterAtCursor(file2, editor), type2 = FieldFromParameterUtils.getType(myParameter), targetClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)myParameter, PsiClass.class))) {
            return false;
        }
        PsiField field = AssignFieldFromParameterAction.findFieldToAssign(project2, myParameter);
        if (field == null || type2 == null || !field.getType().isAssignableFrom(type2)) {
            return false;
        }
        if (!field.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) {
            return false;
        }
        PsiElement scope = myParameter.getDeclarationScope();
        if (scope instanceof PsiMethod && field.hasModifierProperty("final")) {
            if (((PsiMethod)scope).isConstructor()) {
                PsiExpression expression2;
                PsiCodeBlock body2 = ((PsiMethod)scope).getBody();
                LOG.assertTrue(body2 != null);
                PsiStatement[] statements = body2.getStatements();
                if (statements.length > 0 && statements[0] instanceof PsiExpressionStatement && (expression2 = ((PsiExpressionStatement)statements[0]).getExpression()) instanceof PsiMethodCallExpression && "this".equals(((PsiMethodCallExpression)expression2).getMethodExpression().getReferenceName())) {
                    return false;
                }
            } else {
                return false;
            }
        }
        this.setText(CodeInsightBundle.message((String)"intention.assign.field.from.parameter.text", (Object[])new Object[]{field.getName()}));
        return true;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.assign.field.from.parameter.family", (Object[])new Object[0]);
        if (string == null) {
            AssignFieldFromParameterAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            AssignFieldFromParameterAction.$$$reportNull$$$0(2);
        }
        PsiParameter myParameter = FieldFromParameterUtils.findParameterAtCursor(file2, editor);
        IdeDocumentHistory.getInstance(project2).includeCurrentPlaceAsChangePlace();
        PsiField field = AssignFieldFromParameterAction.findFieldToAssign(project2, myParameter);
        if (field != null) {
            AssignFieldFromParameterAction.addFieldAssignmentStatement(project2, field, myParameter, editor);
        }
    }

    @Nullable
    private static PsiField findFieldToAssign(@NotNull Project project2, @NotNull PsiParameter myParameter) {
        if (project2 == null) {
            AssignFieldFromParameterAction.$$$reportNull$$$0(3);
        }
        if (myParameter == null) {
            AssignFieldFromParameterAction.$$$reportNull$$$0(4);
        }
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)project2);
        String parameterName = myParameter.getName();
        String propertyName = styleManager.variableNameToPropertyName(parameterName, VariableKind.PARAMETER);
        PsiMethod method = (PsiMethod)myParameter.getDeclarationScope();
        boolean isMethodStatic = method.hasModifierProperty("static");
        VariableKind kind2 = isMethodStatic ? VariableKind.STATIC_FIELD : VariableKind.FIELD;
        SuggestedNameInfo suggestedNameInfo = styleManager.suggestVariableName(kind2, propertyName, null, FieldFromParameterUtils.getSubstitutedType(myParameter));
        String fieldName = suggestedNameInfo.names[0];
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return null;
        }
        PsiField field = aClass.findFieldByName(fieldName, false);
        if (field == null) {
            return null;
        }
        if (!field.hasModifierProperty("static") && isMethodStatic) {
            return null;
        }
        return field;
    }

    public static PsiElement addFieldAssignmentStatement(@NotNull Project project2, @NotNull PsiField field, @NotNull PsiParameter parameter2, @NotNull Editor editor) throws IncorrectOperationException {
        PsiMethod method;
        PsiCodeBlock methodBody2;
        if (project2 == null) {
            AssignFieldFromParameterAction.$$$reportNull$$$0(5);
        }
        if (field == null) {
            AssignFieldFromParameterAction.$$$reportNull$$$0(6);
        }
        if (parameter2 == null) {
            AssignFieldFromParameterAction.$$$reportNull$$$0(7);
        }
        if (editor == null) {
            AssignFieldFromParameterAction.$$$reportNull$$$0(8);
        }
        if ((methodBody2 = (method = (PsiMethod)parameter2.getDeclarationScope()).getBody()) == null) {
            return null;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
        String fieldName = field.getName();
        String parameterName = parameter2.getName();
        boolean isMethodStatic = method.hasModifierProperty("static");
        PsiClass targetClass = method.getContainingClass();
        if (targetClass == null) {
            return null;
        }
        String stmtText = fieldName + " = " + parameterName + ";";
        if (Comparing.strEqual((String)fieldName, (String)parameterName) || JavaPsiFacade.getInstance((Project)project2).getResolveHelper().resolveReferencedVariable(fieldName, (PsiElement)methodBody2) != field) {
            String prefix = isMethodStatic ? (targetClass.getName() == null ? "" : targetClass.getName() + ".") : "this.";
            stmtText = prefix + stmtText;
        }
        PsiStatement assignmentStmt = (PsiStatement)CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)factory.createStatementFromText(stmtText, (PsiElement)methodBody2));
        PsiStatement[] statements = methodBody2.getStatements();
        int i = FieldFromParameterUtils.findFieldAssignmentAnchor(statements, null, targetClass, parameter2);
        PsiElement inserted = i == statements.length ? methodBody2.add((PsiElement)assignmentStmt) : methodBody2.addAfter((PsiElement)assignmentStmt, i > 0 ? statements[i - 1] : null);
        editor.getCaretModel().moveToOffset(inserted.getTextRange().getEndOffset());
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        return inserted;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/AssignFieldFromParameterAction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myParameter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/AssignFieldFromParameterAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findFieldToAssign";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addFieldAssignmentStatement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

