/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportStaticReferenceElement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.util.ImportsUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ExpandStaticImportAction
extends PsiElementBaseIntentionAction {
    private static final String REPLACE_THIS_OCCURRENCE = "Replace this occurrence and keep the import";
    private static final String REPLACE_ALL_AND_DELETE_IMPORT = "Replace all and delete the import";

    @NotNull
    public String getFamilyName() {
        if ("Expand Static Import" == null) {
            ExpandStaticImportAction.$$$reportNull$$$0(0);
        }
        return "Expand Static Import";
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        if (project2 == null) {
            ExpandStaticImportAction.$$$reportNull$$$0(1);
        }
        if (element == null) {
            ExpandStaticImportAction.$$$reportNull$$$0(2);
        }
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)element)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(element instanceof PsiIdentifier) || !(parent instanceof PsiJavaCodeReferenceElement)) {
            return false;
        }
        PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)parent;
        PsiElement resolveScope = ExpandStaticImportAction.getImportStaticStatement(referenceElement);
        if (resolveScope instanceof PsiImportStaticStatement) {
            PsiClass targetClass = ((PsiImportStaticStatement)resolveScope).resolveTargetClass();
            if (targetClass == null) {
                return false;
            }
            this.setText("Expand static import to " + targetClass.getName() + "." + referenceElement.getReferenceName());
            return true;
        }
        return false;
    }

    private static PsiElement getImportStaticStatement(PsiJavaCodeReferenceElement referenceElement) {
        return referenceElement instanceof PsiImportStaticReferenceElement ? referenceElement.getParent() : referenceElement.advancedResolve(true).getCurrentFileResolveScope();
    }

    public void invoke(final Project project2, PsiFile file2, Editor editor, PsiElement element) {
        PsiImportStaticStatement staticImport;
        final PsiJavaCodeReferenceElement refExpr = (PsiJavaCodeReferenceElement)element.getParent();
        final List expressionToExpand = ImportsUtil.collectReferencesThrough((PsiFile)file2, (PsiJavaCodeReferenceElement)refExpr, (PsiImportStaticStatement)(staticImport = (PsiImportStaticStatement)ExpandStaticImportAction.getImportStaticStatement(refExpr)));
        if (expressionToExpand.isEmpty()) {
            ImportsUtil.expand((PsiJavaCodeReferenceElement)refExpr, (PsiImportStaticStatement)staticImport);
            staticImport.delete();
        } else if (ApplicationManager.getApplication().isUnitTestMode() || refExpr instanceof PsiImportStaticReferenceElement) {
            ImportsUtil.replaceAllAndDeleteImport((List)expressionToExpand, (PsiJavaCodeReferenceElement)refExpr, (PsiImportStaticStatement)staticImport);
        } else {
            BaseListPopupStep<String> step = new BaseListPopupStep<String>("Multiple Usages of the Static Import Found", new String[]{REPLACE_THIS_OCCURRENCE, REPLACE_ALL_AND_DELETE_IMPORT}){

                public PopupStep onChosen(final String selectedValue, boolean finalChoice) {
                    new WriteCommandAction(project2, ExpandStaticImportAction.this.getText(), new PsiFile[0]){

                        protected void run(@NotNull Result result2) throws Throwable {
                            if (result2 == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (selectedValue == ExpandStaticImportAction.REPLACE_THIS_OCCURRENCE) {
                                ImportsUtil.expand((PsiJavaCodeReferenceElement)refExpr, (PsiImportStaticStatement)staticImport);
                            } else {
                                ImportsUtil.replaceAllAndDeleteImport((List)expressionToExpand, (PsiJavaCodeReferenceElement)refExpr, (PsiImportStaticStatement)staticImport);
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/intention/impl/ExpandStaticImportAction$1$1", "run"));
                        }
                    }.execute();
                    return FINAL_CHOICE;
                }
            };
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)step).showInBestPositionFor(editor);
        }
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project2 == null) {
            ExpandStaticImportAction.$$$reportNull$$$0(3);
        }
        if (element == null) {
            ExpandStaticImportAction.$$$reportNull$$$0(4);
        }
        this.invoke(project2, element.getContainingFile(), editor, element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/ExpandStaticImportAction";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/ExpandStaticImportAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

