/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.editorActions.DeclarationJoinLinesHandler;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInspection.RemoveInitializerFix;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class JoinDeclarationAndAssignmentAction
extends PsiElementBaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.join.declaration.family", (Object[])new Object[0]);
        if (string == null) {
            JoinDeclarationAndAssignmentAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        if (project2 == null) {
            JoinDeclarationAndAssignmentAction.$$$reportNull$$$0(1);
        }
        if (element == null) {
            JoinDeclarationAndAssignmentAction.$$$reportNull$$$0(2);
        }
        if (element instanceof PsiCompiledElement) {
            return false;
        }
        if (!element.getManager().isInProject(element)) {
            return false;
        }
        if (!element.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) {
            return false;
        }
        if (JoinDeclarationAndAssignmentAction.getPair(element) != null) {
            this.setText(CodeInsightBundle.message((String)"intention.join.declaration.text", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private static Pair<PsiLocalVariable, PsiAssignmentExpression> getPair(PsiElement element) {
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiAssignmentExpression.class);
        PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiDeclarationStatement.class);
        if (declarationStatement != null) {
            assignmentExpression = JoinDeclarationAndAssignmentAction.getAssignmentStatement(declarationStatement);
        } else if (assignmentExpression != null) {
            declarationStatement = JoinDeclarationAndAssignmentAction.getDeclarationStatement(assignmentExpression);
        }
        if (declarationStatement != null && assignmentExpression != null) {
            PsiElement resolve2;
            PsiExpression lExpression = assignmentExpression.getLExpression();
            PsiExpression rExpression = assignmentExpression.getRExpression();
            if (lExpression instanceof PsiReferenceExpression && rExpression != null && (resolve2 = ((PsiReferenceExpression)lExpression).resolve()) instanceof PsiLocalVariable && resolve2.getParent() == declarationStatement) {
                PsiLocalVariable variable = (PsiLocalVariable)resolve2;
                if (ReferencesSearch.search((PsiElement)variable, (SearchScope)new LocalSearchScope((PsiElement)rExpression), (boolean)false).findFirst() != null) {
                    return null;
                }
                return Pair.createNonNull((Object)variable, (Object)assignmentExpression);
            }
        }
        return null;
    }

    private static PsiAssignmentExpression getAssignmentStatement(PsiDeclarationStatement statement2) {
        PsiExpression expression2;
        PsiElement element = PsiTreeUtil.skipWhitespacesForward((PsiElement)statement2);
        if (element instanceof PsiExpressionStatement && (expression2 = ((PsiExpressionStatement)element).getExpression()) instanceof PsiAssignmentExpression) {
            return (PsiAssignmentExpression)expression2;
        }
        return null;
    }

    private static PsiDeclarationStatement getDeclarationStatement(PsiAssignmentExpression assignmentExpression) {
        PsiElement element;
        PsiElement parent = assignmentExpression.getParent();
        if (parent instanceof PsiExpressionStatement && (element = PsiTreeUtil.skipWhitespacesBackward((PsiElement)parent)) instanceof PsiDeclarationStatement) {
            return (PsiDeclarationStatement)element;
        }
        return null;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project2 == null) {
            JoinDeclarationAndAssignmentAction.$$$reportNull$$$0(3);
        }
        if (element == null) {
            JoinDeclarationAndAssignmentAction.$$$reportNull$$$0(4);
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
            return;
        }
        Pair<PsiLocalVariable, PsiAssignmentExpression> pair2 = JoinDeclarationAndAssignmentAction.getPair(element);
        if (pair2 == null) {
            return;
        }
        PsiLocalVariable variable = (PsiLocalVariable)pair2.getFirst();
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)pair2.getSecond();
        PsiExpression initializer = variable.getInitializer();
        if (initializer != null && assignmentExpression.getOperationTokenType() == JavaTokenType.EQ) {
            RemoveInitializerFix.sideEffectAwareRemove(project2, initializer, (PsiElement)initializer, (PsiVariable)variable);
        }
        WriteAction.run(() -> {
            PsiExpression initializerExpression = DeclarationJoinLinesHandler.getInitializerExpression(variable, assignmentExpression);
            variable.setInitializer(initializerExpression);
            assignmentExpression.delete();
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/JoinDeclarationAndAssignmentAction";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/JoinDeclarationAndAssignmentAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

