/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInsight.intention.impl.StreamRefactoringUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergeFilterChainAction
extends PsiElementBaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)MergeFilterChainAction.class.getName());

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        if (project2 == null) {
            MergeFilterChainAction.$$$reportNull$$$0(0);
        }
        if (element == null) {
            MergeFilterChainAction.$$$reportNull$$$0(1);
        }
        if (!(element instanceof PsiIdentifier)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiElement gParent = parent.getParent();
        if (!(gParent instanceof PsiMethodCallExpression)) {
            return false;
        }
        if (!MergeFilterChainAction.isFilterCall((PsiMethodCallExpression)gParent)) {
            return false;
        }
        return MergeFilterChainAction.getFilterToMerge((PsiMethodCallExpression)gParent) != null;
    }

    @Nullable
    private static PsiMethodCallExpression getFilterToMerge(PsiMethodCallExpression methodCallExpression) {
        PsiElement gParent;
        PsiExpression qualifierExpression2 = methodCallExpression.getMethodExpression().getQualifierExpression();
        if (qualifierExpression2 instanceof PsiMethodCallExpression && MergeFilterChainAction.isFilterCall((PsiMethodCallExpression)qualifierExpression2)) {
            return (PsiMethodCallExpression)qualifierExpression2;
        }
        PsiElement parent = methodCallExpression.getParent();
        if (parent instanceof PsiReferenceExpression && (gParent = parent.getParent()) instanceof PsiMethodCallExpression && MergeFilterChainAction.isFilterCall((PsiMethodCallExpression)gParent)) {
            return (PsiMethodCallExpression)gParent;
        }
        return null;
    }

    public static boolean isFilterCall(PsiMethodCallExpression methodCallExpression) {
        String name2 = methodCallExpression.getMethodExpression().getReferenceName();
        if (!"filter".equals(name2) && !"anyMatch".equals(name2)) {
            return false;
        }
        PsiExpressionList argumentList = methodCallExpression.getArgumentList();
        PsiExpression[] expressions2 = argumentList.getExpressions();
        if (expressions2.length != 1) {
            return false;
        }
        if (!StreamRefactoringUtil.isRefactoringCandidate(expressions2[0], true)) {
            return false;
        }
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        return parameters2.length == 1 && InheritanceUtil.isInheritor((PsiClass)containingClass, (boolean)false, (String)"java.util.stream.BaseStream");
    }

    @NotNull
    public String getText() {
        String string = CodeInsightBundle.message((String)"intention.merge.filter.text", (Object[])new Object[0]);
        if (string == null) {
            MergeFilterChainAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.merge.filter.family", (Object[])new Object[0]);
        if (string == null) {
            MergeFilterChainAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    private static PsiLambdaExpression getLambda(PsiMethodCallExpression call) {
        PsiExpression[] expressions2 = call.getArgumentList().getExpressions();
        if (expressions2.length != 1) {
            return null;
        }
        PsiExpression expression2 = expressions2[0];
        if (expression2 instanceof PsiLambdaExpression) {
            return (PsiLambdaExpression)expression2;
        }
        if (expression2 instanceof PsiMethodReferenceExpression) {
            return LambdaRefactoringUtil.convertMethodReferenceToLambda((PsiMethodReferenceExpression)expression2, false, true);
        }
        return null;
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiParameter[] sourceLambdaParams;
        PsiMethodCallExpression filterCall;
        if (project2 == null) {
            MergeFilterChainAction.$$$reportNull$$$0(4);
        }
        if (element == null) {
            MergeFilterChainAction.$$$reportNull$$$0(5);
        }
        LOG.assertTrue((filterCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class)) != null);
        PsiMethodCallExpression filterToMerge = MergeFilterChainAction.getFilterToMerge(filterCall);
        LOG.assertTrue(filterToMerge != null);
        PsiMethodCallExpression callToStay = filterCall.getTextLength() < filterToMerge.getTextLength() ? filterCall : filterToMerge;
        PsiMethodCallExpression callToEliminate = callToStay == filterCall ? filterToMerge : filterCall;
        String resultingOperation = callToEliminate.getMethodExpression().getReferenceName();
        LOG.assertTrue(resultingOperation != null);
        PsiLambdaExpression targetLambda = MergeFilterChainAction.getLambda(callToStay);
        LOG.assertTrue(targetLambda != null, (Object)callToStay);
        PsiParameter[] parameters2 = targetLambda.getParameterList().getParameters();
        String name2 = parameters2.length > 0 ? parameters2[0].getName() : null;
        PsiLambdaExpression sourceLambda = MergeFilterChainAction.getLambda(callToEliminate);
        LOG.assertTrue(sourceLambda != null, (Object)callToEliminate);
        if (name2 != null && (sourceLambdaParams = sourceLambda.getParameterList().getParameters()).length > 0 && !name2.equals(sourceLambdaParams[0].getName())) {
            for (PsiReference reference : ReferencesSearch.search((PsiElement)sourceLambdaParams[0]).findAll()) {
                PsiElement referenceElement = reference.getElement();
                if (!(referenceElement instanceof PsiReferenceExpression)) continue;
                ExpressionUtils.bindReferenceTo((PsiReferenceExpression)referenceElement, name2);
            }
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
        PsiElement nameElement = callToStay.getMethodExpression().getReferenceNameElement();
        LOG.assertTrue(nameElement != null);
        if (!resultingOperation.equals(nameElement.getText())) {
            nameElement.replace((PsiElement)factory.createIdentifier(resultingOperation));
        }
        PsiElement targetBody = targetLambda.getBody();
        LOG.assertTrue(targetBody instanceof PsiExpression);
        PsiElement sourceLambdaBody = sourceLambda.getBody();
        LOG.assertTrue(sourceLambdaBody instanceof PsiExpression);
        PsiExpression compoundExpression = factory.createExpressionFromText(ParenthesesUtils.getText((PsiExpression)targetBody, 14) + " && " + ParenthesesUtils.getText((PsiExpression)sourceLambdaBody, 14), (PsiElement)sourceLambda);
        targetBody = targetBody.replace((PsiElement)compoundExpression);
        CodeStyleManager.getInstance((Project)project2).reformat(targetBody);
        PsiExpression qualifierExpression2 = callToEliminate.getMethodExpression().getQualifierExpression();
        LOG.assertTrue(qualifierExpression2 != null, (Object)callToEliminate);
        Collection comments = PsiTreeUtil.findChildrenOfType((PsiElement)callToEliminate, PsiComment.class);
        for (PsiComment comment : comments) {
            TextRange commentRange = comment.getTextRange();
            if (sourceLambdaBody.getTextRange().contains(commentRange) || qualifierExpression2.getTextRange().contains(commentRange)) continue;
            targetBody.add((PsiElement)comment);
        }
        callToEliminate.replace((PsiElement)qualifierExpression2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/MergeFilterChainAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/MergeFilterChainAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

