/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInsight.intention.impl.MergeFilterChainAction;
import com.intellij.codeInsight.intention.impl.SplitConditionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class SplitFilterAction
extends PsiElementBaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)SplitFilterAction.class.getName());

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        PsiPolyadicExpression expression2;
        if (project2 == null) {
            SplitFilterAction.$$$reportNull$$$0(0);
        }
        if (element == null) {
            SplitFilterAction.$$$reportNull$$$0(1);
        }
        if ((expression2 = SplitConditionUtil.findCondition(element, true, false)) == null || expression2.getOperands().length < 2) {
            return false;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent());
        if (!(parent instanceof PsiLambdaExpression)) {
            return false;
        }
        if (((PsiLambdaExpression)parent).getParameterList().getParametersCount() != 1) {
            return false;
        }
        if (!((parent = parent.getParent()) instanceof PsiExpressionList)) {
            return false;
        }
        PsiElement gParent = parent.getParent();
        if (!(gParent instanceof PsiMethodCallExpression)) {
            return false;
        }
        return MergeFilterChainAction.isFilterCall((PsiMethodCallExpression)gParent);
    }

    @NotNull
    public String getText() {
        String string = CodeInsightBundle.message((String)"intention.split.filter.text", (Object[])new Object[0]);
        if (string == null) {
            SplitFilterAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.split.filter.family", (Object[])new Object[0]);
        if (string == null) {
            SplitFilterAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project2 == null) {
            SplitFilterAction.$$$reportNull$$$0(4);
        }
        if (element == null) {
            SplitFilterAction.$$$reportNull$$$0(5);
        }
        PsiJavaToken token = (PsiJavaToken)element;
        PsiPolyadicExpression expression2 = SplitConditionUtil.findCondition(element, true, false);
        PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiLambdaExpression.class);
        LOG.assertTrue(lambdaExpression != null);
        String lambdaParameterName = lambdaExpression.getParameterList().getParameters()[0].getName();
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMethodCallExpression.class);
        LOG.assertTrue(methodCallExpression != null, (Object)expression2);
        PsiExpression lOperand = SplitConditionUtil.getLOperands(expression2, token);
        PsiExpression rOperand = SplitConditionUtil.getROperands(expression2, token);
        Collection comments = PsiTreeUtil.findChildrenOfType((PsiElement)expression2, PsiComment.class);
        PsiMethodCallExpression chainedCall = (PsiMethodCallExpression)JavaPsiFacade.getElementFactory((Project)project2).createExpressionFromText("a.filter(" + lambdaParameterName + " -> x)", (PsiElement)expression2);
        PsiExpression argExpression = chainedCall.getArgumentList().getExpressions()[0];
        PsiElement rReplaced = ((PsiLambdaExpression)argExpression).getBody().replace((PsiElement)rOperand);
        PsiExpression compoundArg = methodCallExpression.getArgumentList().getExpressions()[0];
        int separatorOffset = token.getTextOffset();
        for (PsiComment comment : comments) {
            if (comment.getTextOffset() < separatorOffset) {
                compoundArg.getParent().add((PsiElement)comment);
                continue;
            }
            rReplaced.getParent().add((PsiElement)comment);
        }
        ((PsiLambdaExpression)compoundArg).getBody().replace((PsiElement)lOperand);
        chainedCall.getMethodExpression().getQualifierExpression().replace((PsiElement)methodCallExpression);
        methodCallExpression.replace((PsiElement)chainedCall);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/SplitFilterAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/SplitFilterAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

