/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.CustomLiveTemplate;
import com.intellij.codeInsight.template.CustomLiveTemplateBase;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.impl.ListTemplatesHandler;
import com.intellij.codeInsight.template.impl.LiveTemplateLookupElementImpl;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LiveTemplateCompletionContributor
extends CompletionContributor {
    private static boolean ourShowTemplatesInTests = false;

    public static void setShowTemplatesInTests(boolean show, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            LiveTemplateCompletionContributor.$$$reportNull$$$0(0);
        }
        ourShowTemplatesInTests = show;
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                ourShowTemplatesInTests = false;
            }
        });
    }

    public static boolean shouldShowAllTemplates() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return ourShowTemplatesInTests;
        }
        return Registry.is((String)"show.live.templates.in.completion");
    }

    public LiveTemplateCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement(), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters2, ProcessingContext context, @NotNull CompletionResultSet result2) {
                TemplateImpl template;
                if (parameters2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (result2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                ProgressManager.checkCanceled();
                PsiFile file2 = parameters2.getPosition().getContainingFile();
                if (file2 instanceof PsiPlainTextFile && parameters2.getEditor().getComponent().getParent() instanceof EditorTextField) {
                    return;
                }
                Editor editor = parameters2.getEditor();
                int offset = editor.getCaretModel().getOffset();
                List<TemplateImpl> availableTemplates = TemplateManagerImpl.listApplicableTemplates(file2, offset, false);
                Map<TemplateImpl, String> templates = ListTemplatesHandler.filterTemplatesByPrefix(availableTemplates, editor, offset, false, false);
                if (LiveTemplateCompletionContributor.this.showAllTemplates()) {
                    AtomicBoolean templatesShown = new AtomicBoolean(false);
                    CompletionResultSet finalResult = result2;
                    result2.runRemainingContributors(parameters2, completionResult -> {
                        finalResult.passResult(completionResult);
                        if (completionResult.isStartMatch()) {
                            LiveTemplateCompletionContributor.ensureTemplatesShown(templatesShown, templates, finalResult);
                        }
                    });
                    LiveTemplateCompletionContributor.ensureTemplatesShown(templatesShown, templates, result2);
                    LiveTemplateCompletionContributor.showCustomLiveTemplates(parameters2, result2);
                    return;
                }
                if (parameters2.getInvocationCount() > 0) {
                    return;
                }
                if (!LiveTemplateCompletionContributor.customTemplateAvailableAndHasCompletionItem(null, editor, file2, offset) && (template = LiveTemplateCompletionContributor.findFullMatchedApplicableTemplate(editor, offset, availableTemplates)) != null) {
                    result2.withPrefixMatcher(result2.getPrefixMatcher().cloneWithPrefix(template.getKey())).addElement((LookupElement)new LiveTemplateLookupElementImpl(template, true));
                }
                for (Map.Entry<TemplateImpl, String> possible : templates.entrySet()) {
                    ProgressManager.checkCanceled();
                    String templateKey = possible.getKey().getKey();
                    String currentPrefix = possible.getValue();
                    result2.withPrefixMatcher(result2.getPrefixMatcher().cloneWithPrefix(currentPrefix)).restartCompletionOnPrefixChange(templateKey);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInsight/template/impl/LiveTemplateCompletionContributor$2";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public static boolean customTemplateAvailableAndHasCompletionItem(@Nullable Character shortcutChar, @NotNull Editor editor, @NotNull PsiFile file2, int offset) {
        if (editor == null) {
            LiveTemplateCompletionContributor.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            LiveTemplateCompletionContributor.$$$reportNull$$$0(2);
        }
        CustomTemplateCallback callback = new CustomTemplateCallback(editor, file2);
        for (CustomLiveTemplate customLiveTemplate : TemplateManagerImpl.listApplicableCustomTemplates(editor, file2, false)) {
            ProgressManager.checkCanceled();
            if (!(customLiveTemplate instanceof CustomLiveTemplateBase) || shortcutChar != null && customLiveTemplate.getShortcut() != shortcutChar.charValue() || !((CustomLiveTemplateBase)customLiveTemplate).hasCompletionItem(callback, offset)) continue;
            return customLiveTemplate.computeTemplateKey(callback) != null;
        }
        return false;
    }

    protected boolean showAllTemplates() {
        return LiveTemplateCompletionContributor.shouldShowAllTemplates();
    }

    private static void ensureTemplatesShown(AtomicBoolean templatesShown, Map<TemplateImpl, String> templates, CompletionResultSet result2) {
        if (!templatesShown.getAndSet(true)) {
            for (Map.Entry<TemplateImpl, String> entry : templates.entrySet()) {
                ProgressManager.checkCanceled();
                result2.withPrefixMatcher(result2.getPrefixMatcher().cloneWithPrefix(StringUtil.notNullize((String)entry.getValue()))).addElement((LookupElement)new LiveTemplateLookupElementImpl(entry.getKey(), false));
            }
        }
    }

    private static void showCustomLiveTemplates(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet result2) {
        if (parameters2 == null) {
            LiveTemplateCompletionContributor.$$$reportNull$$$0(3);
        }
        if (result2 == null) {
            LiveTemplateCompletionContributor.$$$reportNull$$$0(4);
        }
        PsiFile file2 = parameters2.getPosition().getContainingFile();
        Editor editor = parameters2.getEditor();
        for (CustomLiveTemplate customLiveTemplate : TemplateManagerImpl.listApplicableCustomTemplates(editor, file2, false)) {
            ProgressManager.checkCanceled();
            if (!(customLiveTemplate instanceof CustomLiveTemplateBase)) continue;
            ((CustomLiveTemplateBase)customLiveTemplate).addCompletions(parameters2, result2);
        }
    }

    @Nullable
    public static TemplateImpl findFullMatchedApplicableTemplate(@NotNull Editor editor, int offset, @NotNull Collection<TemplateImpl> availableTemplates) {
        TemplateImpl template;
        Map<TemplateImpl, String> templates;
        if (editor == null) {
            LiveTemplateCompletionContributor.$$$reportNull$$$0(5);
        }
        if (availableTemplates == null) {
            LiveTemplateCompletionContributor.$$$reportNull$$$0(6);
        }
        if ((templates = ListTemplatesHandler.filterTemplatesByPrefix(availableTemplates, editor, offset, true, false)).size() == 1 && (template = (TemplateImpl)ContainerUtil.getFirstItem(templates.keySet())) != null) {
            return template;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "availableTemplates";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/template/impl/LiveTemplateCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setShowTemplatesInTests";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "customTemplateAvailableAndHasCompletionItem";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "showCustomLiveTemplates";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findFullMatchedApplicableTemplate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

