/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.JavaCodeContextType;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedMembersSearch;
import com.intellij.util.Query;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotatedMacro
extends Macro {
    @NonNls
    public String getName() {
        return "annotated";
    }

    public String getPresentableName() {
        return "annotated(\"annotation qname\")";
    }

    @Nullable
    private static Query<PsiMember> findAnnotated(ExpressionContext context, Expression[] params) {
        if (params == null || params.length == 0) {
            return null;
        }
        PsiManager instance2 = PsiManager.getInstance((Project)context.getProject());
        String paramResult = params[0].calculateResult(context).toString();
        if (paramResult == null) {
            return null;
        }
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)context.getProject());
        PsiClass myBaseClass = JavaPsiFacade.getInstance((Project)instance2.getProject()).findClass(paramResult, scope);
        if (myBaseClass != null) {
            return AnnotatedMembersSearch.search((PsiClass)myBaseClass, (SearchScope)scope);
        }
        return null;
    }

    public Result calculateResult(@NotNull Expression[] expressions2, ExpressionContext expressionContext) {
        PsiMember member;
        Query<PsiMember> psiMembers;
        if (expressions2 == null) {
            AnnotatedMacro.$$$reportNull$$$0(0);
        }
        if ((psiMembers = AnnotatedMacro.findAnnotated(expressionContext, expressions2)) != null && (member = (PsiMember)psiMembers.findFirst()) != null) {
            return new TextResult(member instanceof PsiClass ? ((PsiClass)member).getQualifiedName() : member.getName());
        }
        return null;
    }

    public Result calculateQuickResult(@NotNull Expression[] expressions2, ExpressionContext expressionContext) {
        if (expressions2 == null) {
            AnnotatedMacro.$$$reportNull$$$0(1);
        }
        return this.calculateResult(expressions2, expressionContext);
    }

    public LookupElement[] calculateLookupItems(@NotNull Expression[] params, ExpressionContext context) {
        Query<PsiMember> query;
        if (params == null) {
            AnnotatedMacro.$$$reportNull$$$0(2);
        }
        if ((query = AnnotatedMacro.findAnnotated(context, params)) != null) {
            LinkedHashSet<LookupElementBuilder> set2 = new LinkedHashSet<LookupElementBuilder>();
            String secondParamValue = params.length > 1 ? params[1].calculateResult(context).toString() : null;
            boolean isShortName = secondParamValue != null && Boolean.valueOf(secondParamValue) == false;
            Project project2 = context.getProject();
            PsiClass findInClass = secondParamValue != null ? JavaPsiFacade.getInstance((Project)project2).findClass(secondParamValue, GlobalSearchScope.allScope((Project)project2)) : null;
            for (PsiMember object : query.findAll()) {
                if (findInClass != null && !object.getContainingClass().equals(findInClass)) continue;
                boolean isClazz = object instanceof PsiClass;
                String name2 = isShortName || !isClazz ? object.getName() : ((PsiClass)object).getQualifiedName();
                set2.add(LookupElementBuilder.create((String)name2));
            }
            return set2.toArray(new LookupElement[set2.size()]);
        }
        return LookupElement.EMPTY_ARRAY;
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof JavaCodeContextType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/template/macro/AnnotatedMacro";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateResult";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateQuickResult";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateLookupItems";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

