/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.settings;

import com.intellij.codeInsight.template.postfix.settings.PostfixTemplatesSettings;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.lang.Language;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class PostfixTemplatesCheckboxTree
extends CheckboxTree {
    @NotNull
    private final CheckedTreeNode myRoot;
    @NotNull
    private final DefaultTreeModel myModel = (DefaultTreeModel)this.getModel();

    public PostfixTemplatesCheckboxTree() {
        super(new CheckboxTree.CheckboxTreeCellRenderer(){

            public void customizeRenderer(JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (!(value2 instanceof CheckedTreeNode)) {
                    return;
                }
                CheckedTreeNode node = (CheckedTreeNode)value2;
                Color background = selected ? UIUtil.getTreeSelectionBackground() : UIUtil.getTreeTextBackground();
                boolean isPostfixTemplate = node instanceof PostfixTemplateCheckedTreeNode;
                SimpleTextAttributes attributes = isPostfixTemplate ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
                this.getTextRenderer().append(StringUtil.notNullize((String)value2.toString()), new SimpleTextAttributes(background, attributes.getFgColor(), (Color)JBColor.RED, attributes.getStyle()));
                if (isPostfixTemplate) {
                    this.getTextRenderer().append(" (" + ((PostfixTemplateCheckedTreeNode)node).getTemplate().getExample() + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
            }
        }, new CheckedTreeNode(null));
        this.myRoot = (CheckedTreeNode)this.myModel.getRoot();
        this.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(@NotNull TreeSelectionEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                PostfixTemplatesCheckboxTree.this.selectionChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesCheckboxTree$2", "valueChanged"));
            }
        });
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
    }

    protected void selectionChanged() {
    }

    public void initTree(@NotNull MultiMap<String, PostfixTemplate> langToTemplates) {
        if (langToTemplates == null) {
            PostfixTemplatesCheckboxTree.$$$reportNull$$$0(0);
        }
        this.myRoot.removeAllChildren();
        for (Map.Entry entry : langToTemplates.entrySet()) {
            String id = (String)entry.getKey();
            Language language = Language.findLanguageByID((String)id);
            String langName = language != null ? language.getDisplayName() : id;
            CheckedTreeNode langNode = new CheckedTreeNode((Object)langName);
            this.myRoot.add((MutableTreeNode)langNode);
            for (PostfixTemplate template : (Collection)entry.getValue()) {
                PostfixTemplateCheckedTreeNode templateNode = new PostfixTemplateCheckedTreeNode(template, langName);
                langNode.add((MutableTreeNode)((Object)templateNode));
            }
        }
        this.myModel.nodeStructureChanged((TreeNode)this.myRoot);
        TreeUtil.expandAll((JTree)((Object)this));
        this.setSelectionRow(0);
    }

    public PostfixTemplate getTemplate() {
        TreePath path = this.getSelectionModel().getSelectionPath();
        if (path == null || !(path.getLastPathComponent() instanceof PostfixTemplateCheckedTreeNode)) {
            return null;
        }
        return ((PostfixTemplateCheckedTreeNode)((Object)path.getLastPathComponent())).getTemplate();
    }

    public Map<String, Set<String>> getState() {
        HashMap result2 = ContainerUtil.newHashMap();
        Consumer consumer = template -> {
            if (!template.isChecked()) {
                Set templatesForLanguage = (Set)ContainerUtil.getOrCreate((Map)result2, (Object)template.getLang(), PostfixTemplatesSettings.SET_FACTORY);
                templatesForLanguage.add(template.getTemplate().getKey());
            }
        };
        this.visit((Consumer<PostfixTemplateCheckedTreeNode>)consumer);
        return result2;
    }

    private void visit(@NotNull Consumer<PostfixTemplateCheckedTreeNode> consumer) {
        if (consumer == null) {
            PostfixTemplatesCheckboxTree.$$$reportNull$$$0(1);
        }
        Enumeration languages = this.myRoot.children();
        while (languages.hasMoreElements()) {
            CheckedTreeNode langNode = (CheckedTreeNode)languages.nextElement();
            Enumeration templates = langNode.children();
            while (templates.hasMoreElements()) {
                PostfixTemplateCheckedTreeNode template = (PostfixTemplateCheckedTreeNode)((Object)templates.nextElement());
                consumer.consume((Object)template);
            }
        }
    }

    public void setState(@NotNull Map<String, Set<String>> langToDisabledTemplates) {
        if (langToDisabledTemplates == null) {
            PostfixTemplatesCheckboxTree.$$$reportNull$$$0(2);
        }
        TreeState treeState = TreeState.createOn((JTree)((Object)this), (DefaultMutableTreeNode)this.myRoot);
        Consumer consumer = template -> {
            if (langToDisabledTemplates == null) {
                PostfixTemplatesCheckboxTree.$$$reportNull$$$0(7);
            }
            Set disabledTemplates = (Set)langToDisabledTemplates.get(template.getLang());
            String key2 = template.getTemplate().getKey();
            if (disabledTemplates != null && disabledTemplates.contains(key2)) {
                template.setChecked(false);
                return;
            }
            template.setChecked(true);
        };
        this.visit((Consumer<PostfixTemplateCheckedTreeNode>)consumer);
        this.myModel.nodeStructureChanged((TreeNode)this.myRoot);
        treeState.applyTo((JTree)((Object)this));
        TreeUtil.expandAll((JTree)((Object)this));
    }

    public void selectTemplate(@NotNull PostfixTemplate postfixTemplate, @NotNull String lang) {
        if (postfixTemplate == null) {
            PostfixTemplatesCheckboxTree.$$$reportNull$$$0(3);
        }
        if (lang == null) {
            PostfixTemplatesCheckboxTree.$$$reportNull$$$0(4);
        }
        Consumer consumer = template -> {
            if (lang == null) {
                PostfixTemplatesCheckboxTree.$$$reportNull$$$0(5);
            }
            if (postfixTemplate == null) {
                PostfixTemplatesCheckboxTree.$$$reportNull$$$0(6);
            }
            if (lang.equals(template.getLang()) && postfixTemplate.getKey().equals(template.getTemplate().getKey())) {
                TreeUtil.selectInTree((DefaultMutableTreeNode)((Object)template), (boolean)true, (JTree)((Object)this), (boolean)true);
            }
        };
        this.visit((Consumer<PostfixTemplateCheckedTreeNode>)consumer);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "langToTemplates";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "langToDisabledTemplates";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postfixTemplate";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lang";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesCheckboxTree";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "initTree";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visit";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setState";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "selectTemplate";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$selectTemplate$2";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$setState$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class PostfixTemplateCheckedTreeNode
    extends CheckedTreeNode {
        @NotNull
        private final String myLang;
        @NotNull
        private final PostfixTemplate myTemplate;
        @NotNull
        private final PostfixTemplatesSettings mySettings;

        @NotNull
        public PostfixTemplate getTemplate() {
            PostfixTemplate postfixTemplate = this.myTemplate;
            if (postfixTemplate == null) {
                PostfixTemplateCheckedTreeNode.$$$reportNull$$$0(0);
            }
            return postfixTemplate;
        }

        @NotNull
        public String getLang() {
            String string = this.myLang;
            if (string == null) {
                PostfixTemplateCheckedTreeNode.$$$reportNull$$$0(1);
            }
            return string;
        }

        PostfixTemplateCheckedTreeNode(@NotNull PostfixTemplate template, @NotNull String lang) {
            if (template == null) {
                PostfixTemplateCheckedTreeNode.$$$reportNull$$$0(2);
            }
            if (lang == null) {
                PostfixTemplateCheckedTreeNode.$$$reportNull$$$0(3);
            }
            super((Object)template.getKey().replaceFirst("\\.", ""));
            PostfixTemplatesSettings templatesSettings = PostfixTemplatesSettings.getInstance();
            assert (templatesSettings != null);
            this.mySettings = templatesSettings;
            this.setChecked(this.mySettings.isTemplateEnabled(template, lang));
            this.myLang = lang;
            this.myTemplate = template;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesCheckboxTree$PostfixTemplateCheckedTreeNode";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "template";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lang";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTemplate";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLang";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesCheckboxTree$PostfixTemplateCheckedTreeNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

