/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.google.common.collect.Sets;
import com.intellij.codeInsight.template.CustomLiveTemplateBase;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.impl.CustomLiveTemplateLookupElement;
import com.intellij.codeInsight.template.postfix.completion.PostfixTemplateLookupElement;
import com.intellij.codeInsight.template.postfix.settings.PostfixTemplatesSettings;
import com.intellij.codeInsight.template.postfix.templates.LanguagePostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.diagnostic.AttachmentFactory;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.templateLanguages.TemplateLanguageUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostfixLiveTemplate
extends CustomLiveTemplateBase {
    public static final String POSTFIX_TEMPLATE_ID = "POSTFIX_TEMPLATE_ID";
    private static final Logger LOG = Logger.getInstance(PostfixLiveTemplate.class);

    @NotNull
    public Set<String> getAllTemplateKeys(PsiFile file2, int offset) {
        HashSet keys = Sets.newHashSet();
        Language language = PsiUtilCore.getLanguageAtOffset((PsiFile)file2, (int)offset);
        for (PostfixTemplateProvider provider : LanguagePostfixTemplate.LANG_EP.allForLanguage(language)) {
            ProgressManager.checkCanceled();
            keys.addAll(PostfixLiveTemplate.getKeys(provider));
        }
        HashSet hashSet = keys;
        if (hashSet == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    @Nullable
    private static String computeTemplateKeyWithoutContextChecking(@NotNull PostfixTemplateProvider provider, @NotNull CharSequence documentContent, int currentOffset) {
        int startOffset;
        if (provider == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(1);
        }
        if (documentContent == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(2);
        }
        if (documentContent.length() < startOffset) {
            return null;
        }
        for (startOffset = currentOffset; startOffset > 0; --startOffset) {
            ProgressManager.checkCanceled();
            char currentChar = documentContent.charAt(startOffset - 1);
            if (Character.isJavaIdentifierPart(currentChar)) continue;
            if (!provider.isTerminalSymbol(currentChar)) {
                return null;
            }
            --startOffset;
            break;
        }
        return String.valueOf(documentContent.subSequence(startOffset, currentOffset));
    }

    @Override
    @Nullable
    public String computeTemplateKey(@NotNull CustomTemplateCallback callback) {
        if (callback == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(3);
        }
        Editor editor = callback.getEditor();
        CharSequence charsSequence = editor.getDocument().getCharsSequence();
        int offset = editor.getCaretModel().getOffset();
        for (PostfixTemplateProvider provider : LanguagePostfixTemplate.LANG_EP.allForLanguage(PostfixLiveTemplate.getLanguage(callback))) {
            String key2 = PostfixLiveTemplate.computeTemplateKeyWithoutContextChecking(provider, charsSequence, offset);
            if (key2 == null || !PostfixLiveTemplate.isApplicableTemplate(provider, key2, callback.getFile(), editor)) continue;
            return key2;
        }
        return null;
    }

    @Override
    @Nullable
    public String computeTemplateKeyWithoutContextChecking(@NotNull CustomTemplateCallback callback) {
        if (callback == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(4);
        }
        Editor editor = callback.getEditor();
        int currentOffset = editor.getCaretModel().getOffset();
        for (PostfixTemplateProvider provider : LanguagePostfixTemplate.LANG_EP.allForLanguage(PostfixLiveTemplate.getLanguage(callback))) {
            ProgressManager.checkCanceled();
            String key2 = PostfixLiveTemplate.computeTemplateKeyWithoutContextChecking(provider, editor.getDocument().getCharsSequence(), currentOffset);
            if (key2 == null) continue;
            return key2;
        }
        return null;
    }

    @Override
    public boolean supportsMultiCaret() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expand(@NotNull String key2, @NotNull CustomTemplateCallback callback) {
        if (key2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(5);
        }
        if (callback == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.postfix");
        Editor editor = callback.getEditor();
        for (PostfixTemplateProvider provider : LanguagePostfixTemplate.LANG_EP.allForLanguage(PostfixLiveTemplate.getLanguage(callback))) {
            PostfixTemplate postfixTemplate = PostfixLiveTemplate.getTemplate(provider, key2);
            if (postfixTemplate == null) continue;
            PsiFile file2 = callback.getContext().getContainingFile();
            if (PostfixLiveTemplate.isApplicableTemplate(provider, key2, file2, editor)) {
                int offset = PostfixLiveTemplate.deleteTemplateKey(file2, editor, key2);
                try {
                    provider.preExpand(file2, editor);
                    PsiElement context = CustomTemplateCallback.getContext(file2, PostfixLiveTemplate.positiveOffset(offset));
                    PostfixLiveTemplate.expandTemplate(postfixTemplate, editor, context);
                }
                finally {
                    provider.afterExpand(file2, editor);
                }
            } else if (editor.getCaretModel().getAllCarets().size() == 1) {
                LOG.error("Template not found by key: " + key2 + "; offset = " + callback.getOffset(), new Attachment[]{AttachmentFactory.createAttachment(callback.getFile().getVirtualFile())});
            }
            return;
        }
        if (editor.getCaretModel().getAllCarets().size() == 1) {
            LOG.error("Template not found by key: " + key2 + "; offset = " + callback.getOffset(), new Attachment[]{AttachmentFactory.createAttachment(callback.getFile().getVirtualFile())});
        }
    }

    @Override
    public boolean isApplicable(@NotNull CustomTemplateCallback callback, int offset, boolean wrapping) {
        if (callback == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(7);
        }
        PostfixTemplatesSettings settings = PostfixTemplatesSettings.getInstance();
        if (wrapping || settings == null || !settings.isPostfixTemplatesEnabled()) {
            return false;
        }
        PsiFile contextFile = callback.getFile();
        Language language = PsiUtilCore.getLanguageAtOffset((PsiFile)contextFile, (int)offset);
        String fileText = contextFile.getText();
        for (PostfixTemplateProvider provider : LanguagePostfixTemplate.LANG_EP.allForLanguage(language)) {
            if (!StringUtil.isNotEmpty((String)PostfixLiveTemplate.computeTemplateKeyWithoutContextChecking(provider, fileText, offset + 1))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean supportsWrapping() {
        return false;
    }

    @Override
    public void wrap(@NotNull String selection, @NotNull CustomTemplateCallback callback) {
        if (selection == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(8);
        }
        if (callback == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(9);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public String getTitle() {
        if ("Postfix" == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(10);
        }
        return "Postfix";
    }

    @Override
    public char getShortcut() {
        PostfixTemplatesSettings settings = PostfixTemplatesSettings.getInstance();
        return settings != null ? (char)settings.getShortcut() : (char)'\t';
    }

    @Override
    public boolean hasCompletionItem(@NotNull CustomTemplateCallback callback, int offset) {
        if (callback == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(11);
        }
        return true;
    }

    @Override
    @NotNull
    public Collection<? extends CustomLiveTemplateLookupElement> getLookupElements(@NotNull PsiFile file2, @NotNull Editor editor, int offset) {
        if (file2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(12);
        }
        if (editor == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(13);
        }
        HashSet result2 = ContainerUtil.newHashSet();
        CustomTemplateCallback callback = new CustomTemplateCallback(editor, file2);
        for (PostfixTemplateProvider provider : LanguagePostfixTemplate.LANG_EP.allForLanguage(PostfixLiveTemplate.getLanguage(callback))) {
            ProgressManager.checkCanceled();
            String key2 = this.computeTemplateKeyWithoutContextChecking(callback);
            if (key2 == null || editor.getCaretModel().getCaretCount() != 1) continue;
            Condition<PostfixTemplate> isApplicationTemplateFunction = PostfixLiveTemplate.createIsApplicationTemplateFunction(provider, key2, file2, editor);
            for (PostfixTemplate postfixTemplate : provider.getTemplates()) {
                ProgressManager.checkCanceled();
                if (!isApplicationTemplateFunction.value((Object)postfixTemplate)) continue;
                result2.add(new PostfixTemplateLookupElement(this, postfixTemplate, postfixTemplate.getKey(), provider, false));
            }
        }
        HashSet hashSet = result2;
        if (hashSet == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(14);
        }
        return hashSet;
    }

    private static void expandTemplate(@NotNull PostfixTemplate template, @NotNull Editor editor, @NotNull PsiElement context) {
        if (template == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(15);
        }
        if (editor == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(16);
        }
        if (context == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(17);
        }
        if (template.startInWriteAction()) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (context == null) {
                    PostfixLiveTemplate.$$$reportNull$$$0(41);
                }
                if (template == null) {
                    PostfixLiveTemplate.$$$reportNull$$$0(42);
                }
                if (editor == null) {
                    PostfixLiveTemplate.$$$reportNull$$$0(43);
                }
                CommandProcessor.getInstance().executeCommand(context.getProject(), () -> {
                    if (template == null) {
                        PostfixLiveTemplate.$$$reportNull$$$0(44);
                    }
                    if (context == null) {
                        PostfixLiveTemplate.$$$reportNull$$$0(45);
                    }
                    if (editor == null) {
                        PostfixLiveTemplate.$$$reportNull$$$0(46);
                    }
                    template.expand(context, editor);
                }, "Expand postfix template", (Object)POSTFIX_TEMPLATE_ID);
            });
        } else {
            template.expand(context, editor);
        }
    }

    private static int deleteTemplateKey(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull String key2) {
        if (file2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(18);
        }
        if (editor == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(19);
        }
        if (key2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(20);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        int currentOffset = editor.getCaretModel().getOffset();
        int newOffset = currentOffset - key2.length();
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (editor == null) {
                PostfixLiveTemplate.$$$reportNull$$$0(37);
            }
            if (file2 == null) {
                PostfixLiveTemplate.$$$reportNull$$$0(38);
            }
            CommandProcessor.getInstance().runUndoTransparentAction(() -> {
                if (editor == null) {
                    PostfixLiveTemplate.$$$reportNull$$$0(39);
                }
                if (file2 == null) {
                    PostfixLiveTemplate.$$$reportNull$$$0(40);
                }
                Document document = editor.getDocument();
                document.deleteString(newOffset, currentOffset);
                editor.getCaretModel().moveToOffset(newOffset);
                PsiDocumentManager.getInstance((Project)file2.getProject()).commitDocument(document);
            });
        });
        return newOffset;
    }

    private static Condition<PostfixTemplate> createIsApplicationTemplateFunction(@NotNull PostfixTemplateProvider provider, @NotNull String key2, @NotNull PsiFile file2, @NotNull Editor editor) {
        if (provider == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(21);
        }
        if (key2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(22);
        }
        if (file2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(23);
        }
        if (editor == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(24);
        }
        if (file2.getFileType().isBinary()) {
            return Conditions.alwaysFalse();
        }
        int currentOffset = editor.getCaretModel().getOffset();
        int newOffset = currentOffset - key2.length();
        CharSequence fileContent = editor.getDocument().getCharsSequence();
        StringBuilder fileContentWithoutKey = new StringBuilder();
        fileContentWithoutKey.append(fileContent.subSequence(0, newOffset));
        fileContentWithoutKey.append(fileContent.subSequence(currentOffset, fileContent.length()));
        PsiFile copyFile = PostfixLiveTemplate.copyFile(file2, fileContentWithoutKey);
        Document copyDocument = copyFile.getViewProvider().getDocument();
        if (copyDocument == null) {
            return Conditions.alwaysFalse();
        }
        copyDocument = (copyFile = provider.preCheck(copyFile, editor, newOffset)).getViewProvider().getDocument();
        if (copyDocument == null) {
            return Conditions.alwaysFalse();
        }
        PsiElement context = CustomTemplateCallback.getContext(copyFile, PostfixLiveTemplate.positiveOffset(newOffset));
        Document finalCopyDocument = copyDocument;
        return template -> {
            if (provider == null) {
                PostfixLiveTemplate.$$$reportNull$$$0(36);
            }
            return template != null && template.isEnabled(provider) && template.isApplicable(context, finalCopyDocument, newOffset);
        };
    }

    @NotNull
    public static PsiFile copyFile(@NotNull PsiFile file2, @NotNull StringBuilder fileContentWithoutKey) {
        VirtualFile vFile;
        PsiFile copy;
        if (file2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(25);
        }
        if (fileContentWithoutKey == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(26);
        }
        PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)file2.getProject());
        Language language = LanguageUtil.getLanguageForPsi((Project)file2.getProject(), (VirtualFile)file2.getVirtualFile());
        PsiFile psiFile = copy = language != null ? psiFileFactory.createFileFromText(file2.getName(), language, (CharSequence)fileContentWithoutKey, false, true) : psiFileFactory.createFileFromText(file2.getName(), file2.getFileType(), (CharSequence)fileContentWithoutKey);
        if (copy instanceof PsiFileImpl) {
            ((PsiFileImpl)copy).setOriginalFile(TemplateLanguageUtil.getBaseFile((PsiFile)file2));
        }
        if ((vFile = copy.getVirtualFile()) != null) {
            vFile.putUserData(UndoConstants.DONT_RECORD_UNDO, (Object)Boolean.TRUE);
        }
        PsiFile psiFile2 = copy;
        if (psiFile2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(27);
        }
        return psiFile2;
    }

    public static boolean isApplicableTemplate(@NotNull PostfixTemplateProvider provider, @NotNull String key2, @NotNull PsiFile file2, @NotNull Editor editor) {
        if (provider == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(28);
        }
        if (key2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(29);
        }
        if (file2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(30);
        }
        if (editor == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(31);
        }
        return PostfixLiveTemplate.createIsApplicationTemplateFunction(provider, key2, file2, editor).value((Object)PostfixLiveTemplate.getTemplate(provider, key2));
    }

    @NotNull
    private static Set<String> getKeys(@NotNull PostfixTemplateProvider provider) {
        if (provider == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(32);
        }
        HashSet result2 = ContainerUtil.newHashSet();
        for (PostfixTemplate template : provider.getTemplates()) {
            result2.add(template.getKey());
        }
        HashSet hashSet = result2;
        if (hashSet == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(33);
        }
        return hashSet;
    }

    @Nullable
    private static PostfixTemplate getTemplate(@NotNull PostfixTemplateProvider provider, @Nullable String key2) {
        if (provider == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(34);
        }
        for (PostfixTemplate template : provider.getTemplates()) {
            if (!template.getKey().equals(key2)) continue;
            return template;
        }
        return null;
    }

    private static Language getLanguage(@NotNull CustomTemplateCallback callback) {
        if (callback == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(35);
        }
        return callback.getContext().getLanguage();
    }

    private static int positiveOffset(int offset) {
        return offset > 0 ? offset - 1 : offset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/postfix/templates/PostfixLiveTemplate";
                break;
            }
            case 1: 
            case 21: 
            case 28: 
            case 32: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentContent";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 5: 
            case 20: 
            case 22: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 12: 
            case 18: 
            case 23: 
            case 25: 
            case 30: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: 
            case 16: 
            case 19: 
            case 24: 
            case 31: 
            case 37: 
            case 39: 
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 15: 
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 17: 
            case 41: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContentWithoutKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTemplateKeys";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/postfix/templates/PostfixLiveTemplate";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupElements";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFile";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeys";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "computeTemplateKeyWithoutContextChecking";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "computeTemplateKey";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "expand";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasCompletionItem";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getLookupElements";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "expandTemplate";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "deleteTemplateKey";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createIsApplicationTemplateFunction";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "copyFile";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableTemplate";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getKeys";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getTemplate";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getLanguage";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createIsApplicationTemplateFunction$4";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "lambda$deleteTemplateKey$3";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$2";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "lambda$expandTemplate$1";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

