/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.intention.impl.TypeExpression;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.impl.TextExpression;
import com.intellij.codeInsight.template.macro.SuggestVariableNameMacro;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.util.JavaPostfixTemplatesUtils;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TryWithResourcesPostfixTemplate
extends PostfixTemplate {
    protected TryWithResourcesPostfixTemplate() {
        super("twr", "try(Type f = new Type()) catch (Exception e)");
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement element, @NotNull Document copyDocument, int newOffset) {
        Project project2;
        JavaPsiFacade facade;
        PsiClass autoCloseable;
        if (element == null) {
            TryWithResourcesPostfixTemplate.$$$reportNull$$$0(0);
        }
        if (copyDocument == null) {
            TryWithResourcesPostfixTemplate.$$$reportNull$$$0(1);
        }
        if (!PsiUtil.isLanguageLevel7OrHigher((PsiElement)element)) {
            return false;
        }
        PsiExpression initializer = JavaPostfixTemplatesUtils.getTopmostExpression(element);
        if (initializer == null) {
            return false;
        }
        PsiType type2 = initializer.getType();
        if (!(type2 instanceof PsiClassType)) {
            return false;
        }
        PsiClass aClass = ((PsiClassType)type2).resolve();
        return InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)(autoCloseable = (facade = JavaPsiFacade.getInstance((Project)(project2 = element.getProject()))).findClass("java.lang.AutoCloseable", ProjectScope.getLibrariesScope((Project)project2))), (boolean)true);
    }

    @Override
    public void expand(@NotNull PsiElement context, @NotNull Editor editor) {
        if (context == null) {
            TryWithResourcesPostfixTemplate.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            TryWithResourcesPostfixTemplate.$$$reportNull$$$0(3);
        }
        PsiExpression expression2 = JavaPostfixTemplatesUtils.getTopmostExpression(context);
        assert (expression2 != null);
        Project project2 = context.getProject();
        editor.getDocument().deleteString(expression2.getTextRange().getStartOffset(), expression2.getTextRange().getEndOffset());
        TemplateManager manager = TemplateManager.getInstance(project2);
        Template template = manager.createTemplate("", "");
        template.setToReformat(true);
        template.addTextSegment("try (");
        MacroCallNode name2 = new MacroCallNode(new SuggestVariableNameMacro());
        template.addVariable("type", new TypeExpression(project2, new PsiType[]{expression2.getType()}), false);
        template.addTextSegment(" ");
        template.addVariable("name", name2, name2, true);
        template.addTextSegment(" = ");
        template.addVariable("variable", (Expression)new TextExpression(expression2.getText()), false);
        template.addTextSegment(") {\n");
        template.addEndVariable();
        template.addTextSegment("\n}");
        Collection<PsiClassType> unhandled = TryWithResourcesPostfixTemplate.getUnhandled(expression2);
        for (PsiClassType exception : unhandled) {
            MacroCallNode variable = new MacroCallNode(new SuggestVariableNameMacro());
            template.addTextSegment("catch(");
            template.addVariable("type " + exception.getClassName(), new TypeExpression(project2, new PsiType[]{exception}), false);
            template.addTextSegment(" ");
            template.addVariable("name " + exception.getClassName(), variable, variable, false);
            template.addTextSegment(") {}");
        }
        manager.startTemplate(editor, template);
    }

    @NotNull
    private static Collection<PsiClassType> getUnhandled(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            TryWithResourcesPostfixTemplate.$$$reportNull$$$0(4);
        }
        assert (expression2.getType() != null);
        List<PsiClassType> list2 = ExceptionUtil.getUnhandledCloserExceptions((PsiElement)expression2, null, expression2.getType());
        if (list2 == null) {
            TryWithResourcesPostfixTemplate.$$$reportNull$$$0(5);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyDocument";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/postfix/templates/TryWithResourcesPostfixTemplate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/postfix/templates/TryWithResourcesPostfixTemplate";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnhandled";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "expand";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getUnhandled";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

