/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ExplicitTypeCanBeDiamondInspection
extends AbstractBaseJavaLocalInspectionTool {
    public static final Logger LOG = Logger.getInstance(ExplicitTypeCanBeDiamondInspection.class);

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.LANGUAGE_LEVEL_SPECIFIC_GROUP_NAME;
        if (string == null) {
            ExplicitTypeCanBeDiamondInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Explicit type can be replaced with <>" == null) {
            ExplicitTypeCanBeDiamondInspection.$$$reportNull$$$0(1);
        }
        return "Explicit type can be replaced with <>";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getShortName() {
        if ("Convert2Diamond" == null) {
            ExplicitTypeCanBeDiamondInspection.$$$reportNull$$$0(2);
        }
        return "Convert2Diamond";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ExplicitTypeCanBeDiamondInspection.$$$reportNull$$$0(3);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitNewExpression(PsiNewExpression expression2) {
                if (PsiDiamondTypeUtil.canCollapseToDiamond(expression2, expression2, null)) {
                    PsiJavaCodeReferenceElement classReference2 = expression2.getClassOrAnonymousClassReference();
                    LOG.assertTrue(classReference2 != null);
                    PsiReferenceParameterList parameterList = classReference2.getParameterList();
                    LOG.assertTrue(parameterList != null);
                    PsiElement firstChild = parameterList.getFirstChild();
                    PsiElement lastChild = parameterList.getLastChild();
                    TextRange range = new TextRange(firstChild != null && firstChild.getNode().getElementType() == JavaTokenType.LT ? 1 : 0, parameterList.getTextLength() - (lastChild != null && lastChild.getNode().getElementType() == JavaTokenType.GT ? 1 : 0));
                    holder.registerProblem((PsiElement)parameterList, "Explicit type argument #ref #loc can be replaced with <>", ProblemHighlightType.LIKE_UNUSED_SYMBOL, range, new LocalQuickFix[]{new ReplaceWithDiamondFix()});
                }
            }
        };
        if (javaElementVisitor == null) {
            ExplicitTypeCanBeDiamondInspection.$$$reportNull$$$0(4);
        }
        return javaElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ExplicitTypeCanBeDiamondInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ExplicitTypeCanBeDiamondInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ReplaceWithDiamondFix
    implements LocalQuickFix,
    HighPriorityAction {
        private ReplaceWithDiamondFix() {
        }

        @NotNull
        public String getFamilyName() {
            if ("Replace with <>" == null) {
                ReplaceWithDiamondFix.$$$reportNull$$$0(0);
            }
            return "Replace with <>";
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            PsiElement element;
            PsiNewExpression newExpression;
            if (project2 == null) {
                ReplaceWithDiamondFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                ReplaceWithDiamondFix.$$$reportNull$$$0(2);
            }
            if ((newExpression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)PsiDiamondTypeUtil.replaceExplicitWithDiamond(element = descriptor2.getPsiElement()), PsiNewExpression.class)) != null) {
                CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)newExpression);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ExplicitTypeCanBeDiamondInspection$ReplaceWithDiamondFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ExplicitTypeCanBeDiamondInspection$ReplaceWithDiamondFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

