/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.NullnessUtil;
import com.intellij.codeInspection.util.LambdaGenerationUtil;
import com.intellij.codeInspection.util.OptionalUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptionalIsPresentInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(OptionalIsPresentInspection.class);
    private static final OptionalIsPresentCase[] CASES = new OptionalIsPresentCase[]{new ReturnCase(), new AssignmentCase(), new ConsumerCase(), new TernaryCase()};

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            OptionalIsPresentInspection.$$$reportNull$$$0(0);
        }
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                OptionalIsPresentInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitConditionalExpression(@NotNull PsiConditionalExpression expression2) {
                PsiReferenceExpression optionalRef;
                if (expression2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitConditionalExpression(expression2);
                PsiExpression condition2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2.getCondition());
                if (condition2 == null) {
                    return;
                }
                boolean invert = false;
                PsiExpression strippedCondition = condition2;
                if (BoolUtils.isNegation(condition2)) {
                    strippedCondition = BoolUtils.getNegated(condition2);
                    invert = true;
                }
                if ((optionalRef = OptionalIsPresentInspection.extractOptionalFromIfPresentCheck(strippedCondition)) == null) {
                    return;
                }
                PsiExpression thenExpression2 = invert ? expression2.getElseExpression() : expression2.getThenExpression();
                PsiExpression elseExpression2 = invert ? expression2.getThenExpression() : expression2.getElseExpression();
                this.check(condition2, optionalRef, (PsiElement)thenExpression2, (PsiElement)elseExpression2);
            }

            public void visitIfStatement(@NotNull PsiIfStatement statement2) {
                PsiReferenceExpression optionalRef;
                if (statement2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitIfStatement(statement2);
                PsiExpression condition2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)statement2.getCondition());
                if (condition2 == null) {
                    return;
                }
                boolean invert = false;
                PsiExpression strippedCondition = condition2;
                if (BoolUtils.isNegation(condition2)) {
                    strippedCondition = BoolUtils.getNegated(condition2);
                    invert = true;
                }
                if ((optionalRef = OptionalIsPresentInspection.extractOptionalFromIfPresentCheck(strippedCondition)) == null) {
                    return;
                }
                PsiStatement thenStatement = OptionalIsPresentInspection.extractThenStatement(statement2, invert);
                PsiStatement elseStatement = OptionalIsPresentInspection.extractElseStatement(statement2, invert);
                this.check(condition2, optionalRef, (PsiElement)thenStatement, (PsiElement)elseStatement);
            }

            void check(@NotNull PsiExpression condition2, PsiReferenceExpression optionalRef, PsiElement thenElement, PsiElement elseElement) {
                if (condition2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                for (OptionalIsPresentCase scenario : CASES) {
                    scenario.getProblemType(optionalRef, thenElement, elseElement).registerProblem(holder, condition2, scenario);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "statement";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "condition";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/OptionalIsPresentInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitConditionalExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitIfStatement";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "check";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (javaElementVisitor == null) {
            OptionalIsPresentInspection.$$$reportNull$$$0(2);
        }
        return javaElementVisitor;
    }

    private static boolean isRaw(@NotNull PsiVariable variable) {
        PsiType type2;
        if (variable == null) {
            OptionalIsPresentInspection.$$$reportNull$$$0(3);
        }
        return (type2 = variable.getType()) instanceof PsiClassType && ((PsiClassType)type2).isRaw();
    }

    @Nullable
    private static PsiStatement extractThenStatement(@NotNull PsiIfStatement ifStatement, boolean invert) {
        if (ifStatement == null) {
            OptionalIsPresentInspection.$$$reportNull$$$0(4);
        }
        if (invert) {
            return OptionalIsPresentInspection.extractElseStatement(ifStatement, false);
        }
        return ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
    }

    @Nullable
    private static PsiStatement extractElseStatement(@NotNull PsiIfStatement ifStatement, boolean invert) {
        PsiElement nextElement;
        PsiStatement thenStatement;
        if (ifStatement == null) {
            OptionalIsPresentInspection.$$$reportNull$$$0(5);
        }
        if (invert) {
            return OptionalIsPresentInspection.extractThenStatement(ifStatement, false);
        }
        PsiStatement statement2 = ControlFlowUtils.stripBraces(ifStatement.getElseBranch());
        if (statement2 == null && (thenStatement = OptionalIsPresentInspection.extractThenStatement(ifStatement, false)) instanceof PsiReturnStatement && (nextElement = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)ifStatement)) instanceof PsiStatement) {
            statement2 = ControlFlowUtils.stripBraces((PsiStatement)nextElement);
        }
        return statement2;
    }

    @Nullable
    @Contract(value="null -> null")
    static PsiReferenceExpression extractOptionalFromIfPresentCheck(PsiExpression expression2) {
        if (!(expression2 instanceof PsiMethodCallExpression)) {
            return null;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)expression2;
        if (call.getArgumentList().getExpressions().length != 0) {
            return null;
        }
        if (!"isPresent".equals(call.getMethodExpression().getReferenceName())) {
            return null;
        }
        PsiMethod method = call.resolveMethod();
        if (method == null) {
            return null;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null || !"java.util.Optional".equals(containingClass.getQualifiedName())) {
            return null;
        }
        PsiReferenceExpression qualifier = (PsiReferenceExpression)ObjectUtils.tryCast((Object)call.getMethodExpression().getQualifierExpression(), PsiReferenceExpression.class);
        if (qualifier == null) {
            return null;
        }
        PsiElement element = qualifier.resolve();
        if (!(element instanceof PsiVariable) || OptionalIsPresentInspection.isRaw((PsiVariable)element)) {
            return null;
        }
        return qualifier;
    }

    @Contract(value="null, _ -> false")
    static boolean isOptionalGetCall(PsiElement element, @NotNull PsiReferenceExpression optionalRef) {
        if (optionalRef == null) {
            OptionalIsPresentInspection.$$$reportNull$$$0(6);
        }
        if (!(element instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)element;
        if (call.getArgumentList().getExpressions().length != 0) {
            return false;
        }
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        return "get".equals(methodExpression.getReferenceName()) && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)ExpressionUtils.getQualifierOrThis(methodExpression), (PsiElement)optionalRef);
    }

    @NotNull
    static ProblemType getTypeByLambdaCandidate(@NotNull PsiReferenceExpression optionalRef, @Nullable PsiElement lambdaCandidate, @Nullable PsiExpression falseExpression) {
        if (optionalRef == null) {
            OptionalIsPresentInspection.$$$reportNull$$$0(7);
        }
        if (lambdaCandidate == null) {
            ProblemType problemType = ProblemType.NONE;
            if (problemType == null) {
                OptionalIsPresentInspection.$$$reportNull$$$0(8);
            }
            return problemType;
        }
        if (lambdaCandidate instanceof PsiReferenceExpression && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)lambdaCandidate, (PsiElement)optionalRef) && OptionalUtil.isOptionalEmptyCall(falseExpression)) {
            ProblemType problemType = ProblemType.WARNING;
            if (problemType == null) {
                OptionalIsPresentInspection.$$$reportNull$$$0(9);
            }
            return problemType;
        }
        if (!LambdaGenerationUtil.canBeUncheckedLambda(lambdaCandidate, arg_0 -> ((PsiReferenceExpression)optionalRef).isReferenceTo(arg_0))) {
            ProblemType problemType = ProblemType.NONE;
            if (problemType == null) {
                OptionalIsPresentInspection.$$$reportNull$$$0(10);
            }
            return problemType;
        }
        Ref hasOptionalReference = new Ref((Object)Boolean.FALSE);
        boolean hasNoBadRefs = PsiTreeUtil.processElements((PsiElement)lambdaCandidate, e -> {
            if (optionalRef == null) {
                OptionalIsPresentInspection.$$$reportNull$$$0(24);
            }
            if (!(e instanceof PsiReferenceExpression)) {
                return true;
            }
            if (!PsiEquivalenceUtil.areElementsEquivalent((PsiElement)e, (PsiElement)optionalRef)) {
                return true;
            }
            hasOptionalReference.set((Object)Boolean.TRUE);
            return OptionalIsPresentInspection.isOptionalGetCall(e.getParent().getParent(), optionalRef);
        });
        if (!hasNoBadRefs) {
            ProblemType problemType = ProblemType.NONE;
            if (problemType == null) {
                OptionalIsPresentInspection.$$$reportNull$$$0(11);
            }
            return problemType;
        }
        if (!((Boolean)hasOptionalReference.get()).booleanValue() || !(lambdaCandidate instanceof PsiExpression)) {
            ProblemType problemType = ProblemType.INFO;
            if (problemType == null) {
                OptionalIsPresentInspection.$$$reportNull$$$0(12);
            }
            return problemType;
        }
        PsiExpression expression2 = (PsiExpression)lambdaCandidate;
        if (falseExpression != null && NullnessUtil.getExpressionNullness(expression2) != Nullness.NOT_NULL) {
            ProblemType problemType = ProblemType.INFO;
            if (problemType == null) {
                OptionalIsPresentInspection.$$$reportNull$$$0(13);
            }
            return problemType;
        }
        ProblemType problemType = ProblemType.WARNING;
        if (problemType == null) {
            OptionalIsPresentInspection.$$$reportNull$$$0(14);
        }
        return problemType;
    }

    @NotNull
    static String generateOptionalLambda(@NotNull PsiElementFactory factory, @NotNull CommentTracker ct, PsiReferenceExpression optionalRef, PsiElement trueValue) {
        if (factory == null) {
            OptionalIsPresentInspection.$$$reportNull$$$0(15);
        }
        if (ct == null) {
            OptionalIsPresentInspection.$$$reportNull$$$0(16);
        }
        PsiType type2 = optionalRef.getType();
        JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)trueValue.getProject());
        SuggestedNameInfo info = javaCodeStyleManager.suggestVariableName(VariableKind.PARAMETER, null, null, type2);
        String baseName = (String)ObjectUtils.coalesce((Object)ArrayUtil.getFirstElement((Object[])info.names), (Object)"value");
        String paramName = javaCodeStyleManager.suggestUniqueVariableName(baseName, trueValue, true);
        if (trueValue instanceof PsiExpressionStatement) {
            trueValue = ((PsiExpressionStatement)trueValue).getExpression();
        }
        ct.markUnchanged(trueValue);
        PsiElement copy = trueValue.copy();
        for (PsiElement getCall : PsiTreeUtil.collectElements((PsiElement)copy, e -> OptionalIsPresentInspection.isOptionalGetCall(e, optionalRef))) {
            PsiElement result2 = getCall.replace((PsiElement)factory.createIdentifier(paramName));
            if (copy != getCall) continue;
            copy = result2;
        }
        if (copy instanceof PsiStatement && !(copy instanceof PsiBlockStatement)) {
            String string = paramName + "->{" + copy.getText() + "}";
            if (string == null) {
                OptionalIsPresentInspection.$$$reportNull$$$0(17);
            }
            return string;
        }
        String string = paramName + "->" + copy.getText();
        if (string == null) {
            OptionalIsPresentInspection.$$$reportNull$$$0(18);
        }
        return string;
    }

    static String generateOptionalUnwrap(@NotNull PsiElementFactory factory, @NotNull CommentTracker ct, @NotNull PsiReferenceExpression optionalRef, @NotNull PsiExpression trueValue, @NotNull PsiExpression falseValue, PsiType targetType) {
        if (factory == null) {
            OptionalIsPresentInspection.$$$reportNull$$$0(19);
        }
        if (ct == null) {
            OptionalIsPresentInspection.$$$reportNull$$$0(20);
        }
        if (optionalRef == null) {
            OptionalIsPresentInspection.$$$reportNull$$$0(21);
        }
        if (trueValue == null) {
            OptionalIsPresentInspection.$$$reportNull$$$0(22);
        }
        if (falseValue == null) {
            OptionalIsPresentInspection.$$$reportNull$$$0(23);
        }
        if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)trueValue, (PsiElement)optionalRef) && OptionalUtil.isOptionalEmptyCall(falseValue)) {
            trueValue = factory.createExpressionFromText("java.util.Optional.of(" + optionalRef.getText() + ".get())", (PsiElement)trueValue);
        }
        if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)falseValue, (PsiElement)optionalRef)) {
            falseValue = factory.createExpressionFromText("java.util.Optional.empty()", (PsiElement)falseValue);
        }
        String lambdaText = OptionalIsPresentInspection.generateOptionalLambda(factory, ct, optionalRef, (PsiElement)trueValue);
        PsiLambdaExpression lambda2 = (PsiLambdaExpression)factory.createExpressionFromText(lambdaText, (PsiElement)trueValue);
        return OptionalUtil.generateOptionalUnwrap(optionalRef.getText(), (PsiVariable)lambda2.getParameterList().getParameters()[0], (PsiExpression)lambda2.getBody(), ct.markUnchanged(falseValue), targetType, true);
    }

    static boolean isSimpleOrUnchecked(PsiExpression expression2) {
        return ExpressionUtils.isSimpleExpression(expression2) || LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)expression2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/OptionalIsPresentInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifStatement";
                break;
            }
            case 6: 
            case 7: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionalRef";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ct";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trueValue";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "falseValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/OptionalIsPresentInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeByLambdaCandidate";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "generateOptionalLambda";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isRaw";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "extractThenStatement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "extractElseStatement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isOptionalGetCall";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTypeByLambdaCandidate";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "generateOptionalLambda";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "generateOptionalUnwrap";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getTypeByLambdaCandidate$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ConsumerCase
    implements OptionalIsPresentCase {
        ConsumerCase() {
        }

        @Override
        @NotNull
        public ProblemType getProblemType(@NotNull PsiReferenceExpression optionalRef, @Nullable PsiElement trueElement, @Nullable PsiElement falseElement) {
            if (optionalRef == null) {
                ConsumerCase.$$$reportNull$$$0(0);
            }
            if (falseElement != null && !(falseElement instanceof PsiEmptyStatement)) {
                ProblemType problemType = ProblemType.NONE;
                if (problemType == null) {
                    ConsumerCase.$$$reportNull$$$0(1);
                }
                return problemType;
            }
            if (!(trueElement instanceof PsiStatement)) {
                ProblemType problemType = ProblemType.NONE;
                if (problemType == null) {
                    ConsumerCase.$$$reportNull$$$0(2);
                }
                return problemType;
            }
            if (trueElement instanceof PsiExpressionStatement) {
                PsiExpression expression2 = ((PsiExpressionStatement)trueElement).getExpression();
                if (OptionalIsPresentInspection.isOptionalGetCall((PsiElement)expression2, optionalRef)) {
                    ProblemType problemType = ProblemType.NONE;
                    if (problemType == null) {
                        ConsumerCase.$$$reportNull$$$0(3);
                    }
                    return problemType;
                }
                trueElement = expression2;
            }
            ProblemType problemType = OptionalIsPresentInspection.getTypeByLambdaCandidate(optionalRef, trueElement, null);
            if (problemType == null) {
                ConsumerCase.$$$reportNull$$$0(4);
            }
            return problemType;
        }

        @Override
        @NotNull
        public String generateReplacement(@NotNull PsiElementFactory factory, @NotNull CommentTracker ct, @NotNull PsiReferenceExpression optionalRef, PsiElement trueElement, PsiElement falseElement) {
            if (factory == null) {
                ConsumerCase.$$$reportNull$$$0(5);
            }
            if (ct == null) {
                ConsumerCase.$$$reportNull$$$0(6);
            }
            if (optionalRef == null) {
                ConsumerCase.$$$reportNull$$$0(7);
            }
            String string = optionalRef.getText() + ".ifPresent(" + OptionalIsPresentInspection.generateOptionalLambda(factory, ct, optionalRef, trueElement) + ");";
            if (string == null) {
                ConsumerCase.$$$reportNull$$$0(8);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "optionalRef";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/OptionalIsPresentInspection$ConsumerCase";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ct";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/OptionalIsPresentInspection$ConsumerCase";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProblemType";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generateReplacement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getProblemType";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 8: {
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "generateReplacement";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class TernaryCase
    implements OptionalIsPresentCase {
        TernaryCase() {
        }

        @Override
        @NotNull
        public ProblemType getProblemType(@NotNull PsiReferenceExpression optionalVariable, @Nullable PsiElement trueElement, @Nullable PsiElement falseElement) {
            if (optionalVariable == null) {
                TernaryCase.$$$reportNull$$$0(0);
            }
            if (!(trueElement instanceof PsiExpression) || !(falseElement instanceof PsiExpression)) {
                ProblemType problemType = ProblemType.NONE;
                if (problemType == null) {
                    TernaryCase.$$$reportNull$$$0(1);
                }
                return problemType;
            }
            PsiExpression trueExpression = (PsiExpression)trueElement;
            PsiExpression falseExpression = (PsiExpression)falseElement;
            PsiType trueType = trueExpression.getType();
            PsiType falseType = falseExpression.getType();
            if (trueType == null || falseType == null || !trueType.isAssignableFrom(falseType) || !OptionalIsPresentInspection.isSimpleOrUnchecked(falseExpression)) {
                ProblemType problemType = ProblemType.NONE;
                if (problemType == null) {
                    TernaryCase.$$$reportNull$$$0(2);
                }
                return problemType;
            }
            ProblemType problemType = OptionalIsPresentInspection.getTypeByLambdaCandidate(optionalVariable, (PsiElement)trueExpression, falseExpression);
            if (problemType == null) {
                TernaryCase.$$$reportNull$$$0(3);
            }
            return problemType;
        }

        @Override
        @NotNull
        public String generateReplacement(@NotNull PsiElementFactory factory, @NotNull CommentTracker ct, @NotNull PsiReferenceExpression optionalVariable, PsiElement trueElement, PsiElement falseElement) {
            if (factory == null) {
                TernaryCase.$$$reportNull$$$0(4);
            }
            if (ct == null) {
                TernaryCase.$$$reportNull$$$0(5);
            }
            if (optionalVariable == null) {
                TernaryCase.$$$reportNull$$$0(6);
            }
            PsiExpression ternary = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)trueElement, PsiConditionalExpression.class);
            LOG.assertTrue(ternary != null);
            PsiExpression trueExpression = (PsiExpression)trueElement;
            PsiExpression falseExpression = (PsiExpression)falseElement;
            String string = OptionalIsPresentInspection.generateOptionalUnwrap(factory, ct, optionalVariable, trueExpression, falseExpression, ternary.getType());
            if (string == null) {
                TernaryCase.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "optionalVariable";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/OptionalIsPresentInspection$TernaryCase";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ct";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/OptionalIsPresentInspection$TernaryCase";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProblemType";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generateReplacement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getProblemType";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 7: {
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "generateReplacement";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class AssignmentCase
    implements OptionalIsPresentCase {
        AssignmentCase() {
        }

        @Override
        @NotNull
        public ProblemType getProblemType(@NotNull PsiReferenceExpression optionalVariable, @Nullable PsiElement trueElement, @Nullable PsiElement falseElement) {
            if (optionalVariable == null) {
                AssignmentCase.$$$reportNull$$$0(0);
            }
            PsiAssignmentExpression trueAssignment = ExpressionUtils.getAssignment(trueElement);
            PsiAssignmentExpression falseAssignment = ExpressionUtils.getAssignment(falseElement);
            if (trueAssignment == null || falseAssignment == null) {
                ProblemType problemType = ProblemType.NONE;
                if (problemType == null) {
                    AssignmentCase.$$$reportNull$$$0(1);
                }
                return problemType;
            }
            PsiExpression falseVal = falseAssignment.getRExpression();
            PsiExpression trueVal = trueAssignment.getRExpression();
            if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)trueAssignment.getLExpression(), (PsiElement)falseAssignment.getLExpression()) && OptionalIsPresentInspection.isSimpleOrUnchecked(falseVal)) {
                ProblemType problemType = OptionalIsPresentInspection.getTypeByLambdaCandidate(optionalVariable, (PsiElement)trueVal, falseVal);
                if (problemType == null) {
                    AssignmentCase.$$$reportNull$$$0(2);
                }
                return problemType;
            }
            ProblemType problemType = ProblemType.NONE;
            if (problemType == null) {
                AssignmentCase.$$$reportNull$$$0(3);
            }
            return problemType;
        }

        @Override
        @NotNull
        public String generateReplacement(@NotNull PsiElementFactory factory, @NotNull CommentTracker ct, @NotNull PsiReferenceExpression optionalRef, PsiElement trueElement, PsiElement falseElement) {
            if (factory == null) {
                AssignmentCase.$$$reportNull$$$0(4);
            }
            if (ct == null) {
                AssignmentCase.$$$reportNull$$$0(5);
            }
            if (optionalRef == null) {
                AssignmentCase.$$$reportNull$$$0(6);
            }
            PsiAssignmentExpression trueAssignment = ExpressionUtils.getAssignment(trueElement);
            PsiAssignmentExpression falseAssignment = ExpressionUtils.getAssignment(falseElement);
            LOG.assertTrue(trueAssignment != null);
            LOG.assertTrue(falseAssignment != null);
            PsiExpression lValue = trueAssignment.getLExpression();
            PsiExpression trueValue = trueAssignment.getRExpression();
            PsiExpression falseValue = falseAssignment.getRExpression();
            LOG.assertTrue(trueValue != null);
            LOG.assertTrue(falseValue != null);
            String string = lValue.getText() + " = " + OptionalIsPresentInspection.generateOptionalUnwrap(factory, ct, optionalRef, trueValue, falseValue, lValue.getType()) + ";";
            if (string == null) {
                AssignmentCase.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "optionalVariable";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/OptionalIsPresentInspection$AssignmentCase";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ct";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "optionalRef";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/OptionalIsPresentInspection$AssignmentCase";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProblemType";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generateReplacement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getProblemType";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 7: {
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "generateReplacement";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class ReturnCase
    implements OptionalIsPresentCase {
        ReturnCase() {
        }

        @Override
        @NotNull
        public ProblemType getProblemType(@NotNull PsiReferenceExpression optionalRef, @Nullable PsiElement trueElement, @Nullable PsiElement falseElement) {
            if (optionalRef == null) {
                ReturnCase.$$$reportNull$$$0(0);
            }
            if (!(trueElement instanceof PsiReturnStatement) || !(falseElement instanceof PsiReturnStatement)) {
                ProblemType problemType = ProblemType.NONE;
                if (problemType == null) {
                    ReturnCase.$$$reportNull$$$0(1);
                }
                return problemType;
            }
            PsiExpression falseValue = ((PsiReturnStatement)falseElement).getReturnValue();
            PsiExpression trueValue = ((PsiReturnStatement)trueElement).getReturnValue();
            if (!OptionalIsPresentInspection.isSimpleOrUnchecked(falseValue)) {
                ProblemType problemType = ProblemType.NONE;
                if (problemType == null) {
                    ReturnCase.$$$reportNull$$$0(2);
                }
                return problemType;
            }
            ProblemType problemType = OptionalIsPresentInspection.getTypeByLambdaCandidate(optionalRef, (PsiElement)trueValue, falseValue);
            if (problemType == null) {
                ReturnCase.$$$reportNull$$$0(3);
            }
            return problemType;
        }

        @Override
        @NotNull
        public String generateReplacement(@NotNull PsiElementFactory factory, @NotNull CommentTracker ct, @NotNull PsiReferenceExpression optionalVariable, PsiElement trueElement, PsiElement falseElement) {
            if (factory == null) {
                ReturnCase.$$$reportNull$$$0(4);
            }
            if (ct == null) {
                ReturnCase.$$$reportNull$$$0(5);
            }
            if (optionalVariable == null) {
                ReturnCase.$$$reportNull$$$0(6);
            }
            PsiExpression trueValue = ((PsiReturnStatement)trueElement).getReturnValue();
            PsiExpression falseValue = ((PsiReturnStatement)falseElement).getReturnValue();
            LOG.assertTrue(trueValue != null);
            LOG.assertTrue(falseValue != null);
            String string = "return " + OptionalIsPresentInspection.generateOptionalUnwrap(factory, ct, optionalVariable, trueValue, falseValue, PsiTypesUtil.getMethodReturnType((PsiElement)trueElement)) + ";";
            if (string == null) {
                ReturnCase.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "optionalRef";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/OptionalIsPresentInspection$ReturnCase";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ct";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "optionalVariable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/OptionalIsPresentInspection$ReturnCase";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProblemType";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generateReplacement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getProblemType";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 7: {
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "generateReplacement";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static interface OptionalIsPresentCase {
        @NotNull
        public ProblemType getProblemType(@NotNull PsiReferenceExpression var1, @Nullable PsiElement var2, @Nullable PsiElement var3);

        @NotNull
        public String generateReplacement(@NotNull PsiElementFactory var1, @NotNull CommentTracker var2, @NotNull PsiReferenceExpression var3, PsiElement var4, PsiElement var5);
    }

    static class OptionalIsPresentFix
    implements LocalQuickFix {
        private final OptionalIsPresentCase myScenario;

        public OptionalIsPresentFix(OptionalIsPresentCase scenario) {
            this.myScenario = scenario;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Replace Optional.isPresent() condition with functional style expression" == null) {
                OptionalIsPresentFix.$$$reportNull$$$0(0);
            }
            return "Replace Optional.isPresent() condition with functional style expression";
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            PsiStatement elseElement;
            PsiStatement thenElement;
            PsiReferenceExpression optionalRef;
            PsiElement element;
            if (project2 == null) {
                OptionalIsPresentFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                OptionalIsPresentFix.$$$reportNull$$$0(2);
            }
            if (!((element = descriptor2.getStartElement()) instanceof PsiExpression)) {
                return;
            }
            PsiExpression condition2 = (PsiExpression)element;
            boolean invert = false;
            if (BoolUtils.isNegation(condition2)) {
                condition2 = BoolUtils.getNegated(condition2);
                invert = true;
            }
            if ((optionalRef = OptionalIsPresentInspection.extractOptionalFromIfPresentCheck(condition2)) == null) {
                return;
            }
            PsiElement cond = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiIfStatement.class, PsiConditionalExpression.class});
            if (cond instanceof PsiIfStatement) {
                thenElement = OptionalIsPresentInspection.extractThenStatement((PsiIfStatement)cond, invert);
                elseElement = OptionalIsPresentInspection.extractElseStatement((PsiIfStatement)cond, invert);
            } else if (cond instanceof PsiConditionalExpression) {
                thenElement = invert ? ((PsiConditionalExpression)cond).getElseExpression() : ((PsiConditionalExpression)cond).getThenExpression();
                elseElement = invert ? ((PsiConditionalExpression)cond).getThenExpression() : ((PsiConditionalExpression)cond).getElseExpression();
            } else {
                return;
            }
            if (this.myScenario.getProblemType(optionalRef, (PsiElement)thenElement, (PsiElement)elseElement) == ProblemType.NONE) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
            CommentTracker ct = new CommentTracker();
            String replacementText = this.myScenario.generateReplacement(factory, ct, optionalRef, (PsiElement)thenElement, (PsiElement)elseElement);
            if (thenElement != null && !PsiTreeUtil.isAncestor((PsiElement)cond, (PsiElement)thenElement, (boolean)true)) {
                ct.delete((PsiElement)thenElement);
            }
            if (elseElement != null && !PsiTreeUtil.isAncestor((PsiElement)cond, (PsiElement)elseElement, (boolean)true)) {
                ct.delete((PsiElement)elseElement);
            }
            PsiElement result2 = ct.replaceAndRestoreComments(cond, replacementText);
            LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences(result2);
            PsiDiamondTypeUtil.removeRedundantTypeArguments(result2);
            CodeStyleManager.getInstance((Project)project2).reformat(result2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/OptionalIsPresentInspection$OptionalIsPresentFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/OptionalIsPresentInspection$OptionalIsPresentFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static enum ProblemType {
        WARNING,
        INFO,
        NONE;


        void registerProblem(@NotNull ProblemsHolder holder, @NotNull PsiExpression condition2, OptionalIsPresentCase scenario) {
            if (holder == null) {
                ProblemType.$$$reportNull$$$0(0);
            }
            if (condition2 == null) {
                ProblemType.$$$reportNull$$$0(1);
            }
            if (this != NONE) {
                holder.registerProblem(holder.getManager().createProblemDescriptor((PsiElement)condition2, "Can be replaced with single expression in functional style", this != INFO, this == INFO ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING, true, new LocalQuickFix[]{new OptionalIsPresentFix(scenario)}));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "condition";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/OptionalIsPresentInspection$ProblemType";
            objectArray[2] = "registerProblem";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

