/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class OverwrittenKeyInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher SET_ADD = CallMatcher.instanceCall("java.util.Set", "add").parameterCount(1);
    private static final CallMatcher MAP_PUT = CallMatcher.instanceCall("java.util.Map", "put").parameterCount(2);
    private static final CallMatcher SET_OF = CallMatcher.staticCall("java.util.Set", "of");
    private static final CallMatcher MAP_OF = CallMatcher.staticCall("java.util.Map", "of");
    private static final CallMatcher MAP_OF_ENTRIES = CallMatcher.staticCall("java.util.Map", "ofEntries");
    private static final CallMatcher MAP_ENTRY = CallMatcher.staticCall("java.util.Map", "entry");

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            OverwrittenKeyInspection.$$$reportNull$$$0(0);
        }
        OverwrittenKeyVisitor overwrittenKeyVisitor = new OverwrittenKeyVisitor(holder);
        if (overwrittenKeyVisitor == null) {
            OverwrittenKeyInspection.$$$reportNull$$$0(1);
        }
        return overwrittenKeyVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/OverwrittenKeyInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/OverwrittenKeyInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NavigateToDuplicateFix
    implements LocalQuickFix {
        private final SmartPsiElementPointer<PsiExpression> myPointer;

        public NavigateToDuplicateFix(PsiExpression arg) {
            this.myPointer = SmartPointerManager.getInstance((Project)arg.getProject()).createSmartPsiElementPointer((PsiElement)arg);
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"navigate.to.duplicate.fix", (Object[])new Object[0]);
            if (string == null) {
                NavigateToDuplicateFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            PsiExpression element;
            if (project2 == null) {
                NavigateToDuplicateFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                NavigateToDuplicateFix.$$$reportNull$$$0(2);
            }
            if ((element = (PsiExpression)this.myPointer.getElement()) == null) {
                return;
            }
            PsiFile file2 = element.getContainingFile();
            if (file2 == null) {
                return;
            }
            int offset = element.getTextRange().getStartOffset();
            new OpenFileDescriptor(project2, file2.getVirtualFile(), offset).navigate(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/OverwrittenKeyInspection$NavigateToDuplicateFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/OverwrittenKeyInspection$NavigateToDuplicateFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class OverwrittenKeyVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;

        public OverwrittenKeyVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        public void visitCodeBlock(PsiCodeBlock block) {
            PsiExpressionStatement statement2 = (PsiExpressionStatement)PsiTreeUtil.getChildOfType((PsiElement)block, PsiExpressionStatement.class);
            while (statement2 != null) {
                PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)statement2.getExpression(), PsiMethodCallExpression.class);
                if (SET_ADD.test(call)) {
                    statement2 = this.processCallSequence(call, statement2, SET_ADD, InspectionsBundle.message((String)"inspection.overwritten.key.set.message", (Object[])new Object[0]));
                } else if (MAP_PUT.test(call)) {
                    statement2 = this.processCallSequence(call, statement2, MAP_PUT, InspectionsBundle.message((String)"inspection.overwritten.key.map.message", (Object[])new Object[0]));
                }
                statement2 = (PsiExpressionStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement2, PsiExpressionStatement.class);
            }
        }

        public void visitMethodCallExpression(PsiMethodCallExpression call) {
            if (SET_OF.test(call)) {
                this.findDuplicates(call.getArgumentList().getExpressions(), InspectionsBundle.message((String)"inspection.overwritten.key.set.message", (Object[])new Object[0]));
            } else if (MAP_OF.test(call)) {
                Object[] args = call.getArgumentList().getExpressions();
                this.findDuplicates((PsiExpression[])IntStreamEx.range((int)0, (int)args.length, (int)2).elements(args).toArray(PsiExpression[]::new), InspectionsBundle.message((String)"inspection.overwritten.key.map.message", (Object[])new Object[0]));
            } else if (MAP_OF_ENTRIES.test(call)) {
                PsiExpression[] keys = (PsiExpression[])((StreamEx)StreamEx.of((Object[])call.getArgumentList().getExpressions()).map(PsiUtil::skipParenthesizedExprDown).select(PsiMethodCallExpression.class).filter((Predicate)MAP_ENTRY)).map(entryCall -> entryCall.getArgumentList().getExpressions()[0]).toArray(PsiExpression[]::new);
                this.findDuplicates(keys, InspectionsBundle.message((String)"inspection.overwritten.key.map.message", (Object[])new Object[0]));
            }
        }

        private void findDuplicates(PsiExpression[] expressions2, String message2) {
            Map groups = StreamEx.of((Object[])expressions2).mapToEntry(OverwrittenKeyVisitor::getKey, Function.identity()).nonNullKeys().grouping();
            this.registerDuplicates(message2, groups);
        }

        private PsiExpressionStatement processCallSequence(PsiMethodCallExpression call, PsiExpressionStatement statement2, CallMatcher myMatcher, String message2) {
            PsiExpression nextQualifier;
            PsiMethodCallExpression nextCall;
            PsiExpressionStatement nextStatement;
            PsiExpression arg = call.getArgumentList().getExpressions()[0];
            Object key2 = OverwrittenKeyVisitor.getKey(arg);
            if (key2 == null) {
                return statement2;
            }
            PsiExpression qualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)ExpressionUtils.getQualifierOrThis(call.getMethodExpression()));
            if (qualifier == null) {
                return statement2;
            }
            PsiVariable qualifierVar = qualifier instanceof PsiReferenceExpression ? (PsiVariable)ObjectUtils.tryCast((Object)((PsiReferenceExpression)qualifier).resolve(), PsiVariable.class) : null;
            HashMap<Object, List<PsiExpression>> map = new HashMap<Object, List<PsiExpression>>();
            map.computeIfAbsent(key2, k -> new ArrayList()).add(arg);
            while ((nextStatement = (PsiExpressionStatement)ObjectUtils.tryCast((Object)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement2, PsiStatement.class), PsiExpressionStatement.class)) != null && myMatcher.test(nextCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)nextStatement.getExpression(), PsiMethodCallExpression.class)) && (nextQualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)ExpressionUtils.getQualifierOrThis(nextCall.getMethodExpression()))) != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)qualifier, (PsiElement)nextQualifier) && (qualifierVar == null || !VariableAccessUtils.variableIsUsed(qualifierVar, (PsiElement)nextCall.getArgumentList()))) {
                PsiExpression nextArg = nextCall.getArgumentList().getExpressions()[0];
                Object nextKey = OverwrittenKeyVisitor.getKey(nextArg);
                if (nextKey != null) {
                    map.computeIfAbsent(nextKey, k -> new ArrayList()).add(nextArg);
                }
                statement2 = nextStatement;
            }
            this.registerDuplicates(message2, map);
            return statement2;
        }

        private void registerDuplicates(String message2, Map<Object, List<PsiExpression>> map) {
            for (List<PsiExpression> args : map.values()) {
                if (args.size() < 2) continue;
                for (int i = 0; i < args.size(); ++i) {
                    PsiExpression arg = args.get(i);
                    NavigateToDuplicateFix fix = null;
                    if (this.myHolder.isOnTheFly()) {
                        PsiExpression nextArg = args.get((i + 1) % args.size());
                        fix = new NavigateToDuplicateFix(nextArg);
                    }
                    this.myHolder.registerProblem((PsiElement)arg, message2, new LocalQuickFix[]{fix});
                }
            }
        }

        private static Object getKey(PsiExpression key2) {
            PsiField field;
            Object constant = ExpressionUtils.computeConstantExpression(key2);
            if (constant != null) {
                return constant;
            }
            if (key2 instanceof PsiReferenceExpression && ((field = (PsiField)ObjectUtils.tryCast((Object)((PsiReferenceExpression)key2).resolve(), PsiField.class)) instanceof PsiEnumConstant || field != null && field.hasModifierProperty("final") && field.hasModifierProperty("static"))) {
                return field;
            }
            return null;
        }
    }
}

