/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.NullnessUtil;
import com.intellij.codeInspection.util.LambdaGenerationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RequireNonNullInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final EquivalenceChecker ourEquivalence = EquivalenceChecker.getCanonicalPsiEquivalence();

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        PsiFile file2;
        if (holder == null) {
            RequireNonNullInspection.$$$reportNull$$$0(0);
        }
        if (!PsiUtil.isLanguageLevel9OrHigher((PsiElement)(file2 = holder.getFile()))) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                RequireNonNullInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        JavaRecursiveElementVisitor javaRecursiveElementVisitor = new JavaRecursiveElementVisitor(){

            public void visitIfStatement(PsiIfStatement ifStatement) {
                NotNullContext context = NotNullContext.from(ifStatement);
                if (context == null) {
                    return;
                }
                String method = RequireNonNullInspection.getMethod(context.getExpression());
                holder.registerProblem((PsiElement)ifStatement, InspectionsBundle.message((String)"inspection.require.non.null.message", (Object[])new Object[]{method}), new LocalQuickFix[]{new ReplaceWithRequireNonNullFix(method)});
            }

            public void visitConditionalExpression(PsiConditionalExpression ternary) {
                TernaryNotNullContext context = TernaryNotNullContext.from(ternary);
                if (context == null) {
                    return;
                }
                String method = RequireNonNullInspection.getMethod(context.getNonNullExpr());
                holder.registerProblem((PsiElement)ternary, InspectionsBundle.message((String)"inspection.require.non.null.message", (Object[])new Object[]{method}), new LocalQuickFix[]{new ReplaceWithRequireNonNullFix(method)});
            }
        };
        if (javaRecursiveElementVisitor == null) {
            RequireNonNullInspection.$$$reportNull$$$0(2);
        }
        return javaRecursiveElementVisitor;
    }

    @NotNull
    private static PsiExpression createRequireExpression(@NotNull CommentTracker tracker, @NotNull PsiExpression expression2, @NotNull Project project2, @NotNull PsiVariable variable, @NotNull PsiElement context) {
        if (tracker == null) {
            RequireNonNullInspection.$$$reportNull$$$0(3);
        }
        if (expression2 == null) {
            RequireNonNullInspection.$$$reportNull$$$0(4);
        }
        if (project2 == null) {
            RequireNonNullInspection.$$$reportNull$$$0(5);
        }
        if (variable == null) {
            RequireNonNullInspection.$$$reportNull$$$0(6);
        }
        if (context == null) {
            RequireNonNullInspection.$$$reportNull$$$0(7);
        }
        boolean isSimple = ExpressionUtils.isSimpleExpression(expression2);
        String expr = tracker.text((PsiElement)expression2);
        if (!isSimple) {
            expr = "()->" + expr;
        }
        String varName = variable.getName();
        String requireCallText = "java.util.Objects." + RequireNonNullInspection.getMethod(expression2) + "(" + varName + "," + expr + ")";
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
        PsiExpression psiExpression = factory.createExpressionFromText(requireCallText, context);
        if (psiExpression == null) {
            RequireNonNullInspection.$$$reportNull$$$0(8);
        }
        return psiExpression;
    }

    static String getMethod(PsiExpression expression2) {
        return ExpressionUtils.isSimpleExpression(expression2) ? "requireNonNullElse" : "requireNonNullElseGet";
    }

    @Nullable
    private static PsiVariable extractVariable(@NotNull PsiBinaryExpression binOp) {
        PsiExpression value2;
        PsiReferenceExpression referenceExpression;
        if (binOp == null) {
            RequireNonNullInspection.$$$reportNull$$$0(9);
        }
        if ((referenceExpression = (PsiReferenceExpression)ObjectUtils.tryCast((Object)(value2 = ExpressionUtils.getValueComparedWithNull(binOp)), PsiReferenceExpression.class)) == null) {
            return null;
        }
        PsiVariable variable = (PsiVariable)ObjectUtils.tryCast((Object)referenceExpression.resolve(), PsiVariable.class);
        if (variable == null) {
            return null;
        }
        return variable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/RequireNonNullInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracker";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binOp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/RequireNonNullInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createRequireExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createRequireExpression";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "extractVariable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TopmostQualifierDiff {
        @Nullable
        private final PsiExpression myLeft;
        @Nullable
        private final PsiExpression myRight;

        private TopmostQualifierDiff(@Nullable PsiExpression left, @Nullable PsiExpression right) {
            this.myLeft = left;
            this.myRight = right;
        }

        @Nullable
        public PsiExpression getRight() {
            return this.myRight;
        }

        @Nullable
        public PsiExpression getLeft() {
            return this.myLeft;
        }

        @Nullable
        static TopmostQualifierDiff from(@Nullable PsiExpression left, @Nullable PsiExpression right) {
            PsiExpression rightQualifier;
            PsiExpression leftQualifier;
            PsiMethodCallExpression leftCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)left, PsiMethodCallExpression.class);
            PsiMethodCallExpression rightCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)right, PsiMethodCallExpression.class);
            if (leftCall == null || rightCall == null) {
                return null;
            }
            do {
                PsiExpression[] rightExpressions;
                PsiReferenceExpression leftMethodExpression = leftCall.getMethodExpression();
                PsiReferenceExpression rightMethodExpression = rightCall.getMethodExpression();
                if (ObjectUtils.tryCast((Object)leftMethodExpression.resolve(), PsiMethod.class) != ObjectUtils.tryCast((Object)rightMethodExpression.resolve(), PsiMethod.class)) {
                    return null;
                }
                PsiExpression[] leftExpressions = leftCall.getArgumentList().getExpressions();
                int length = leftExpressions.length;
                if (length != (rightExpressions = rightCall.getArgumentList().getExpressions()).length) {
                    return null;
                }
                for (int i = 0; i < length; ++i) {
                    if (ourEquivalence.expressionsAreEquivalent(leftExpressions[i], rightExpressions[i])) continue;
                    return null;
                }
                leftQualifier = leftMethodExpression.getQualifierExpression();
                leftCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)leftQualifier, PsiMethodCallExpression.class);
                rightQualifier = rightMethodExpression.getQualifierExpression();
                rightCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)rightQualifier, PsiMethodCallExpression.class);
            } while (leftCall != null && rightCall != null);
            return new TopmostQualifierDiff(leftQualifier, rightQualifier);
        }
    }

    private static class TernaryNotNullContext {
        @NotNull
        private final PsiConditionalExpression myTernary;
        @NotNull
        private final PsiExpression myNonNullExpr;
        @NotNull
        private final PsiVariable myVariable;

        private TernaryNotNullContext(@NotNull PsiConditionalExpression ternary, @NotNull PsiExpression expr, @NotNull PsiVariable variable) {
            if (ternary == null) {
                TernaryNotNullContext.$$$reportNull$$$0(0);
            }
            if (expr == null) {
                TernaryNotNullContext.$$$reportNull$$$0(1);
            }
            if (variable == null) {
                TernaryNotNullContext.$$$reportNull$$$0(2);
            }
            this.myTernary = ternary;
            this.myNonNullExpr = expr;
            this.myVariable = variable;
        }

        @NotNull
        public PsiExpression getNonNullExpr() {
            PsiExpression psiExpression = this.myNonNullExpr;
            if (psiExpression == null) {
                TernaryNotNullContext.$$$reportNull$$$0(3);
            }
            return psiExpression;
        }

        @NotNull
        public PsiConditionalExpression getTernary() {
            PsiConditionalExpression psiConditionalExpression = this.myTernary;
            if (psiConditionalExpression == null) {
                TernaryNotNullContext.$$$reportNull$$$0(4);
            }
            return psiConditionalExpression;
        }

        @NotNull
        public PsiVariable getVariable() {
            PsiVariable psiVariable = this.myVariable;
            if (psiVariable == null) {
                TernaryNotNullContext.$$$reportNull$$$0(5);
            }
            return psiVariable;
        }

        @Nullable
        static TernaryNotNullContext from(@NotNull PsiConditionalExpression ternary) {
            PsiExpression nullBranch;
            PsiExpression nonNullBranch;
            PsiBinaryExpression binOp;
            if (ternary == null) {
                TernaryNotNullContext.$$$reportNull$$$0(6);
            }
            if ((binOp = (PsiBinaryExpression)ObjectUtils.tryCast((Object)ternary.getCondition(), PsiBinaryExpression.class)) == null) {
                return null;
            }
            PsiVariable variable = RequireNonNullInspection.extractVariable(binOp);
            if (variable == null) {
                return null;
            }
            boolean negated = binOp.getOperationTokenType() == JavaTokenType.NE;
            PsiExpression psiExpression = nonNullBranch = negated ? ternary.getElseExpression() : ternary.getThenExpression();
            if (ClassUtils.isPrimitive(variable.getType())) {
                return null;
            }
            PsiExpression psiExpression2 = nullBranch = negated ? ternary.getThenExpression() : ternary.getElseExpression();
            if (!ExpressionUtils.isReferenceTo(nullBranch, variable)) {
                return null;
            }
            if (NullnessUtil.getExpressionNullness(nonNullBranch) != Nullness.NOT_NULL) {
                return null;
            }
            if (!LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)nonNullBranch)) {
                return null;
            }
            return new TernaryNotNullContext(ternary, nonNullBranch, variable);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ternary";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expr";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/RequireNonNullInspection$TernaryNotNullContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/RequireNonNullInspection$TernaryNotNullContext";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNonNullExpr";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTernary";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "from";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class NotNullContext {
        @NotNull
        private final PsiExpression myExpression;
        @NotNull
        private final PsiExpression myReference;
        @NotNull
        private final PsiStatement myNullBranchStmt;
        @NotNull
        private final PsiVariable myVariable;
        @NotNull
        private final PsiIfStatement myIfStatement;
        @Nullable
        private final PsiStatement myNextToDelete;

        private NotNullContext(@NotNull PsiExpression expression2, @NotNull PsiExpression reference, @NotNull PsiStatement nullBranchStmt, @NotNull PsiVariable variable, @NotNull PsiIfStatement statement2, @Nullable PsiStatement nextToDelete) {
            if (expression2 == null) {
                NotNullContext.$$$reportNull$$$0(0);
            }
            if (reference == null) {
                NotNullContext.$$$reportNull$$$0(1);
            }
            if (nullBranchStmt == null) {
                NotNullContext.$$$reportNull$$$0(2);
            }
            if (variable == null) {
                NotNullContext.$$$reportNull$$$0(3);
            }
            if (statement2 == null) {
                NotNullContext.$$$reportNull$$$0(4);
            }
            this.myExpression = expression2;
            this.myReference = reference;
            this.myNullBranchStmt = nullBranchStmt;
            this.myVariable = variable;
            this.myIfStatement = statement2;
            this.myNextToDelete = nextToDelete;
        }

        @NotNull
        public PsiExpression getExpression() {
            PsiExpression psiExpression = this.myExpression;
            if (psiExpression == null) {
                NotNullContext.$$$reportNull$$$0(5);
            }
            return psiExpression;
        }

        @NotNull
        public PsiVariable getVariable() {
            PsiVariable psiVariable = this.myVariable;
            if (psiVariable == null) {
                NotNullContext.$$$reportNull$$$0(6);
            }
            return psiVariable;
        }

        @NotNull
        public PsiIfStatement getIfStatement() {
            PsiIfStatement psiIfStatement = this.myIfStatement;
            if (psiIfStatement == null) {
                NotNullContext.$$$reportNull$$$0(7);
            }
            return psiIfStatement;
        }

        @Nullable
        public PsiStatement getNextToDelete() {
            return this.myNextToDelete;
        }

        @NotNull
        public PsiExpression getReference() {
            PsiExpression psiExpression = this.myReference;
            if (psiExpression == null) {
                NotNullContext.$$$reportNull$$$0(8);
            }
            return psiExpression;
        }

        @NotNull
        public PsiStatement getNullBranchStmt() {
            PsiStatement psiStatement = this.myNullBranchStmt;
            if (psiStatement == null) {
                NotNullContext.$$$reportNull$$$0(9);
            }
            return psiStatement;
        }

        @Nullable
        static NotNullContext from(@NotNull PsiIfStatement ifStatement) {
            PsiExpression condition2;
            if (ifStatement == null) {
                NotNullContext.$$$reportNull$$$0(10);
            }
            if ((condition2 = ifStatement.getCondition()) == null) {
                return null;
            }
            PsiBinaryExpression binOp = (PsiBinaryExpression)ObjectUtils.tryCast((Object)condition2, PsiBinaryExpression.class);
            if (binOp == null) {
                return null;
            }
            PsiVariable variable = RequireNonNullInspection.extractVariable(binOp);
            if (variable == null) {
                return null;
            }
            if (ClassUtils.isPrimitive(variable.getType())) {
                return null;
            }
            boolean inverted = binOp.getOperationTokenType() == JavaTokenType.NE;
            PsiStatement elseBranch = ControlFlowUtils.stripBraces(ifStatement.getElseBranch());
            PsiStatement thenBranch = ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
            if (elseBranch != null) {
                PsiStatement nullBranch = inverted ? thenBranch : elseBranch;
                PsiStatement nonNullBranch = inverted ? elseBranch : thenBranch;
                return NotNullContext.extractContext(ifStatement, variable, nullBranch, nonNullBranch, null);
            }
            PsiReturnStatement nextReturn = (PsiReturnStatement)ObjectUtils.tryCast((Object)PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)ifStatement), PsiReturnStatement.class);
            if (nextReturn == null) {
                return null;
            }
            if (thenBranch instanceof PsiReturnStatement) {
                PsiStatement nullBranch = inverted ? thenBranch : nextReturn;
                PsiReturnStatement nonNullBranch = inverted ? nextReturn : thenBranch;
                return NotNullContext.extractContext(ifStatement, variable, nullBranch, (PsiStatement)nonNullBranch, nextReturn);
            }
            return null;
        }

        @Contract(value="_, _, null, _, _ -> null")
        private static NotNullContext extractContext(@NotNull PsiIfStatement ifStatement, @NotNull PsiVariable variable, @Nullable PsiStatement nullBranch, @Nullable PsiStatement nonNullBranch, @Nullable PsiReturnStatement toDelete) {
            if (ifStatement == null) {
                NotNullContext.$$$reportNull$$$0(11);
            }
            if (variable == null) {
                NotNullContext.$$$reportNull$$$0(12);
            }
            if (nullBranch == null) {
                return null;
            }
            EquivalenceChecker.Match match = ourEquivalence.statementsMatch(nullBranch, nonNullBranch);
            PsiExpression nullDiff = (PsiExpression)ObjectUtils.tryCast((Object)match.getLeftDiff(), PsiExpression.class);
            PsiExpression nonNullDiff = (PsiExpression)ObjectUtils.tryCast((Object)match.getRightDiff(), PsiExpression.class);
            if (!ExpressionUtils.isReferenceTo(nullDiff, variable)) {
                TopmostQualifierDiff qualifierDiff = TopmostQualifierDiff.from(nullDiff, nonNullDiff);
                if (qualifierDiff == null) {
                    return null;
                }
                nullDiff = qualifierDiff.getLeft();
                nonNullDiff = qualifierDiff.getRight();
                if (!ExpressionUtils.isReferenceTo(nullDiff, variable)) {
                    return null;
                }
            }
            if (NullnessUtil.getExpressionNullness(nonNullDiff) != Nullness.NOT_NULL) {
                return null;
            }
            if (!LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)nonNullDiff)) {
                return null;
            }
            return new NotNullContext(nonNullDiff, nullDiff, nullBranch, variable, ifStatement, (PsiStatement)toDelete);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nullBranchStmt";
                    break;
                }
                case 3: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/RequireNonNullInspection$NotNullContext";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ifStatement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/RequireNonNullInspection$NotNullContext";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExpression";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariable";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIfStatement";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReference";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNullBranchStmt";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "from";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "extractContext";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ReplaceWithRequireNonNullFix
    implements LocalQuickFix {
        @NotNull
        private final String myMethod;

        private ReplaceWithRequireNonNullFix(@NotNull String method) {
            if (method == null) {
                ReplaceWithRequireNonNullFix.$$$reportNull$$$0(0);
            }
            this.myMethod = method;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = "Replace condition with Objects." + this.myMethod;
            if (string == null) {
                ReplaceWithRequireNonNullFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Replace null checked condition with Objects static method" == null) {
                ReplaceWithRequireNonNullFix.$$$reportNull$$$0(2);
            }
            return "Replace null checked condition with Objects static method";
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            PsiElement result2;
            PsiElement element;
            if (project2 == null) {
                ReplaceWithRequireNonNullFix.$$$reportNull$$$0(3);
            }
            if (descriptor2 == null) {
                ReplaceWithRequireNonNullFix.$$$reportNull$$$0(4);
            }
            if ((element = descriptor2.getStartElement()) instanceof PsiIfStatement) {
                NotNullContext context = NotNullContext.from((PsiIfStatement)element);
                if (context == null) {
                    return;
                }
                CommentTracker tracker = new CommentTracker();
                PsiExpression expression2 = context.getExpression();
                PsiExpression requireCall = RequireNonNullInspection.createRequireExpression(tracker, expression2, project2, context.getVariable(), (PsiElement)context.getReference());
                context.getReference().replace((PsiElement)requireCall);
                result2 = tracker.replaceAndRestoreComments((PsiElement)context.getIfStatement(), (PsiElement)context.getNullBranchStmt());
                if (context.getNextToDelete() != null) {
                    context.getNextToDelete().delete();
                }
            } else if (element instanceof PsiConditionalExpression) {
                TernaryNotNullContext context = TernaryNotNullContext.from((PsiConditionalExpression)element);
                if (context == null) {
                    return;
                }
                CommentTracker tracker = new CommentTracker();
                PsiExpression requireCall = RequireNonNullInspection.createRequireExpression(tracker, context.getNonNullExpr(), project2, context.getVariable(), (PsiElement)context.getNonNullExpr());
                result2 = tracker.replace((PsiElement)context.getTernary(), (PsiElement)requireCall);
            } else {
                return;
            }
            LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences(result2);
            CodeStyleManager.getInstance((Project)project2).reformat(JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences(result2));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/RequireNonNullInspection$ReplaceWithRequireNonNullFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/RequireNonNullInspection$ReplaceWithRequireNonNullFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

