/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.text.Matcher;
import com.intellij.util.text.MatcherHolder;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class InspectionListCellRenderer
extends DefaultListCellRenderer {
    private final SimpleTextAttributes mySelected = new SimpleTextAttributes(UIUtil.getListSelectionBackground(), UIUtil.getListSelectionForeground(), (Color)JBColor.RED, 0);
    private final SimpleTextAttributes myPlain = new SimpleTextAttributes(UIUtil.getListBackground(), UIUtil.getListForeground(), (Color)JBColor.RED, 0);
    private final SimpleTextAttributes myHighlighted = new SimpleTextAttributes(UIUtil.getListBackground(), UIUtil.getListForeground(), null, 64);

    @Override
    public Component getListCellRendererComponent(JList list2, Object value2, int index, boolean sel, boolean focus) {
        SimpleColoredComponent group;
        InspectionToolWrapper toolWrapper;
        BorderLayout layout = new BorderLayout();
        layout.setHgap(5);
        JPanel panel2 = new JPanel(layout);
        panel2.setOpaque(true);
        Color bg = sel ? UIUtil.getListSelectionBackground() : UIUtil.getListBackground();
        Color fg = sel ? UIUtil.getListSelectionForeground() : UIUtil.getListForeground();
        panel2.setBackground(bg);
        panel2.setForeground(fg);
        if (value2 instanceof InspectionToolWrapper) {
            boolean matchHighlighting;
            toolWrapper = (InspectionToolWrapper)value2;
            String inspectionName = "  " + toolWrapper.getDisplayName();
            String groupName = StringUtil.join((String[])toolWrapper.getGroupPath(), (String)" | ");
            String matchingText = inspectionName + "|" + groupName;
            Matcher matcher = MatcherHolder.getAssociatedMatcher(list2);
            FList fragments = matcher == null ? null : ((MinusculeMatcher)matcher).matchingFragments(matchingText);
            ArrayList<TextRange> adjustedFragments = new ArrayList<TextRange>();
            if (fragments != null) {
                adjustedFragments.addAll((Collection<TextRange>)fragments);
            }
            int splitPoint = InspectionListCellRenderer.adjustRanges(adjustedFragments, inspectionName.length() + 1);
            SimpleColoredComponent c = new SimpleColoredComponent();
            boolean bl = matchHighlighting = Registry.is((String)"ide.highlight.match.in.selected.only") && !sel;
            if (matchHighlighting) {
                c.append(inspectionName, this.myPlain);
            } else {
                List ranges = adjustedFragments.subList(0, splitPoint);
                SpeedSearchUtil.appendColoredFragments((SimpleColoredComponent)c, (String)inspectionName, ranges, (SimpleTextAttributes)(sel ? this.mySelected : this.myPlain), (SimpleTextAttributes)this.myHighlighted);
            }
            panel2.add((Component)c, "West");
            group = new SimpleColoredComponent();
            if (matchHighlighting) {
                group.append(groupName, SimpleTextAttributes.GRAYED_ATTRIBUTES);
            } else {
                SimpleTextAttributes attributes = sel ? this.mySelected : SimpleTextAttributes.GRAYED_ATTRIBUTES;
                List ranges = adjustedFragments.subList(splitPoint, adjustedFragments.size());
                SpeedSearchUtil.appendColoredFragments((SimpleColoredComponent)group, (String)groupName, ranges, (SimpleTextAttributes)attributes, (SimpleTextAttributes)this.myHighlighted);
            }
        } else {
            return super.getListCellRendererComponent((JList<?>)list2, value2, index, sel, focus);
        }
        JPanel right = new JPanel(new BorderLayout());
        right.setBackground(bg);
        right.setForeground(fg);
        right.add((Component)group, "Center");
        JLabel icon = new JLabel(InspectionListCellRenderer.getIcon(toolWrapper));
        icon.setBackground(bg);
        icon.setForeground(fg);
        right.add((Component)icon, "East");
        panel2.add((Component)right, "East");
        return panel2;
    }

    private static int adjustRanges(List<TextRange> ranges, int offset) {
        int result2 = 0;
        for (int i = 0; i < ranges.size(); ++i) {
            TextRange range = ranges.get(i);
            int startOffset = range.getStartOffset();
            if (startOffset < offset) {
                result2 = i + 1;
                continue;
            }
            ranges.set(i, new TextRange(startOffset - offset, range.getEndOffset() - offset));
        }
        return result2;
    }

    @NotNull
    private static Icon getIcon(@NotNull InspectionToolWrapper tool) {
        LanguageFileType fileType;
        if (tool == null) {
            InspectionListCellRenderer.$$$reportNull$$$0(0);
        }
        Icon icon = null;
        Language language = Language.findLanguageByID((String)tool.getLanguage());
        if (language != null && (fileType = language.getAssociatedFileType()) != null) {
            icon = fileType.getIcon();
        }
        if (icon == null) {
            icon = UnknownFileType.INSTANCE.getIcon();
        }
        assert (icon != null);
        Icon icon2 = icon;
        if (icon2 == null) {
            InspectionListCellRenderer.$$$reportNull$$$0(1);
        }
        return icon2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/actions/InspectionListCellRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/actions/InspectionListCellRenderer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

