/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.AbstractValues;
import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import com.intellij.codeInspection.bytecodeAnalysis.LambdaIndy;
import com.intellij.codeInspection.bytecodeAnalysis.Method;
import com.intellij.codeInspection.bytecodeAnalysis.PResults;
import java.util.List;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.TypeInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicInterpreter;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;

abstract class NullityInterpreter
extends BasicInterpreter {
    boolean top;
    final boolean nullableAnalysis;
    final boolean nullable;
    private PResults.PResult subResult = PResults.Identity;
    protected boolean taken;

    NullityInterpreter(boolean nullableAnalysis, boolean nullable) {
        this.nullableAnalysis = nullableAnalysis;
        this.nullable = nullable;
    }

    abstract PResults.PResult combine(PResults.PResult var1, PResults.PResult var2) throws AnalyzerException;

    public PResults.PResult getSubResult() {
        return this.subResult;
    }

    void reset(boolean taken) {
        this.subResult = PResults.Identity;
        this.top = false;
        this.taken = taken;
    }

    public BasicValue unaryOperation(AbstractInsnNode insn, BasicValue value2) throws AnalyzerException {
        switch (insn.getOpcode()) {
            case 180: 
            case 190: 
            case 194: {
                if (!(value2 instanceof AbstractValues.ParamValue)) break;
                this.subResult = PResults.NPE;
                break;
            }
            case 192: {
                if (!(value2 instanceof AbstractValues.ParamValue)) break;
                return new AbstractValues.ParamValue(Type.getObjectType((String)((TypeInsnNode)insn).desc));
            }
            case 193: {
                if (!(value2 instanceof AbstractValues.ParamValue)) break;
                return AbstractValues.InstanceOfCheckValue;
            }
        }
        return super.unaryOperation(insn, value2);
    }

    public BasicValue binaryOperation(AbstractInsnNode insn, BasicValue value1, BasicValue value2) throws AnalyzerException {
        switch (insn.getOpcode()) {
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                if (!(value1 instanceof AbstractValues.ParamValue)) break;
                this.subResult = PResults.NPE;
                break;
            }
            case 181: {
                if (value1 instanceof AbstractValues.ParamValue) {
                    this.subResult = PResults.NPE;
                }
                if (!this.nullableAnalysis || !(value2 instanceof AbstractValues.ParamValue)) break;
                this.subResult = PResults.NPE;
                break;
            }
        }
        return super.binaryOperation(insn, value1, value2);
    }

    public BasicValue ternaryOperation(AbstractInsnNode insn, BasicValue value1, BasicValue value2, BasicValue value3) {
        switch (insn.getOpcode()) {
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 84: 
            case 85: 
            case 86: {
                if (!(value1 instanceof AbstractValues.ParamValue)) break;
                this.subResult = PResults.NPE;
                break;
            }
            case 83: {
                if (value1 instanceof AbstractValues.ParamValue) {
                    this.subResult = PResults.NPE;
                }
                if (!this.nullableAnalysis || !(value3 instanceof AbstractValues.ParamValue)) break;
                this.subResult = PResults.NPE;
                break;
            }
        }
        return null;
    }

    public BasicValue naryOperation(AbstractInsnNode insn, List<? extends BasicValue> values) throws AnalyzerException {
        int opcode = insn.getOpcode();
        switch (opcode) {
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                MethodInsnNode methodNode = (MethodInsnNode)insn;
                this.methodCall(opcode, new Method(methodNode.owner, methodNode.name, methodNode.desc), values);
                break;
            }
            case 186: {
                int targetOpcode;
                LambdaIndy lambda2 = LambdaIndy.from((InvokeDynamicInsnNode)insn);
                if (lambda2 == null || (targetOpcode = lambda2.getAssociatedOpcode()) == -1) break;
                this.methodCall(targetOpcode, lambda2.getMethod(), lambda2.getLambdaMethodArguments(values, arg_0 -> ((NullityInterpreter)this).newValue(arg_0)));
            }
        }
        return super.naryOperation(insn, values);
    }

    /*
     * WARNING - void declaration
     */
    private void methodCall(int opcode, Method method, List<? extends BasicValue> values) throws AnalyzerException {
        block4: {
            void var5_8;
            block5: {
                if (opcode != 184 && values.remove(0) instanceof AbstractValues.ParamValue) {
                    this.subResult = PResults.NPE;
                }
                if (opcode != 185) break block5;
                if (!this.nullableAnalysis) break block4;
                for (BasicValue basicValue : values) {
                    if (!(basicValue instanceof AbstractValues.ParamValue)) continue;
                    this.top = true;
                    break block4;
                }
                break block4;
            }
            boolean stable = opcode == 184 || opcode == 183;
            boolean bl = false;
            while (var5_8 < values.size()) {
                BasicValue value3 = values.get((int)var5_8);
                if (value3 instanceof AbstractValues.ParamValue || AbstractValues.NullValue == value3 && this.nullable && "<init>".equals(method.methodName)) {
                    this.subResult = this.combine(this.subResult, new PResults.ConditionalNPE(new EKey(method, new Direction.In((int)var5_8, this.nullable), stable)));
                }
                ++var5_8;
            }
        }
    }
}

