/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaFactMap;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.instructions.PushInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class CommonDataflow {
    @Contract(value="null -> null")
    @Nullable
    private static DataflowResult runDFA(@Nullable PsiElement block) {
        if (block == null) {
            return null;
        }
        DataFlowRunner runner = new DataFlowRunner(false, !DfaUtil.isInsideConstructorOrInitializer(block));
        final DfaConstValue fail = runner.getFactory().getConstFactory().getContractFail();
        final DataflowResult dfr = new DataflowResult();
        StandardInstructionVisitor visitor = new StandardInstructionVisitor(){

            @Override
            public DfaInstructionState[] visitPush(PushInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
                DfaInstructionState[] states = super.visitPush(instruction, runner, memState);
                PsiExpression place = instruction.getPlace();
                if (place != null) {
                    for (DfaInstructionState state : states) {
                        dfr.add(place, (DfaMemoryStateImpl)state.getMemoryState());
                    }
                }
                return states;
            }

            @Override
            public DfaInstructionState[] visitMethodCall(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
                DfaInstructionState[] states = super.visitMethodCall(instruction, runner, memState);
                PsiExpression context = (PsiExpression)ObjectUtils.tryCast((Object)instruction.getContext(), PsiExpression.class);
                if (context != null) {
                    for (DfaInstructionState state : states) {
                        DfaValue value2 = state.getMemoryState().peek();
                        if (value2 == fail) continue;
                        dfr.add(context, (DfaMemoryStateImpl)state.getMemoryState());
                    }
                }
                return states;
            }
        };
        RunnerResult result2 = runner.analyzeMethod(block, visitor);
        return result2 == RunnerResult.OK ? dfr : null;
    }

    private static DataflowResult getDataflowResult(PsiElement context) {
        PsiClass body2;
        PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)context, PsiMember.class);
        if (!(member instanceof PsiMethod || member instanceof PsiField || member instanceof PsiClassInitializer)) {
            return null;
        }
        Object object = body2 = member instanceof PsiMethod ? ((PsiMethod)member).getBody() : member.getContainingClass();
        if (body2 == null) {
            return null;
        }
        return (DataflowResult)CachedValuesManager.getCachedValue((PsiElement)body2, () -> CommonDataflow.lambda$getDataflowResult$0((PsiElement)body2));
    }

    public static <T> T getExpressionFact(PsiExpression expression2, DfaFactType<T> type2) {
        DataflowResult result2 = CommonDataflow.getDataflowResult((PsiElement)expression2);
        if (result2 == null) {
            return null;
        }
        DfaFactMap map = (DfaFactMap)result2.myFacts.get(expression2);
        return map == null ? null : (T)map.get(type2);
    }

    private static /* synthetic */ CachedValueProvider.Result lambda$getDataflowResult$0(PsiElement body2) {
        DataflowResult result2 = CommonDataflow.runDFA(body2);
        return CachedValueProvider.Result.create((Object)result2, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
    }

    static class DataflowResult {
        private final Map<PsiExpression, DfaFactMap> myFacts = new HashMap<PsiExpression, DfaFactMap>();

        DataflowResult() {
        }

        void add(PsiExpression expression2, DfaMemoryStateImpl memState) {
            DfaFactMap existing = this.myFacts.get(expression2);
            if (existing != DfaFactMap.EMPTY) {
                DfaValue value2 = memState.peek();
                DfaFactMap newMap = memState.getFactMap(value2);
                this.myFacts.put(expression2, existing == null ? newMap : existing.union(newMap));
            }
        }
    }
}

