/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.impl.quickfix.SimplifyBooleanExpressionFix;
import com.intellij.codeInsight.intention.impl.AddNotNullAnnotationFix;
import com.intellij.codeInsight.intention.impl.AddNullableAnnotationFix;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.AnnotateMethodFix;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SetInspectionOptionFix;
import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.CustomMethodHandlers;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaOptionalSupport;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.NullParameterConstraintChecker;
import com.intellij.codeInspection.dataFlow.NullabilityProblem;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.StandardDataFlowRunner;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.fix.RedundantInstanceofFix;
import com.intellij.codeInspection.dataFlow.fix.ReplaceWithConstantValueFix;
import com.intellij.codeInspection.dataFlow.fix.ReplaceWithObjectsEqualsFix;
import com.intellij.codeInspection.dataFlow.fix.SimplifyToAssignmentFix;
import com.intellij.codeInspection.dataFlow.instructions.BinopInstruction;
import com.intellij.codeInspection.dataFlow.instructions.BranchingInstruction;
import com.intellij.codeInspection.dataFlow.instructions.InstanceofInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.instructions.PushInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ReturnInstruction;
import com.intellij.codeInspection.dataFlow.instructions.TypeCastInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.nullable.NullableStuffInspectionBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataFlowInspectionBase
extends AbstractBaseJavaLocalInspectionTool {
    static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.dataFlow.DataFlowInspection");
    @NonNls
    private static final String SHORT_NAME = "ConstantConditions";
    public boolean SUGGEST_NULLABLE_ANNOTATIONS;
    public boolean DONT_REPORT_TRUE_ASSERT_STATEMENTS;
    public boolean TREAT_UNKNOWN_MEMBERS_AS_NULLABLE;
    public boolean IGNORE_ASSERT_STATEMENTS;
    public boolean REPORT_CONSTANT_REFERENCE_VALUES = true;
    public boolean REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER = true;
    public boolean REPORT_NULLABLE_METHODS_RETURNING_NOT_NULL = true;
    public boolean REPORT_UNCHECKED_OPTIONALS = true;

    public JComponent createOptionsPanel() {
        throw new RuntimeException("no UI in headless mode");
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(0);
        }
        node.addContent(new Element("option").setAttribute("name", "SUGGEST_NULLABLE_ANNOTATIONS").setAttribute("value", String.valueOf(this.SUGGEST_NULLABLE_ANNOTATIONS)));
        node.addContent(new Element("option").setAttribute("name", "DONT_REPORT_TRUE_ASSERT_STATEMENTS").setAttribute("value", String.valueOf(this.DONT_REPORT_TRUE_ASSERT_STATEMENTS)));
        if (this.IGNORE_ASSERT_STATEMENTS) {
            node.addContent(new Element("option").setAttribute("name", "IGNORE_ASSERT_STATEMENTS").setAttribute("value", "true"));
        }
        if (!this.REPORT_CONSTANT_REFERENCE_VALUES) {
            node.addContent(new Element("option").setAttribute("name", "REPORT_CONSTANT_REFERENCE_VALUES").setAttribute("value", "false"));
        }
        if (this.TREAT_UNKNOWN_MEMBERS_AS_NULLABLE) {
            node.addContent(new Element("option").setAttribute("name", "TREAT_UNKNOWN_MEMBERS_AS_NULLABLE").setAttribute("value", "true"));
        }
        if (!this.REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER) {
            node.addContent(new Element("option").setAttribute("name", "REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER").setAttribute("value", "false"));
        }
        if (!this.REPORT_NULLABLE_METHODS_RETURNING_NOT_NULL) {
            node.addContent(new Element("option").setAttribute("name", "REPORT_NULLABLE_METHODS_RETURNING_NOT_NULL").setAttribute("value", "false"));
        }
        if (!this.REPORT_UNCHECKED_OPTIONALS) {
            node.addContent(new Element("option").setAttribute("name", "REPORT_UNCHECKED_OPTIONALS").setAttribute("value", "false"));
        }
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(1);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitClass(PsiClass aClass) {
                if (aClass instanceof PsiTypeParameter) {
                    return;
                }
                DataFlowInspectionBase.this.analyzeCodeBlock((PsiElement)aClass, holder);
            }

            public void visitMethod(PsiMethod method) {
                DataFlowInspectionBase.this.analyzeCodeBlock((PsiElement)method.getBody(), holder);
                DataFlowInspectionBase.this.analyzeNullLiteralMethodArguments(method, holder);
            }

            public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
                PsiType returnType;
                PsiType methodReturnType;
                super.visitMethodReferenceExpression(expression2);
                PsiElement resolve2 = expression2.resolve();
                if (resolve2 instanceof PsiMethod && TypeConversionUtil.isPrimitiveWrapper((PsiType)(methodReturnType = ((PsiMethod)resolve2).getReturnType())) && NullableNotNullManager.isNullable((PsiModifierListOwner)((PsiMethod)resolve2)) && TypeConversionUtil.isPrimitiveAndNotNull((PsiType)(returnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)expression2)))) {
                    holder.registerProblem((PsiElement)expression2, InspectionsBundle.message((String)"dataflow.message.unboxing.method.reference", (Object[])new Object[0]), new LocalQuickFix[0]);
                }
            }

            public void visitIfStatement(PsiIfStatement statement2) {
                PsiExpression condition2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)statement2.getCondition());
                if (BranchingInstruction.isBoolConst((PsiElement)condition2)) {
                    LocalQuickFix fix = DataFlowInspectionBase.createSimplifyBooleanExpressionFix((PsiElement)condition2, condition2.textMatches((CharSequence)"true"));
                    holder.registerProblem((PsiElement)condition2, "Condition is always " + condition2.getText(), new LocalQuickFix[]{fix});
                }
            }

            public void visitWhileStatement(PsiWhileStatement statement2) {
                this.checkLoopCondition(statement2.getCondition());
            }

            public void visitDoWhileStatement(PsiDoWhileStatement statement2) {
                this.checkLoopCondition(statement2.getCondition());
            }

            public void visitForStatement(PsiForStatement statement2) {
                this.checkLoopCondition(statement2.getCondition());
            }

            private void checkLoopCondition(PsiExpression condition2) {
                if ((condition2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)condition2)) != null && condition2.textMatches((CharSequence)"false")) {
                    holder.registerProblem((PsiElement)condition2, "Condition is always false", new LocalQuickFix[]{DataFlowInspectionBase.createSimplifyBooleanExpressionFix((PsiElement)condition2, false)});
                }
            }
        };
        if (javaElementVisitor == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(2);
        }
        return javaElementVisitor;
    }

    protected LocalQuickFix createNavigateToNullParameterUsagesFix(PsiParameter parameter2) {
        return null;
    }

    private void analyzeNullLiteralMethodArguments(PsiMethod method, ProblemsHolder holder) {
        if (this.REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER && holder.isOnTheFly()) {
            for (PsiParameter parameter2 : NullParameterConstraintChecker.checkMethodParameters(method)) {
                PsiIdentifier name2 = parameter2.getNameIdentifier();
                if (name2 == null) continue;
                holder.registerProblem((PsiElement)name2, InspectionsBundle.message((String)"dataflow.method.fails.with.null.argument", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{this.createNavigateToNullParameterUsagesFix(parameter2)});
            }
        }
    }

    private void analyzeCodeBlock(@Nullable PsiElement scope, ProblemsHolder holder) {
        if (scope == null) {
            return;
        }
        PsiClass containingClass = (PsiClass)PsiTreeUtil.getNonStrictParentOfType((PsiElement)scope, (Class[])new Class[]{PsiClass.class});
        if (containingClass != null && PsiUtil.isLocalOrAnonymousClass((PsiClass)containingClass) && !(containingClass instanceof PsiEnumConstantInitializer)) {
            return;
        }
        StandardDataFlowRunner dfaRunner = new StandardDataFlowRunner(this.TREAT_UNKNOWN_MEMBERS_AS_NULLABLE, !DfaUtil.isInsideConstructorOrInitializer(scope));
        this.analyzeDfaWithNestedClosures(scope, holder, dfaRunner, Collections.singletonList(dfaRunner.createMemoryState()));
    }

    private void analyzeDfaWithNestedClosures(PsiElement scope, ProblemsHolder holder, StandardDataFlowRunner dfaRunner, Collection<DfaMemoryState> initialStates) {
        DataFlowInstructionVisitor visitor = new DataFlowInstructionVisitor();
        RunnerResult rc = dfaRunner.analyzeMethod(scope, visitor, this.IGNORE_ASSERT_STATEMENTS, initialStates);
        if (rc == RunnerResult.OK) {
            this.createDescription(dfaRunner, holder, visitor, scope);
            MultiMap<PsiElement, DfaMemoryState> nestedClosures = dfaRunner.getNestedClosures();
            for (PsiElement closure : nestedClosures.keySet()) {
                this.analyzeDfaWithNestedClosures(closure, holder, dfaRunner, nestedClosures.get((Object)closure));
            }
        } else if (rc == RunnerResult.TOO_COMPLEX) {
            PsiIdentifier name2 = null;
            String message2 = null;
            if (scope.getParent() instanceof PsiMethod) {
                name2 = ((PsiMethod)scope.getParent()).getNameIdentifier();
                message2 = InspectionsBundle.message((String)"dataflow.too.complex", (Object[])new Object[0]);
            } else if (scope instanceof PsiClass) {
                name2 = ((PsiClass)scope).getNameIdentifier();
                message2 = InspectionsBundle.message((String)"dataflow.too.complex.class", (Object[])new Object[0]);
            }
            if (name2 != null) {
                holder.registerProblem((PsiElement)name2, message2, ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[0]);
            }
        }
    }

    @NotNull
    protected List<LocalQuickFix> createNPEFixes(PsiExpression qualifier, PsiExpression expression2, boolean onTheFly) {
        List<LocalQuickFix> list2 = Collections.emptyList();
        if (list2 == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(3);
        }
        return list2;
    }

    protected List<LocalQuickFix> createMethodReferenceNPEFixes(PsiMethodReferenceExpression methodRef) {
        return Collections.emptyList();
    }

    @Nullable
    protected LocalQuickFix createIntroduceVariableFix(PsiExpression expression2) {
        return null;
    }

    protected LocalQuickFix createReplaceWithTrivialLambdaFix(Object value2) {
        return null;
    }

    private void createDescription(StandardDataFlowRunner runner, ProblemsHolder holder, DataFlowInstructionVisitor visitor, PsiElement scope) {
        Pair<Set<Instruction>, Set<Instruction>> constConditions = runner.getConstConditionalExpressions();
        Set trueSet = (Set)constConditions.getFirst();
        Set falseSet = (Set)constConditions.getSecond();
        ArrayList allProblems = new ArrayList();
        allProblems.addAll(trueSet);
        allProblems.addAll(falseSet);
        allProblems.addAll(visitor.myCCEInstructions);
        allProblems.addAll(ContainerUtil.filter((Object[])runner.getInstructions(), instruction1 -> instruction1 instanceof InstanceofInstruction && visitor.isInstanceofRedundant((InstanceofInstruction)instruction1)));
        HashSet<PsiElement> reportedAnchors = new HashSet<PsiElement>();
        for (PsiElement element : visitor.getProblems(NullabilityProblem.callNPE)) {
            if (!reportedAnchors.add(element)) continue;
            if (element instanceof PsiMethodReferenceExpression) {
                holder.registerProblem(element, InspectionsBundle.message((String)"dataflow.message.npe.methodref.invocation", (Object[])new Object[0]), this.createMethodReferenceNPEFixes((PsiMethodReferenceExpression)element).toArray(LocalQuickFix.EMPTY_ARRAY));
                continue;
            }
            if (element instanceof PsiNewExpression) {
                List<LocalQuickFix> fixes = this.createNPEFixes(((PsiNewExpression)element).getQualifier(), (PsiExpression)element, holder.isOnTheFly());
                holder.registerProblem(DataFlowInspectionBase.getElementToHighlight((PsiCall)element), InspectionsBundle.message((String)"dataflow.message.npe.inner.class.construction", (Object[])new Object[0]), fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
                continue;
            }
            this.reportCallMayProduceNpe(holder, (PsiMethodCallExpression)element);
        }
        for (PsiElement element : visitor.getProblems(NullabilityProblem.fieldAccessNPE)) {
            if (!reportedAnchors.add(element)) continue;
            PsiElement parent = element.getParent();
            PsiElement fieldAccess = parent instanceof PsiArrayAccessExpression || parent instanceof PsiReferenceExpression ? parent : element;
            this.reportFieldAccessMayProduceNpe(holder, element, (PsiExpression)fieldAccess);
        }
        for (Instruction instruction : allProblems) {
            if (instruction instanceof TypeCastInstruction && reportedAnchors.add((PsiElement)((TypeCastInstruction)instruction).getCastExpression().getCastType())) {
                DataFlowInspectionBase.reportCastMayFail(holder, (TypeCastInstruction)instruction);
                continue;
            }
            if (!(instruction instanceof BranchingInstruction)) continue;
            this.handleBranchingInstruction(holder, visitor, trueSet, falseSet, reportedAnchors, (BranchingInstruction)instruction);
        }
        DataFlowInspectionBase.reportAlwaysFailingCalls(holder, visitor, reportedAnchors);
        this.reportConstantPushes(runner, holder, reportedAnchors);
        DataFlowInspectionBase.reportNullableFunctions(visitor, holder, reportedAnchors);
        this.reportNullableArguments(visitor, holder, reportedAnchors);
        this.reportNullableAssignments(visitor, holder, reportedAnchors);
        DataFlowInspectionBase.reportUnboxedNullables(visitor, holder, reportedAnchors);
        this.reportNullableReturns(visitor, holder, reportedAnchors, scope);
        if (this.SUGGEST_NULLABLE_ANNOTATIONS) {
            this.reportNullableArgumentsPassedToNonAnnotated(visitor, holder, reportedAnchors);
        }
        DataFlowInspectionBase.reportOptionalOfNullableImprovements(holder, reportedAnchors, visitor.getOfNullableCalls());
        this.reportUncheckedOptionalGet(holder, visitor.getOptionalCalls(), visitor.getOptionalQualifiers());
        visitor.getBooleanCalls().forEach((call, state) -> {
            if (state != ThreeState.UNSURE && reportedAnchors.add((PsiElement)call)) {
                this.reportConstantCondition(holder, (PsiElement)call, state.toBoolean());
            }
        });
        this.reportMethodReferenceProblems(holder, visitor);
        DataFlowInspectionBase.reportArrayAccessProblems(holder, visitor);
        if (this.REPORT_CONSTANT_REFERENCE_VALUES) {
            this.reportConstantReferenceValues(holder, visitor, reportedAnchors);
        }
        if (this.REPORT_NULLABLE_METHODS_RETURNING_NOT_NULL && visitor.isAlwaysReturnsNotNull(runner.getInstructions())) {
            this.reportAlwaysReturnsNotNull(holder, scope);
        }
    }

    private static void reportArrayAccessProblems(ProblemsHolder holder, DataFlowInstructionVisitor visitor) {
        visitor.outOfBoundsArrayAccesses().forEach(access -> {
            PsiExpression indexExpression = access.getIndexExpression();
            if (indexExpression != null) {
                holder.registerProblem((PsiElement)indexExpression, InspectionsBundle.message((String)"dataflow.message.array.index.out.of.bounds", (Object[])new Object[0]), new LocalQuickFix[0]);
            }
        });
    }

    private void reportMethodReferenceProblems(ProblemsHolder holder, DataFlowInstructionVisitor visitor) {
        visitor.getMethodReferenceResults().forEach((methodRef, dfaValue) -> {
            Object value2;
            if (dfaValue instanceof DfaConstValue && (value2 = ((DfaConstValue)dfaValue).getValue()) instanceof Boolean) {
                holder.registerProblem((PsiElement)methodRef, InspectionsBundle.message((String)"dataflow.message.constant.method.reference", (Object[])new Object[]{value2}), new LocalQuickFix[]{this.createReplaceWithTrivialLambdaFix(value2)});
            }
        });
    }

    private void reportUncheckedOptionalGet(ProblemsHolder holder, Map<PsiMethodCallExpression, ThreeState> calls, List<PsiExpression> qualifiers) {
        if (!this.REPORT_UNCHECKED_OPTIONALS) {
            return;
        }
        for (Map.Entry<PsiMethodCallExpression, ThreeState> entry : calls.entrySet()) {
            PsiExpression qualifier;
            PsiClass optionalClass;
            PsiMethodCallExpression call;
            PsiMethod method;
            ThreeState state = entry.getValue();
            if (state != ThreeState.UNSURE || (method = (call = entry.getKey()).resolveMethod()) == null || (optionalClass = method.getContainingClass()) == null || (qualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)call.getMethodExpression().getQualifierExpression())) instanceof PsiMethodCallExpression && qualifiers.stream().anyMatch(q -> PsiEquivalenceUtil.areElementsEquivalent((PsiElement)q, (PsiElement)qualifier))) continue;
            SetInspectionOptionFix fix = holder.isOnTheFly() ? new SetInspectionOptionFix((InspectionProfileEntry)this, "REPORT_UNCHECKED_OPTIONALS", InspectionsBundle.message((String)"inspection.data.flow.turn.off.unchecked.optional.get.quickfix", (Object[])new Object[0]), false) : null;
            holder.registerProblem(DataFlowInspectionBase.getElementToHighlight((PsiCall)call), InspectionsBundle.message((String)"dataflow.message.optional.get.without.is.present", (Object[])new Object[]{optionalClass.getName()}), new LocalQuickFix[]{fix});
        }
    }

    private void reportAlwaysReturnsNotNull(ProblemsHolder holder, PsiElement scope) {
        if (!(scope.getParent() instanceof PsiMethod)) {
            return;
        }
        PsiMethod method = (PsiMethod)scope.getParent();
        if (PsiUtil.canBeOverridden((PsiMethod)method)) {
            return;
        }
        PsiAnnotation nullableAnno = NullableNotNullManager.getInstance((Project)scope.getProject()).getNullableAnnotation((PsiModifierListOwner)method, false);
        if (nullableAnno == null || !nullableAnno.isPhysical()) {
            return;
        }
        PsiJavaCodeReferenceElement annoName = nullableAnno.getNameReferenceElement();
        assert (annoName != null);
        String msg = "@" + NullableStuffInspectionBase.getPresentableAnnoName(nullableAnno) + " method '" + method.getName() + "' always returns a non-null value";
        Object[] fixes = new LocalQuickFix[]{new AddNotNullAnnotationFix((PsiModifierListOwner)method)};
        if (holder.isOnTheFly()) {
            fixes = (LocalQuickFix[])ArrayUtil.append((Object[])fixes, (Object)new SetInspectionOptionFix((InspectionProfileEntry)this, "REPORT_NULLABLE_METHODS_RETURNING_NOT_NULL", InspectionsBundle.message((String)"inspection.data.flow.turn.off.nullable.returning.notnull.quickfix", (Object[])new Object[0]), false));
        }
        holder.registerProblem((PsiElement)annoName, msg, (LocalQuickFix[])fixes);
    }

    private static void reportAlwaysFailingCalls(ProblemsHolder holder, DataFlowInstructionVisitor visitor, HashSet<PsiElement> reportedAnchors) {
        if (ProjectFileIndex.SERVICE.getInstance((Project)holder.getProject()).isInTestSourceContent(holder.getFile().getViewProvider().getVirtualFile())) {
            return;
        }
        visitor.getAlwaysFailingCalls().forEach((call, contracts2) -> {
            PsiMethod method = call.resolveMethod();
            if (method != null && reportedAnchors.add((PsiElement)call)) {
                holder.registerProblem(DataFlowInspectionBase.getElementToHighlight(call), DataFlowInspectionBase.getContractMessage(contracts2), new LocalQuickFix[0]);
            }
        });
    }

    @NotNull
    private static String getContractMessage(List<MethodContract> contracts2) {
        if (contracts2.stream().allMatch(mc -> mc.getConditions().stream().allMatch(cv -> cv.isBoundCheckingCondition()))) {
            String string = InspectionsBundle.message((String)"dataflow.message.contract.fail.index", (Object[])new Object[0]);
            if (string == null) {
                DataFlowInspectionBase.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = InspectionsBundle.message((String)"dataflow.message.contract.fail", (Object[])new Object[0]);
        if (string == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    private static PsiElement getElementToHighlight(@NotNull PsiCall call) {
        PsiJavaCodeReferenceElement ref;
        if (call == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(6);
        }
        if (call instanceof PsiNewExpression) {
            ref = ((PsiNewExpression)call).getClassReference();
        } else if (call instanceof PsiMethodCallExpression) {
            ref = ((PsiMethodCallExpression)call).getMethodExpression();
        } else {
            PsiCall psiCall = call;
            if (psiCall == null) {
                DataFlowInspectionBase.$$$reportNull$$$0(7);
            }
            return psiCall;
        }
        if (ref != null) {
            PsiElement name2 = ref.getReferenceNameElement();
            Object object = name2 != null ? name2 : ref;
            if (object == null) {
                DataFlowInspectionBase.$$$reportNull$$$0(8);
            }
            return object;
        }
        PsiCall psiCall = call;
        if (psiCall == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(9);
        }
        return psiCall;
    }

    private void reportConstantPushes(StandardDataFlowRunner runner, ProblemsHolder holder, Set<PsiElement> reportedAnchors) {
        for (Instruction instruction : runner.getInstructions()) {
            Object constant;
            if (!(instruction instanceof PushInstruction)) continue;
            PsiExpression place = ((PushInstruction)instruction).getPlace();
            DfaValue value2 = ((PushInstruction)instruction).getValue();
            Object object = constant = value2 instanceof DfaConstValue ? ((DfaConstValue)value2).getValue() : null;
            if (!(place instanceof PsiPolyadicExpression) || !(constant instanceof Boolean) || DataFlowInspectionBase.isFlagCheck((PsiElement)place) || !reportedAnchors.add((PsiElement)place)) continue;
            this.reportConstantCondition(holder, (PsiElement)place, (Boolean)constant);
        }
    }

    private static void reportOptionalOfNullableImprovements(ProblemsHolder holder, Set<PsiElement> reportedAnchors, Map<MethodCallInstruction, ThreeState> nullArgs) {
        nullArgs.forEach((call, nullArg) -> {
            PsiElement arg = call.getArgumentAnchor(0);
            if (reportedAnchors.add(arg)) {
                switch (nullArg) {
                    case YES: {
                        holder.registerProblem(arg, "Passing <code>null</code> argument to <code>Optional</code>", new LocalQuickFix[]{DfaOptionalSupport.createReplaceOptionalOfNullableWithEmptyFix(arg)});
                        break;
                    }
                    case NO: {
                        holder.registerProblem(arg, "Passing a non-null argument to <code>Optional</code>", new LocalQuickFix[]{DfaOptionalSupport.createReplaceOptionalOfNullableWithOfFix(arg)});
                        break;
                    }
                }
            }
        });
    }

    private void reportConstantReferenceValues(ProblemsHolder holder, StandardInstructionVisitor visitor, Set<PsiElement> reportedAnchors) {
        for (Pair<PsiReferenceExpression, DfaConstValue> pair2 : visitor.getConstantReferenceValues()) {
            PsiReferenceExpression ref = (PsiReferenceExpression)pair2.first;
            if (ref.getParent() instanceof PsiReferenceExpression || !reportedAnchors.add((PsiElement)ref)) continue;
            Object value2 = ((DfaConstValue)pair2.second).getValue();
            PsiVariable constant = ((DfaConstValue)pair2.second).getConstant();
            String presentableName = constant != null ? constant.getName() : String.valueOf(value2);
            String exprText = String.valueOf(value2);
            if (presentableName == null || exprText == null) continue;
            Object[] fixes = new LocalQuickFix[]{new ReplaceWithConstantValueFix(presentableName, exprText)};
            if (holder.isOnTheFly()) {
                fixes = (LocalQuickFix[])ArrayUtil.append((Object[])fixes, (Object)new SetInspectionOptionFix((InspectionProfileEntry)this, "REPORT_CONSTANT_REFERENCE_VALUES", InspectionsBundle.message((String)"inspection.data.flow.turn.off.constant.references.quickfix", (Object[])new Object[0]), false));
            }
            holder.registerProblem((PsiElement)ref, "Value <code>#ref</code> #loc is always '" + presentableName + "'", (LocalQuickFix[])fixes);
        }
    }

    private void reportNullableArgumentsPassedToNonAnnotated(DataFlowInstructionVisitor visitor, ProblemsHolder holder, Set<PsiElement> reportedAnchors) {
        for (PsiElement expr : visitor.getProblems(NullabilityProblem.passingNullableArgumentToNonAnnotatedParameter)) {
            PsiParameter[] parameters2;
            PsiMethod psiMethod;
            PsiElement gParent;
            int idx;
            if (reportedAnchors.contains(expr)) continue;
            if (expr.getParent() instanceof PsiMethodReferenceExpression) {
                holder.registerProblem(expr.getParent(), "Method reference argument might be null but passed to non annotated parameter", new LocalQuickFix[0]);
                continue;
            }
            String text2 = DataFlowInspectionBase.isNullLiteralExpression(expr) ? "Passing <code>null</code> argument to non annotated parameter" : "Argument <code>#ref</code> #loc might be null but passed to non annotated parameter";
            List<LocalQuickFix> fixes = this.createNPEFixes((PsiExpression)expr, (PsiExpression)expr, holder.isOnTheFly());
            PsiElement parent = expr.getParent();
            if (!(parent instanceof PsiExpressionList) || (idx = ArrayUtilRt.find((Object[])((PsiExpressionList)parent).getExpressions(), (Object)expr)) <= -1 || !((gParent = parent.getParent()) instanceof PsiCallExpression) || (psiMethod = ((PsiCallExpression)gParent).resolveMethod()) == null || !psiMethod.getManager().isInProject((PsiElement)psiMethod) || !AnnotationUtil.isAnnotatingApplicable((PsiElement)psiMethod) || idx >= (parameters2 = psiMethod.getParameterList().getParameters()).length) continue;
            fixes.add((LocalQuickFix)new AddNullableAnnotationFix((PsiModifierListOwner)parameters2[idx]));
            holder.registerProblem(expr, text2, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
            reportedAnchors.add(expr);
        }
    }

    private void reportCallMayProduceNpe(ProblemsHolder holder, PsiMethodCallExpression callExpression) {
        PsiReferenceExpression methodExpression = callExpression.getMethodExpression();
        List<LocalQuickFix> fixes = this.createNPEFixes(methodExpression.getQualifierExpression(), (PsiExpression)callExpression, holder.isOnTheFly());
        ContainerUtil.addIfNotNull(fixes, (Object)ReplaceWithObjectsEqualsFix.createFix(callExpression, methodExpression));
        PsiElement toHighlight = DataFlowInspectionBase.getElementToHighlight((PsiCall)callExpression);
        holder.registerProblem(toHighlight, InspectionsBundle.message((String)"dataflow.message.npe.method.invocation", (Object[])new Object[0]), fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
    }

    private void reportFieldAccessMayProduceNpe(ProblemsHolder holder, PsiElement elementToAssert, @NotNull PsiExpression expression2) {
        if (expression2 == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(10);
        }
        LocalQuickFix[] fix = this.createNPEFixes((PsiExpression)elementToAssert, expression2, holder.isOnTheFly()).toArray(LocalQuickFix.EMPTY_ARRAY);
        if (expression2 instanceof PsiArrayAccessExpression) {
            holder.registerProblem((PsiElement)expression2, InspectionsBundle.message((String)"dataflow.message.npe.array.access", (Object[])new Object[0]), fix);
        } else {
            assert (elementToAssert != null);
            holder.registerProblem(elementToAssert, expression2.textMatches((CharSequence)"null") ? InspectionsBundle.message((String)"dataflow.message.npe.field.access.sure", (Object[])new Object[0]) : InspectionsBundle.message((String)"dataflow.message.npe.field.access", (Object[])new Object[0]), fix);
        }
    }

    private static void reportCastMayFail(ProblemsHolder holder, TypeCastInstruction instruction) {
        PsiTypeCastExpression typeCast = instruction.getCastExpression();
        PsiExpression operand2 = typeCast.getOperand();
        PsiTypeElement castType = typeCast.getCastType();
        assert (castType != null);
        assert (operand2 != null);
        holder.registerProblem((PsiElement)castType, InspectionsBundle.message((String)"dataflow.message.cce", (Object[])new Object[]{operand2.getText()}), new LocalQuickFix[0]);
    }

    private void handleBranchingInstruction(ProblemsHolder holder, StandardInstructionVisitor visitor, Set<Instruction> trueSet, Set<Instruction> falseSet, HashSet<PsiElement> reportedAnchors, BranchingInstruction instruction) {
        PsiElement psiAnchor = instruction.getPsiAnchor();
        if (instruction instanceof InstanceofInstruction && visitor.isInstanceofRedundant((InstanceofInstruction)instruction)) {
            if (visitor.canBeNull((BinopInstruction)instruction)) {
                holder.registerProblem(psiAnchor, InspectionsBundle.message((String)"dataflow.message.redundant.instanceof", (Object[])new Object[0]), new LocalQuickFix[]{new RedundantInstanceofFix()});
            } else {
                LocalQuickFix localQuickFix = DataFlowInspectionBase.createSimplifyBooleanExpressionFix(psiAnchor, true);
                String message2 = InspectionsBundle.message((String)(DataFlowInspectionBase.isAtRHSOfBooleanAnd(psiAnchor) ? "dataflow.message.constant.condition.when.reached" : "dataflow.message.constant.condition"), (Object[])new Object[]{Boolean.toString(true)});
                holder.registerProblem(psiAnchor, message2, new LocalQuickFix[]{localQuickFix});
            }
        } else if (psiAnchor instanceof PsiSwitchLabelStatement) {
            if (falseSet.contains(instruction)) {
                holder.registerProblem(psiAnchor, InspectionsBundle.message((String)"dataflow.message.unreachable.switch.label", (Object[])new Object[0]), new LocalQuickFix[0]);
            }
        } else if (psiAnchor != null && !reportedAnchors.contains(psiAnchor) && !DataFlowInspectionBase.isFlagCheck(psiAnchor)) {
            boolean evaluatesToTrue = trueSet.contains(instruction);
            PsiElement parent = psiAnchor.getParent();
            if (parent instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)parent).getLExpression() == psiAnchor) {
                holder.registerProblem(psiAnchor, InspectionsBundle.message((String)"dataflow.message.pointless.assignment.expression", (Object[])new Object[]{Boolean.toString(evaluatesToTrue)}), this.createConditionalAssignmentFixes(evaluatesToTrue, (PsiAssignmentExpression)parent, holder.isOnTheFly()));
            } else {
                this.reportConstantCondition(holder, psiAnchor, evaluatesToTrue);
            }
            reportedAnchors.add(psiAnchor);
        }
    }

    private void reportConstantCondition(ProblemsHolder holder, PsiElement psiAnchor, boolean evaluatesToTrue) {
        if (psiAnchor.getParent() instanceof PsiForeachStatement) {
            if (!evaluatesToTrue) {
                return;
            }
            boolean array = psiAnchor instanceof PsiExpression && ((PsiExpression)psiAnchor).getType() instanceof PsiArrayType;
            holder.registerProblem(psiAnchor, array ? InspectionsBundle.message((String)"dataflow.message.loop.on.empty.array", (Object[])new Object[0]) : InspectionsBundle.message((String)"dataflow.message.loop.on.empty.collection", (Object[])new Object[0]), new LocalQuickFix[0]);
        } else {
            boolean isAssertion = DataFlowInspectionBase.isAssertionEffectively(psiAnchor, evaluatesToTrue);
            if (!this.DONT_REPORT_TRUE_ASSERT_STATEMENTS || !isAssertion) {
                ArrayList<SetInspectionOptionFix> fixes = new ArrayList<SetInspectionOptionFix>();
                ContainerUtil.addIfNotNull(fixes, (Object)DataFlowInspectionBase.createSimplifyBooleanExpressionFix(psiAnchor, evaluatesToTrue));
                if (isAssertion && holder.isOnTheFly()) {
                    fixes.add(new SetInspectionOptionFix((InspectionProfileEntry)this, "DONT_REPORT_TRUE_ASSERT_STATEMENTS", InspectionsBundle.message((String)"inspection.data.flow.turn.off.true.asserts.quickfix", (Object[])new Object[0]), true));
                }
                String message2 = InspectionsBundle.message((String)(DataFlowInspectionBase.isAtRHSOfBooleanAnd(psiAnchor) ? "dataflow.message.constant.condition.when.reached" : "dataflow.message.constant.condition"), (Object[])new Object[]{Boolean.toString(evaluatesToTrue)});
                holder.registerProblem(psiAnchor, message2, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
            }
        }
    }

    protected LocalQuickFix[] createConditionalAssignmentFixes(boolean evaluatesToTrue, PsiAssignmentExpression parent, boolean onTheFly) {
        return LocalQuickFix.EMPTY_ARRAY;
    }

    private static void reportNullableFunctions(DataFlowInstructionVisitor visitor, ProblemsHolder holder, Set<PsiElement> reportedAnchors) {
        for (PsiElement expr : visitor.getProblems(NullabilityProblem.nullableFunctionReturn)) {
            if (!reportedAnchors.add(expr)) continue;
            holder.registerProblem(expr, InspectionsBundle.message((String)"dataflow.message.return.nullable.from.notnull.function", (Object[])new Object[0]), new LocalQuickFix[0]);
        }
    }

    private void reportNullableArguments(DataFlowInstructionVisitor visitor, ProblemsHolder holder, Set<PsiElement> reportedAnchors) {
        for (PsiElement expr : visitor.getProblems(NullabilityProblem.passingNullableToNotNullParameter)) {
            if (!reportedAnchors.add(expr)) continue;
            if (expr.getParent() instanceof PsiMethodReferenceExpression) {
                PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)expr.getParent();
                holder.registerProblem((PsiElement)methodRef, InspectionsBundle.message((String)"dataflow.message.passing.nullable.argument.methodref", (Object[])new Object[0]), this.createMethodReferenceNPEFixes(methodRef).toArray(LocalQuickFix.EMPTY_ARRAY));
                continue;
            }
            String text2 = DataFlowInspectionBase.isNullLiteralExpression(expr) ? InspectionsBundle.message((String)"dataflow.message.passing.null.argument", (Object[])new Object[0]) : InspectionsBundle.message((String)"dataflow.message.passing.nullable.argument", (Object[])new Object[0]);
            List<LocalQuickFix> fixes = this.createNPEFixes((PsiExpression)expr, (PsiExpression)expr, holder.isOnTheFly());
            holder.registerProblem(expr, text2, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
        }
    }

    private void reportNullableAssignments(DataFlowInstructionVisitor visitor, ProblemsHolder holder, Set<PsiElement> reportedAnchors) {
        String text2;
        for (PsiElement expr : visitor.getProblems(NullabilityProblem.assigningToNotNull)) {
            if (!reportedAnchors.add(expr)) continue;
            assert (expr instanceof PsiExpression);
            text2 = DataFlowInspectionBase.isNullLiteralExpression(expr) ? InspectionsBundle.message((String)"dataflow.message.assigning.null", (Object[])new Object[0]) : InspectionsBundle.message((String)"dataflow.message.assigning.nullable", (Object[])new Object[0]);
            holder.registerProblem(expr, text2, this.createNPEFixes((PsiExpression)expr, (PsiExpression)expr, holder.isOnTheFly()).toArray(LocalQuickFix.EMPTY_ARRAY));
        }
        for (PsiElement expr : visitor.getProblems(NullabilityProblem.storingToNotNullArray)) {
            if (!reportedAnchors.add(expr)) continue;
            assert (expr instanceof PsiExpression);
            text2 = DataFlowInspectionBase.isNullLiteralExpression(expr) ? InspectionsBundle.message((String)"dataflow.message.storing.array.null", (Object[])new Object[0]) : InspectionsBundle.message((String)"dataflow.message.storing.array.nullable", (Object[])new Object[0]);
            holder.registerProblem(expr, text2, this.createNPEFixes((PsiExpression)expr, (PsiExpression)expr, holder.isOnTheFly()).toArray(LocalQuickFix.EMPTY_ARRAY));
        }
    }

    private static void reportUnboxedNullables(DataFlowInstructionVisitor visitor, ProblemsHolder holder, Set<PsiElement> reportedAnchors) {
        for (PsiElement expr : visitor.getProblems(NullabilityProblem.unboxingNullable)) {
            if (!reportedAnchors.add(expr)) continue;
            holder.registerProblem(expr, InspectionsBundle.message((String)"dataflow.message.unboxing", (Object[])new Object[0]), new LocalQuickFix[0]);
        }
    }

    @Nullable
    private static PsiMethod getScopeMethod(PsiElement block) {
        PsiElement parent = block.getParent();
        if (parent instanceof PsiMethod) {
            return (PsiMethod)parent;
        }
        if (parent instanceof PsiLambdaExpression) {
            return LambdaUtil.getFunctionalInterfaceMethod((PsiType)((PsiLambdaExpression)parent).getFunctionalInterfaceType());
        }
        return null;
    }

    private void reportNullableReturns(DataFlowInstructionVisitor visitor, ProblemsHolder holder, Set<PsiElement> reportedAnchors, @NotNull PsiElement block) {
        PsiMethod method;
        if (block == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(11);
        }
        if ((method = DataFlowInspectionBase.getScopeMethod(block)) == null || NullableStuffInspectionBase.isNullableNotInferred((PsiModifierListOwner)method, true)) {
            return;
        }
        PsiAnnotation notNullAnno = NullableNotNullManager.getInstance((Project)method.getProject()).getNotNullAnnotation((PsiModifierListOwner)method, true);
        if (notNullAnno == null && (!this.SUGGEST_NULLABLE_ANNOTATIONS || block.getParent() instanceof PsiLambdaExpression)) {
            return;
        }
        PsiType returnType = method.getReturnType();
        if (block instanceof PsiExpression && block.getParent() instanceof PsiLambdaExpression && PsiType.VOID.equals((Object)returnType)) {
            return;
        }
        if (returnType == null || returnType.equalsToText("java.lang.Void")) {
            return;
        }
        for (PsiElement statement2 : visitor.getProblems(NullabilityProblem.nullableReturn)) {
            LocalQuickFix[] localQuickFixArray;
            String text2;
            assert (statement2 instanceof PsiExpression);
            PsiExpression expr = (PsiExpression)statement2;
            if (!reportedAnchors.add((PsiElement)expr)) continue;
            if (notNullAnno != null) {
                String presentable = NullableStuffInspectionBase.getPresentableAnnoName(notNullAnno);
                String text3 = DataFlowInspectionBase.isNullLiteralExpression((PsiElement)expr) ? InspectionsBundle.message((String)"dataflow.message.return.null.from.notnull", (Object[])new Object[]{presentable}) : InspectionsBundle.message((String)"dataflow.message.return.nullable.from.notnull", (Object[])new Object[]{presentable});
                holder.registerProblem((PsiElement)expr, text3, new LocalQuickFix[0]);
                continue;
            }
            if (!AnnotationUtil.isAnnotatingApplicable((PsiElement)statement2)) continue;
            NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)expr.getProject());
            String defaultNullable = manager.getDefaultNullable();
            String presentableNullable = StringUtil.getShortName((String)defaultNullable);
            String string = text2 = DataFlowInspectionBase.isNullLiteralExpression((PsiElement)expr) ? InspectionsBundle.message((String)"dataflow.message.return.null.from.notnullable", (Object[])new Object[]{presentableNullable}) : InspectionsBundle.message((String)"dataflow.message.return.nullable.from.notnullable", (Object[])new Object[]{presentableNullable});
            if (PsiTreeUtil.getParentOfType((PsiElement)expr, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class}) instanceof PsiLambdaExpression) {
                localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
            } else {
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                localQuickFixArray = localQuickFixArray2;
                localQuickFixArray2[0] = new AnnotateMethodFix(defaultNullable, ArrayUtil.toStringArray((Collection)manager.getNotNulls()));
            }
            LocalQuickFix[] fixes = localQuickFixArray;
            holder.registerProblem((PsiElement)expr, text2, fixes);
        }
    }

    private static boolean isAssertionEffectively(PsiElement psiAnchor, boolean evaluatesToTrue) {
        PsiStatement thenBranch;
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)psiAnchor.getParent());
        if (parent instanceof PsiAssertStatement) {
            return evaluatesToTrue;
        }
        if (parent instanceof PsiIfStatement && psiAnchor == ((PsiIfStatement)parent).getCondition() && (thenBranch = ControlFlowUtils.stripBraces(((PsiIfStatement)parent).getThenBranch())) instanceof PsiThrowStatement) {
            return !evaluatesToTrue;
        }
        return false;
    }

    private static boolean isAtRHSOfBooleanAnd(PsiElement expr) {
        PsiElement cur = expr;
        while (cur != null && !(cur instanceof PsiMember)) {
            PsiElement parent = cur.getParent();
            if (parent instanceof PsiBinaryExpression && cur == ((PsiBinaryExpression)parent).getROperand()) {
                return true;
            }
            cur = parent;
        }
        return false;
    }

    private static boolean isFlagCheck(PsiElement element) {
        PsiExpression topExpression;
        PsiElement scope = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiStatement.class, PsiVariable.class});
        Object object = scope instanceof PsiIfStatement ? ((PsiIfStatement)scope).getCondition() : (topExpression = scope instanceof PsiVariable ? ((PsiVariable)scope).getInitializer() : null);
        if (!PsiTreeUtil.isAncestor((PsiElement)topExpression, (PsiElement)element, (boolean)false)) {
            return false;
        }
        return StreamEx.ofTree((Object)topExpression, e -> StreamEx.of((Object[])e.getChildren())).anyMatch(DataFlowInspectionBase::isCompileTimeFlagCheck);
    }

    private static boolean isCompileTimeFlagCheck(PsiElement element) {
        PsiBinaryExpression binOp;
        if (element instanceof PsiBinaryExpression && ComparisonUtils.isComparisonOperation((binOp = (PsiBinaryExpression)element).getOperationTokenType())) {
            PsiBinaryExpression subOp;
            PsiExpression comparedWith = null;
            if (ExpressionUtils.isLiteral(binOp.getROperand())) {
                comparedWith = binOp.getLOperand();
            } else if (ExpressionUtils.isLiteral(binOp.getLOperand())) {
                comparedWith = binOp.getROperand();
            }
            comparedWith = PsiUtil.skipParenthesizedExprDown((PsiExpression)comparedWith);
            if (DataFlowInspectionBase.isConstantOfType((PsiElement)comparedWith, PsiType.INT, PsiType.LONG)) {
                return true;
            }
            if (comparedWith instanceof PsiBinaryExpression && (subOp = (PsiBinaryExpression)comparedWith).getOperationTokenType().equals(JavaTokenType.AND)) {
                PsiExpression left = PsiUtil.skipParenthesizedExprDown((PsiExpression)subOp.getLOperand());
                PsiExpression right = PsiUtil.skipParenthesizedExprDown((PsiExpression)subOp.getROperand());
                if (DataFlowInspectionBase.isConstantOfType((PsiElement)left, PsiType.INT, PsiType.LONG) || DataFlowInspectionBase.isConstantOfType((PsiElement)right, PsiType.INT, PsiType.LONG)) {
                    return true;
                }
            }
        }
        return DataFlowInspectionBase.isConstantOfType(element, PsiType.BOOLEAN);
    }

    private static boolean isConstantOfType(PsiElement element, PsiPrimitiveType ... types) {
        PsiElement resolved;
        PsiElement psiElement = resolved = element instanceof PsiReferenceExpression ? ((PsiReferenceExpression)element).resolve() : null;
        if (!(resolved instanceof PsiField)) {
            return false;
        }
        PsiVariable field = (PsiVariable)resolved;
        return field.hasModifierProperty("static") && PsiUtil.isCompileTimeConstant((PsiVariable)field) && ArrayUtil.contains((Object)field.getType(), (Object[])types);
    }

    private static boolean isNullLiteralExpression(PsiElement expr) {
        if (expr instanceof PsiLiteralExpression) {
            PsiLiteralExpression literalExpression = (PsiLiteralExpression)expr;
            return PsiType.NULL.equals((Object)literalExpression.getType());
        }
        return false;
    }

    @Nullable
    private static LocalQuickFix createSimplifyBooleanExpressionFix(PsiElement element, final boolean value2) {
        SimplifyBooleanExpressionFix fix = DataFlowInspectionBase.createIntention(element, value2);
        if (fix == null) {
            return null;
        }
        final String text2 = fix.getText();
        return new LocalQuickFix(){

            @NotNull
            public String getName() {
                String string = text2;
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
                PsiElement psiElement;
                if (project2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (descriptor2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                if ((psiElement = descriptor2.getPsiElement()) == null) {
                    return;
                }
                SimplifyBooleanExpressionFix fix = DataFlowInspectionBase.createIntention(psiElement, value2);
                if (fix == null) {
                    return;
                }
                try {
                    LOG.assertTrue(psiElement.isValid());
                    fix.applyFix();
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }

            @NotNull
            public String getFamilyName() {
                String string = InspectionsBundle.message((String)"inspection.data.flow.simplify.boolean.expression.quickfix", (Object[])new Object[0]);
                if (string == null) {
                    2.$$$reportNull$$$0(3);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase$2";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase$2";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @NotNull
    protected static LocalQuickFix createSimplifyToAssignmentFix() {
        SimplifyToAssignmentFix simplifyToAssignmentFix = new SimplifyToAssignmentFix();
        if (simplifyToAssignmentFix == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(12);
        }
        return simplifyToAssignmentFix;
    }

    private static SimplifyBooleanExpressionFix createIntention(PsiElement element, boolean value2) {
        if (!(element instanceof PsiExpression)) {
            return null;
        }
        if (PsiTreeUtil.findChildOfType((PsiElement)element, PsiAssignmentExpression.class) != null) {
            return null;
        }
        PsiExpression expression2 = (PsiExpression)element;
        while (element.getParent() instanceof PsiExpression) {
            element = element.getParent();
        }
        SimplifyBooleanExpressionFix fix = new SimplifyBooleanExpressionFix(expression2, value2);
        if (!fix.isAvailable() || SimplifyBooleanExpressionFix.canBeSimplified((PsiExpression)element)) {
            return null;
        }
        return fix;
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"inspection.data.flow.display.name", (Object[])new Object[0]);
        if (string == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.BUGS_GROUP_NAME;
        if (string == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(15);
        }
        return SHORT_NAME;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createNPEFixes";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContractMessage";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementToHighlight";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createSimplifyToAssignmentFix";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getElementToHighlight";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "reportFieldAccessMayProduceNpe";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "reportNullableReturns";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DataFlowInstructionVisitor
    extends StandardInstructionVisitor {
        private final MultiMap<NullabilityProblem, PsiElement> myProblems = new MultiMap();
        private final Map<Pair<NullabilityProblem, PsiElement>, StateInfo> myStateInfos = ContainerUtil.newHashMap();
        private final Set<Instruction> myCCEInstructions = ContainerUtil.newHashSet();
        private final Map<MethodCallInstruction, Boolean> myFailingCalls = new HashMap<MethodCallInstruction, Boolean>();
        private final Map<PsiMethodCallExpression, ThreeState> myOptionalCalls = new HashMap<PsiMethodCallExpression, ThreeState>();
        private final Map<PsiMethodCallExpression, ThreeState> myBooleanCalls = new HashMap<PsiMethodCallExpression, ThreeState>();
        private final Map<MethodCallInstruction, ThreeState> myOfNullableCalls = new HashMap<MethodCallInstruction, ThreeState>();
        private final Map<PsiMethodReferenceExpression, DfaValue> myMethodReferenceResults = new HashMap<PsiMethodReferenceExpression, DfaValue>();
        private final Map<PsiArrayAccessExpression, ThreeState> myOutOfBoundsArrayAccesses = new HashMap<PsiArrayAccessExpression, ThreeState>();
        private final List<PsiExpression> myOptionalQualifiers = new ArrayList<PsiExpression>();
        private boolean myAlwaysReturnsNotNull = true;

        private DataFlowInstructionVisitor() {
        }

        @Override
        protected void onInstructionProducesCCE(TypeCastInstruction instruction) {
            this.myCCEInstructions.add(instruction);
        }

        Collection<PsiElement> getProblems(NullabilityProblem kind2) {
            return ContainerUtil.filter((Collection)this.myProblems.get((Object)kind2), psiElement -> {
                StateInfo info = this.myStateInfos.get(Pair.create((Object)((Object)kind2), (Object)psiElement));
                return info.normalNpe || info.ephemeralNpe && !info.normalOk;
            });
        }

        Map<PsiMethodCallExpression, ThreeState> getOptionalCalls() {
            return this.myOptionalCalls;
        }

        Map<MethodCallInstruction, ThreeState> getOfNullableCalls() {
            return this.myOfNullableCalls;
        }

        Map<PsiMethodCallExpression, ThreeState> getBooleanCalls() {
            return this.myBooleanCalls;
        }

        Map<PsiMethodReferenceExpression, DfaValue> getMethodReferenceResults() {
            return this.myMethodReferenceResults;
        }

        Stream<PsiArrayAccessExpression> outOfBoundsArrayAccesses() {
            return StreamEx.ofKeys(this.myOutOfBoundsArrayAccesses, arg_0 -> ThreeState.YES.equals(arg_0));
        }

        List<PsiExpression> getOptionalQualifiers() {
            return this.myOptionalQualifiers;
        }

        Map<PsiCall, List<MethodContract>> getAlwaysFailingCalls() {
            return StreamEx.ofKeys(this.myFailingCalls, v -> v).mapToEntry(MethodCallInstruction::getCallExpression, MethodCallInstruction::getContracts).toMap();
        }

        boolean isAlwaysReturnsNotNull(Instruction[] instructions) {
            return this.myAlwaysReturnsNotNull && ContainerUtil.exists((Object[])instructions, i -> i instanceof ReturnInstruction && ((ReturnInstruction)i).getAnchor() instanceof PsiReturnStatement);
        }

        @Override
        public DfaInstructionState[] visitMethodCall(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)instruction.getCallExpression(), PsiMethodCallExpression.class);
            if (call != null) {
                String methodName = call.getMethodExpression().getReferenceName();
                PsiExpression qualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)call.getMethodExpression().getQualifierExpression());
                if (qualifier != null && TypeUtils.isOptional(qualifier.getType())) {
                    if ("isPresent".equals(methodName) && qualifier instanceof PsiMethodCallExpression) {
                        this.myOptionalQualifiers.add(qualifier);
                    } else if (DfaOptionalSupport.isOptionalGetMethodName(methodName)) {
                        Boolean fact = memState.getValueFact(DfaFactType.OPTIONAL_PRESENCE, memState.peek());
                        ThreeState state = fact == null ? ThreeState.UNSURE : ThreeState.fromBoolean((boolean)fact);
                        this.myOptionalCalls.merge(call, state, ThreeState::merge);
                    }
                }
            }
            if (instruction.matches(DfaOptionalSupport.OPTIONAL_OF_NULLABLE)) {
                DfaValue arg = memState.peek();
                ThreeState nullArg = memState.isNull(arg) ? ThreeState.YES : (memState.isNotNull(arg) ? ThreeState.NO : ThreeState.UNSURE);
                this.myOfNullableCalls.merge(instruction, nullArg, ThreeState::merge);
            }
            DfaInstructionState[] states = super.visitMethodCall(instruction, runner, memState);
            if (DataFlowInstructionVisitor.hasNonTrivialFailingContracts(instruction)) {
                DfaConstValue fail = runner.getFactory().getConstFactory().getContractFail();
                boolean allFail = Arrays.stream(states).allMatch(s -> s.getMemoryState().peek() == fail);
                this.myFailingCalls.merge(instruction, allFail, Boolean::logicalAnd);
            }
            this.handleBooleanCalls(instruction, states);
            return states;
        }

        void handleBooleanCalls(MethodCallInstruction instruction, DfaInstructionState[] states) {
            if (!DataFlowInstructionVisitor.hasNonTrivialBooleanContracts(instruction)) {
                return;
            }
            PsiMethod method = instruction.getTargetMethod();
            if (method == null || !ControlFlowAnalyzer.isPure(method)) {
                return;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)instruction.getCallExpression(), PsiMethodCallExpression.class);
            if (call == null || this.myBooleanCalls.get(call) == ThreeState.UNSURE) {
                return;
            }
            PsiElement parent = call.getParent();
            if (parent instanceof PsiExpressionStatement) {
                return;
            }
            if (parent instanceof PsiLambdaExpression && PsiType.VOID.equals((Object)LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)((PsiLambdaExpression)parent)))) {
                return;
            }
            for (DfaInstructionState s : states) {
                Object value2;
                DfaValue val = s.getMemoryState().peek();
                ThreeState state = ThreeState.UNSURE;
                if (val instanceof DfaConstValue && (value2 = ((DfaConstValue)val).getValue()) instanceof Boolean) {
                    state = ThreeState.fromBoolean((boolean)((Boolean)value2));
                }
                this.myBooleanCalls.merge(call, state, ThreeState::merge);
            }
        }

        @Override
        protected void processArrayAccess(PsiArrayAccessExpression expression2, boolean alwaysOutOfBounds) {
            this.myOutOfBoundsArrayAccesses.merge(expression2, ThreeState.fromBoolean((boolean)alwaysOutOfBounds), ThreeState::merge);
        }

        @Override
        protected void processMethodReferenceResult(PsiMethodReferenceExpression methodRef, List<? extends MethodContract> contracts2, DfaValue res) {
            if (contracts2.isEmpty() || !contracts2.get(0).isTrivial()) {
                this.myMethodReferenceResults.merge(methodRef, res, (a, b) -> a == b ? a : DfaUnknownValue.getInstance());
            }
        }

        private static boolean hasNonTrivialFailingContracts(MethodCallInstruction instruction) {
            List<MethodContract> contracts2 = instruction.getContracts();
            return !contracts2.isEmpty() && contracts2.stream().anyMatch(contract -> contract.getReturnValue() == MethodContract.ValueConstraint.THROW_EXCEPTION && !contract.isTrivial());
        }

        private static boolean hasNonTrivialBooleanContracts(MethodCallInstruction instruction) {
            if (CustomMethodHandlers.find(instruction) != null) {
                return true;
            }
            List<MethodContract> contracts2 = instruction.getContracts();
            return !contracts2.isEmpty() && contracts2.stream().anyMatch(contract -> (contract.getReturnValue() == MethodContract.ValueConstraint.FALSE_VALUE || contract.getReturnValue() == MethodContract.ValueConstraint.TRUE_VALUE) && !contract.isTrivial());
        }

        @Override
        protected boolean checkNotNullable(DfaMemoryState state, DfaValue value2, NullabilityProblem problem, PsiElement anchor) {
            boolean ok;
            if (problem == NullabilityProblem.nullableReturn && !state.isNotNull(value2)) {
                this.myAlwaysReturnsNotNull = false;
            }
            if (!(ok = super.checkNotNullable(state, value2, problem, anchor)) && anchor != null) {
                if (!(problem != NullabilityProblem.callNPE || anchor instanceof PsiNewExpression || anchor instanceof PsiMethodReferenceExpression || anchor instanceof PsiMethodCallExpression)) {
                    throw new IllegalArgumentException("Invalid anchor for callNPE problem: " + anchor);
                }
                this.myProblems.putValue((Object)problem, (Object)anchor);
            }
            Pair key2 = Pair.create((Object)((Object)problem), (Object)anchor);
            StateInfo info = this.myStateInfos.computeIfAbsent((Pair<NullabilityProblem, PsiElement>)key2, k -> new StateInfo());
            if (state.isEphemeral() && !ok) {
                info.ephemeralNpe = true;
            } else if (!state.isEphemeral()) {
                if (ok) {
                    info.normalOk = true;
                } else {
                    info.normalNpe = true;
                }
            }
            return ok;
        }

        private static class StateInfo {
            boolean ephemeralNpe;
            boolean normalNpe;
            boolean normalOk;

            private StateInfo() {
            }
        }
    }
}

