/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.ExternalAnnotationsManagerImpl;
import com.intellij.codeInsight.InferredAnnotationsManagerImpl;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.dataFlow.ContractInspection;
import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.IncorrectOperationException;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditContractIntention
extends BaseIntentionAction
implements LowPriorityAction {
    private static final String ourPrompt = "<html>Please specify the contract text<p>Example: <code>_, null -> false</code><br><small>See intention action description for more details</small></html>";

    @NotNull
    public String getFamilyName() {
        if ("Edit method contract" == null) {
            EditContractIntention.$$$reportNull$$$0(0);
        }
        return "Edit method contract";
    }

    @Nullable
    private static PsiMethod getTargetMethod(@NotNull Project project2, Editor editor, PsiFile file2) {
        PsiModifierListOwner owner2;
        if (project2 == null) {
            EditContractIntention.$$$reportNull$$$0(1);
        }
        if ((owner2 = AddAnnotationPsiFix.getContainer(file2, editor.getCaretModel().getOffset())) instanceof PsiMethod && ExternalAnnotationsManagerImpl.areExternalAnnotationsApplicable(owner2)) {
            PsiElement original = owner2.getOriginalElement();
            return original instanceof PsiMethod ? (PsiMethod)original : (PsiMethod)owner2;
        }
        return null;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        PsiMethod method;
        if (project2 == null) {
            EditContractIntention.$$$reportNull$$$0(2);
        }
        if ((method = EditContractIntention.getTargetMethod(project2, editor, file2)) != null) {
            boolean hasContract = ControlFlowAnalyzer.findContractAnnotation(method) != null;
            this.setText(hasContract ? "Edit method contract of '" + method.getName() + "'" : "Add method contract to '" + method.getName() + "'");
            return true;
        }
        return false;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            EditContractIntention.$$$reportNull$$$0(3);
        }
        final PsiMethod method = EditContractIntention.getTargetMethod(project2, editor, file2);
        assert (method != null);
        Contract existingAnno = (Contract)AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)method, Contract.class);
        String oldContract = existingAnno == null ? null : existingAnno.value();
        boolean oldPure = existingAnno != null && existingAnno.pure();
        final JBTextField contractText = new JBTextField(oldContract);
        JCheckBox pureCB = EditContractIntention.createPureCheckBox(oldPure);
        final DialogBuilder builder = EditContractIntention.createDialog(project2, contractText, pureCB);
        contractText.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                String error = EditContractIntention.getErrorMessage(contractText.getText(), method);
                builder.setOkActionEnabled(error == null);
                builder.setErrorText(error, (JComponent)contractText);
            }
        });
        if (builder.showAndGet()) {
            EditContractIntention.updateContract(method, contractText.getText(), pureCB.isSelected());
        }
    }

    private static DialogBuilder createDialog(@NotNull Project project2, JBTextField contractText, JCheckBox pureCB) {
        if (project2 == null) {
            EditContractIntention.$$$reportNull$$$0(4);
        }
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)Messages.configureMessagePaneUi((JTextPane)new JTextPane(), (String)ourPrompt), "North");
        panel2.add((Component)contractText, "Center");
        panel2.add((Component)pureCB, "South");
        DialogBuilder builder = new DialogBuilder(project2).setNorthPanel((JComponent)panel2).title("Edit Method Contract");
        builder.setPreferredFocusComponent((JComponent)contractText);
        return builder;
    }

    private static JCheckBox createPureCheckBox(boolean selected) {
        NonFocusableCheckBox pureCB = new NonFocusableCheckBox("Method is pure (has no side effects)");
        pureCB.setMnemonic('p');
        pureCB.setSelected(selected);
        return pureCB;
    }

    private static void updateContract(PsiMethod method, String contract, boolean pure) {
        Project project2 = method.getProject();
        ExternalAnnotationsManager manager = ExternalAnnotationsManager.getInstance((Project)project2);
        manager.deannotate((PsiModifierListOwner)method, ControlFlowAnalyzer.ORG_JETBRAINS_ANNOTATIONS_CONTRACT);
        PsiAnnotation mockAnno = InferredAnnotationsManagerImpl.createContractAnnotation(project2, pure, contract);
        if (mockAnno != null) {
            try {
                manager.annotateExternally((PsiModifierListOwner)method, ControlFlowAnalyzer.ORG_JETBRAINS_ANNOTATIONS_CONTRACT, method.getContainingFile(), mockAnno.getParameterList().getAttributes());
            }
            catch (ExternalAnnotationsManager.CanceledConfigurationException canceledConfigurationException) {
                // empty catch block
            }
        }
        DaemonCodeAnalyzer.getInstance((Project)project2).restart();
    }

    @Nullable
    private static String getErrorMessage(String contract, PsiMethod method) {
        return StringUtil.isEmpty((String)contract) ? null : ContractInspection.checkContract(method, contract);
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/EditContractIntention";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/EditContractIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTargetMethod";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createDialog";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

