/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.PsiMethodImpl;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InferenceFromSourceUtil {
    static boolean shouldInferFromSource(@NotNull PsiMethodImpl method) {
        if (method == null) {
            InferenceFromSourceUtil.$$$reportNull$$$0(0);
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)method, () -> {
            if (method == null) {
                InferenceFromSourceUtil.$$$reportNull$$$0(5);
            }
            return CachedValueProvider.Result.create((Object)InferenceFromSourceUtil.calcShouldInferFromSource(method), (Object[])new Object[]{method, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        });
    }

    private static boolean calcShouldInferFromSource(@NotNull PsiMethod method) {
        if (method == null) {
            InferenceFromSourceUtil.$$$reportNull$$$0(1);
        }
        if (InferenceFromSourceUtil.isLibraryCode(method) || method.hasModifierProperty("abstract") || PsiUtil.canBeOverridden((PsiMethod)method)) {
            return false;
        }
        if (method.hasModifierProperty("static")) {
            return true;
        }
        return !InferenceFromSourceUtil.isUnusedInAnonymousClass(method);
    }

    private static boolean isUnusedInAnonymousClass(@NotNull PsiMethod method) {
        PsiClass containingClass;
        if (method == null) {
            InferenceFromSourceUtil.$$$reportNull$$$0(2);
        }
        if (!((containingClass = method.getContainingClass()) instanceof PsiAnonymousClass)) {
            return false;
        }
        if (containingClass.getParent() instanceof PsiNewExpression && containingClass.getParent().getParent() instanceof PsiVariable && !method.getHierarchicalMethodSignature().getSuperSignatures().isEmpty()) {
            return false;
        }
        return MethodReferencesSearch.search((PsiMethod)method, (SearchScope)new LocalSearchScope((PsiElement)containingClass), (boolean)false).findFirst() == null;
    }

    private static boolean isLibraryCode(@NotNull PsiMethod method) {
        if (method == null) {
            InferenceFromSourceUtil.$$$reportNull$$$0(3);
        }
        if (method instanceof PsiCompiledElement) {
            return true;
        }
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)method);
        return virtualFile != null && FileIndexFacade.getInstance((Project)method.getProject()).isInLibrarySource(virtualFile);
    }

    static boolean isReturnTypeCompatible(@Nullable PsiType returnType, @NotNull MethodContract.ValueConstraint returnValue) {
        if (returnValue == null) {
            InferenceFromSourceUtil.$$$reportNull$$$0(4);
        }
        if (returnValue == MethodContract.ValueConstraint.ANY_VALUE || returnValue == MethodContract.ValueConstraint.THROW_EXCEPTION) {
            return true;
        }
        if (PsiType.VOID.equals((Object)returnType)) {
            return false;
        }
        if (PsiType.BOOLEAN.equals((Object)returnType)) {
            return returnValue == MethodContract.ValueConstraint.TRUE_VALUE || returnValue == MethodContract.ValueConstraint.FALSE_VALUE;
        }
        if (!(returnType instanceof PsiPrimitiveType)) {
            return returnValue == MethodContract.ValueConstraint.NULL_VALUE || returnValue == MethodContract.ValueConstraint.NOT_NULL_VALUE;
        }
        return false;
    }

    static boolean suppressNullable(PsiMethod method) {
        if (method.getParameterList().getParametersCount() == 0) {
            return false;
        }
        for (StandardMethodContract contract : ControlFlowAnalyzer.getMethodContracts(method)) {
            if (contract.returnValue != MethodContract.ValueConstraint.NULL_VALUE) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnValue";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/dataFlow/InferenceFromSourceUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldInferFromSource";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "calcShouldInferFromSource";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isUnusedInAnonymousClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isLibraryCode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isReturnTypeCompatible";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$shouldInferFromSource$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

