/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.InspectionManagerBase;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.ProblemDescriptorImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.ContentUI;
import com.intellij.ui.content.TabbedPaneContentUI;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionManagerEx
extends InspectionManagerBase {
    private final NotNullLazyValue<ContentManager> myContentManager;
    private final Set<GlobalInspectionContextImpl> myRunningContexts = new HashSet<GlobalInspectionContextImpl>();
    private GlobalInspectionContextImpl myGlobalInspectionContext;

    public InspectionManagerEx(final Project project2) {
        super(project2);
        this.myContentManager = ApplicationManager.getApplication().isHeadlessEnvironment() ? new NotNullLazyValue<ContentManager>(){

            @NotNull
            protected ContentManager compute() {
                ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project2);
                toolWindowManager.registerToolWindow(ToolWindowId.INSPECTION, true, ToolWindowAnchor.BOTTOM, (Disposable)project2);
                ContentManager contentManager = ContentFactory.SERVICE.getInstance().createContentManager((ContentUI)new TabbedPaneContentUI(), true, project2);
                if (contentManager == null) {
                    1.$$$reportNull$$$0(0);
                }
                return contentManager;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionManagerEx$1", "compute"));
            }
        } : new NotNullLazyValue<ContentManager>(){

            @NotNull
            protected ContentManager compute() {
                ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project2);
                ToolWindow toolWindow = toolWindowManager.registerToolWindow(ToolWindowId.INSPECTION, true, ToolWindowAnchor.BOTTOM, (Disposable)project2);
                final ContentManager contentManager = toolWindow.getContentManager();
                toolWindow.setIcon(AllIcons.Toolwindows.ToolWindowInspection);
                new ContentManagerWatcher(toolWindow, contentManager);
                contentManager.addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){
                    private static final String PREFIX = "of ";

                    public void contentAdded(ContentManagerEvent event) {
                        this.handleContentSizeChanged();
                    }

                    public void contentRemoved(ContentManagerEvent event) {
                        this.handleContentSizeChanged();
                    }

                    private void handleContentSizeChanged() {
                        int count = contentManager.getContentCount();
                        if (count == 1) {
                            Content content = contentManager.getContent(0);
                            String displayName = content.getDisplayName();
                            if (!content.getDisplayName().startsWith(PREFIX)) {
                                content.setDisplayName(PREFIX + displayName);
                            }
                        } else if (count > 1) {
                            for (Content content : contentManager.getContents()) {
                                if (!content.getDisplayName().startsWith(PREFIX)) continue;
                                content.setDisplayName(content.getDisplayName().substring(PREFIX.length()));
                            }
                        }
                    }
                });
                ContentManager contentManager2 = contentManager;
                if (contentManager2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return contentManager2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionManagerEx$2", "compute"));
            }
        };
    }

    @NotNull
    public ProblemDescriptor createProblemDescriptor(@NotNull PsiElement psiElement, @NotNull String descriptionTemplate, @NotNull ProblemHighlightType highlightType, @Nullable HintAction hintAction, boolean onTheFly, LocalQuickFix ... fixes) {
        if (psiElement == null) {
            InspectionManagerEx.$$$reportNull$$$0(0);
        }
        if (descriptionTemplate == null) {
            InspectionManagerEx.$$$reportNull$$$0(1);
        }
        if (highlightType == null) {
            InspectionManagerEx.$$$reportNull$$$0(2);
        }
        ProblemDescriptorImpl problemDescriptorImpl = new ProblemDescriptorImpl(psiElement, psiElement, descriptionTemplate, fixes, highlightType, false, null, hintAction, onTheFly);
        if (problemDescriptorImpl == null) {
            InspectionManagerEx.$$$reportNull$$$0(3);
        }
        return problemDescriptorImpl;
    }

    @NotNull
    public GlobalInspectionContextImpl createNewGlobalContext(boolean reuse) {
        GlobalInspectionContextImpl inspectionContext;
        if (reuse) {
            if (this.myGlobalInspectionContext == null) {
                this.myGlobalInspectionContext = inspectionContext = new GlobalInspectionContextImpl(this.getProject(), this.myContentManager);
            } else {
                inspectionContext = this.myGlobalInspectionContext;
            }
        } else {
            inspectionContext = new GlobalInspectionContextImpl(this.getProject(), this.myContentManager);
        }
        this.myRunningContexts.add(inspectionContext);
        GlobalInspectionContextImpl globalInspectionContextImpl = inspectionContext;
        if (globalInspectionContextImpl == null) {
            InspectionManagerEx.$$$reportNull$$$0(4);
        }
        return globalInspectionContextImpl;
    }

    public void setProfile(@NotNull String name2) {
        if (name2 == null) {
            InspectionManagerEx.$$$reportNull$$$0(5);
        }
        this.myCurrentProfileName = name2;
    }

    void closeRunningContext(@NotNull GlobalInspectionContextImpl globalInspectionContext) {
        if (globalInspectionContext == null) {
            InspectionManagerEx.$$$reportNull$$$0(6);
        }
        this.myRunningContexts.remove((Object)globalInspectionContext);
    }

    @NotNull
    public Set<GlobalInspectionContextImpl> getRunningContexts() {
        Set<GlobalInspectionContextImpl> set2 = this.myRunningContexts;
        if (set2 == null) {
            InspectionManagerEx.$$$reportNull$$$0(7);
        }
        return set2;
    }

    @NotNull
    public NotNullLazyValue<ContentManager> getContentManager() {
        NotNullLazyValue<ContentManager> notNullLazyValue = this.myContentManager;
        if (notNullLazyValue == null) {
            InspectionManagerEx.$$$reportNull$$$0(8);
        }
        return notNullLazyValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptionTemplate";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightType";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/InspectionManagerEx";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalInspectionContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/InspectionManagerEx";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createProblemDescriptor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewGlobalContext";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunningContexts";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createProblemDescriptor";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setProfile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "closeRunningContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

