/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.htmlInspections.AddCustomHtmlElementIntentionAction;
import com.intellij.codeInspection.htmlInspections.HtmlUnknownElementInspection;
import com.intellij.codeInspection.htmlInspections.RemoveAttributeIntentionAction;
import com.intellij.codeInspection.htmlInspections.SwitchToHtml5WithHighPriorityAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.text.EditDistance;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class HtmlUnknownAttributeInspectionBase
extends HtmlUnknownElementInspection {
    private static final Key<HtmlUnknownElementInspection> ATTRIBUTE_KEY = Key.create((String)"HtmlUnknownAttribute");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.htmlInspections.HtmlUnknownAttributeInspection");

    public HtmlUnknownAttributeInspectionBase() {
        this("");
    }

    public HtmlUnknownAttributeInspectionBase(String defaultValues) {
        super(defaultValues);
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = XmlBundle.message((String)"html.inspections.unknown.attribute", (Object[])new Object[0]);
        if (string == null) {
            HtmlUnknownAttributeInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("HtmlUnknownAttribute" == null) {
            HtmlUnknownAttributeInspectionBase.$$$reportNull$$$0(1);
        }
        return "HtmlUnknownAttribute";
    }

    @Override
    protected String getCheckboxTitle() {
        return XmlBundle.message((String)"html.inspections.unknown.tag.attribute.checkbox.title", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    protected String getPanelTitle() {
        String string = XmlBundle.message((String)"html.inspections.unknown.tag.attribute.title", (Object[])new Object[0]);
        if (string == null) {
            HtmlUnknownAttributeInspectionBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    protected Logger getLogger() {
        Logger logger = LOG;
        if (logger == null) {
            HtmlUnknownAttributeInspectionBase.$$$reportNull$$$0(3);
        }
        return logger;
    }

    @Override
    protected void checkAttribute(@NotNull XmlAttribute attribute, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        XmlTag tag;
        if (attribute == null) {
            HtmlUnknownAttributeInspectionBase.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            HtmlUnknownAttributeInspectionBase.$$$reportNull$$$0(5);
        }
        if ((tag = attribute.getParent()) instanceof HtmlTag) {
            String name2;
            XmlElementDescriptor elementDescriptor = tag.getDescriptor();
            if (elementDescriptor == null || elementDescriptor instanceof AnyXmlElementDescriptor) {
                return;
            }
            XmlAttributeDescriptor attributeDescriptor = elementDescriptor.getAttributeDescriptor(attribute);
            if (!(attributeDescriptor != null || attribute.isNamespaceDeclaration() || XmlUtil.attributeFromTemplateFramework(name2 = attribute.getName(), tag) || this.isCustomValuesEnabled() && this.isCustomValue(name2))) {
                boolean maySwitchToHtml5 = HtmlUtil.isCustomHtml5Attribute(name2) && !HtmlUtil.hasNonHtml5Doctype((XmlElement)tag);
                ArrayList<LocalQuickFix> quickfixes = new ArrayList<LocalQuickFix>(6);
                quickfixes.add(new AddCustomHtmlElementIntentionAction(ATTRIBUTE_KEY, name2, XmlBundle.message((String)"add.custom.html.attribute", (Object[])new Object[]{name2})));
                quickfixes.add(new RemoveAttributeIntentionAction(name2));
                if (maySwitchToHtml5) {
                    quickfixes.add(new SwitchToHtml5WithHighPriorityAction());
                }
                HtmlUnknownAttributeInspectionBase.addSimilarAttributesQuickFixes(tag, name2, quickfixes);
                HtmlUnknownAttributeInspectionBase.registerProblemOnAttributeName(attribute, XmlErrorMessages.message("attribute.is.not.allowed.here", attribute.getName()), holder, quickfixes.toArray(LocalQuickFix.EMPTY_ARRAY));
            }
        }
    }

    private static void addSimilarAttributesQuickFixes(XmlTag tag, String name2, ArrayList<LocalQuickFix> quickfixes) {
        XmlElementDescriptor descriptor2 = tag.getDescriptor();
        if (descriptor2 == null) {
            return;
        }
        XmlAttributeDescriptor[] descriptors = descriptor2.getAttributesDescriptors(tag);
        int initialSize = quickfixes.size();
        for (XmlAttributeDescriptor attr : descriptors) {
            if (EditDistance.optimalAlignment((CharSequence)name2, (CharSequence)attr.getName(), (boolean)false) <= 1) {
                quickfixes.add(new RenameAttributeFix(attr));
            }
            if (quickfixes.size() >= initialSize + 3) break;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/htmlInspections/HtmlUnknownAttributeInspectionBase";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPanelTitle";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/htmlInspections/HtmlUnknownAttributeInspectionBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkAttribute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RenameAttributeFix
    implements LocalQuickFix,
    HighPriorityAction {
        private String name;

        public RenameAttributeFix(XmlAttributeDescriptor attr) {
            this.name = attr.getName();
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Rename attribute" == null) {
                RenameAttributeFix.$$$reportNull$$$0(0);
            }
            return "Rename attribute";
        }

        @Nls
        @NotNull
        public String getName() {
            String string = "Rename attribute to " + this.name;
            if (string == null) {
                RenameAttributeFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            XmlAttribute attribute;
            if (project2 == null) {
                RenameAttributeFix.$$$reportNull$$$0(2);
            }
            if (descriptor2 == null) {
                RenameAttributeFix.$$$reportNull$$$0(3);
            }
            if ((attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)descriptor2.getPsiElement(), XmlAttribute.class)) == null) {
                return;
            }
            attribute.setName(this.name);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/htmlInspections/HtmlUnknownAttributeInspectionBase$RenameAttributeFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/htmlInspections/HtmlUnknownAttributeInspectionBase$RenameAttributeFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

