/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.javaDoc;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.javaDoc.JavadocHtmlLintAnnotator;
import com.intellij.codeInspection.javaDoc.JavadocHtmlLintInspection;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PsiTreeUtil;
import com.sun.tools.doclint.DocLint;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0003678B\u0005\u00a2\u0006\u0002\u0010\u0004J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\u00032\u0006\u0010!\u001a\u00020\u0002H\u0016J\u0018\u0010\"\u001a\u00020#2\u0006\u0010\u0016\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\b\u0010'\u001a\u00020\nH\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u0010*\u001a\u00020)2\b\u0010+\u001a\u0004\u0018\u00010#H\u0002J\u001c\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\n0-H\u0002J\u0010\u00100\u001a\u00020\u00152\u0006\u00101\u001a\u000202H\u0002J \u00103\u001a\u0002042\u0006\u0010\u0016\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u00105\u001a\u00020\u001dH\u0002R\u001c\u0010\u0005\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/intellij/codeInspection/javaDoc/JavadocHtmlLintAnnotator;", "Lcom/intellij/lang/annotation/ExternalAnnotator;", "Lcom/intellij/codeInspection/javaDoc/JavadocHtmlLintAnnotator$Info;", "Lcom/intellij/codeInspection/javaDoc/JavadocHtmlLintAnnotator$Result;", "()V", "key", "Lkotlin/Lazy;", "Lcom/intellij/codeInsight/daemon/HighlightDisplayKey;", "kotlin.jvm.PlatformType", "lintOptions", "", "lintPattern", "Ljava/util/regex/Pattern;", "adjust", "Lcom/intellij/openapi/util/TextRange;", "element", "Lcom/intellij/psi/PsiElement;", "text", "offset", "", "apply", "", "file", "Lcom/intellij/psi/PsiFile;", "annotationResult", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "collectInformation", "createTempFile", "Ljava/io/File;", "bytes", "", "doAnnotate", "collectedInfo", "findJdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "getPairedBatchInspectionShortName", "isJava8SourceFile", "", "isJdk8", "sdk", "parse", "", "Lcom/intellij/codeInspection/javaDoc/JavadocHtmlLintAnnotator$Anno;", "lines", "registerFix", "annotation", "Lcom/intellij/lang/annotation/Annotation;", "toolCommand", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "copy", "Anno", "Info", "Result", "java-impl"})
public final class JavadocHtmlLintAnnotator
extends ExternalAnnotator<Info, Result> {
    private final Lazy<HighlightDisplayKey> key = LazyKt.lazy((Function0)key.1.INSTANCE);
    private final String lintOptions = "-Xmsgs:html/private,accessibility/private";
    private final Pattern lintPattern;

    @NotNull
    public String getPairedBatchInspectionShortName() {
        return JavadocHtmlLintInspection.Companion.getSHORT_NAME();
    }

    @Nullable
    public Info collectInformation(@NotNull PsiFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return (Info)ApplicationManager.getApplication().runReadAction(new Computable<T>(this, file2){
            final /* synthetic */ JavadocHtmlLintAnnotator this$0;
            final /* synthetic */ PsiFile $file$inlined;
            {
                this.this$0 = javadocHtmlLintAnnotator;
                this.$file$inlined = psiFile;
            }

            public final T compute() {
                return (T)(JavadocHtmlLintAnnotator.access$isJava8SourceFile(this.this$0, this.$file$inlined) && StringsKt.contains$default((CharSequence)this.$file$inlined.getText(), (CharSequence)"/**", (boolean)false, (int)2, null) ? new Info(this.$file$inlined) : null);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Result doAnnotate(@NotNull Info collectedInfo) {
        Intrinsics.checkParameterIsNotNull((Object)collectedInfo, (String)"collectedInfo");
        String text2 = (String)ApplicationManager.getApplication().runReadAction(new Computable<T>(collectedInfo){
            final /* synthetic */ Info $collectedInfo$inlined;
            {
                this.$collectedInfo$inlined = info;
            }

            public final T compute() {
                return (T)(this.$collectedInfo$inlined.getFile().isValid() ? this.$collectedInfo$inlined.getFile().getText() : null);
            }
        });
        if (text2 == null) {
            return null;
        }
        VirtualFile virtualFile = collectedInfo.getFile().getVirtualFile();
        if (virtualFile == null) {
            Intrinsics.throwNpe();
        }
        VirtualFile file2 = virtualFile;
        String string = text2;
        Charset charset = file2.getCharset();
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"file.charset");
        Charset charset2 = charset;
        JavadocHtmlLintAnnotator javadocHtmlLintAnnotator = this;
        byte[] byArray = string.getBytes(charset2);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        File copy = javadocHtmlLintAnnotator.createTempFile(byArray2);
        try {
            Project project2 = collectedInfo.getFile().getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"collectedInfo.file.project");
            GeneralCommandLine command = this.toolCommand(file2, project2, copy);
            ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)command);
            if (output.getExitCode() != 0) {
                Logger log = Logger.getInstance(JavadocHtmlLintAnnotator.class);
                if (log.isDebugEnabled()) {
                    log.debug("" + file2 + ": " + output.getExitCode() + ", " + output.getStderr());
                }
                Result result2 = null;
                return result2;
            }
            List list2 = output.getStdoutLines();
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"output.stdoutLines");
            List<Anno> annotations2 = this.parse(list2);
            Object object = annotations2;
            object = !object.isEmpty() ? new Result(annotations2) : null;
            return object;
        }
        catch (Exception e) {
            Logger log = Logger.getInstance(JavadocHtmlLintAnnotator.class);
            log.debug(file2.getPath(), (Throwable)e);
            Result result3 = null;
            return result3;
        }
        finally {
            FileUtil.delete((File)copy);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void apply(@NotNull PsiFile file2, @NotNull Result annotationResult, @NotNull AnnotationHolder holder) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)annotationResult, (String)"annotationResult");
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        String text2 = file2.getText();
        CharSequence object2 = text2;
        List initial$iv = CollectionsKt.mutableListOf((Object[])new Integer[]{0});
        int index$iv = 0;
        List accumulator$iv = initial$iv;
        CharSequence charSequence = object2;
        for (int i = 0; i < charSequence.length(); ++i) {
            void offsets;
            void c;
            char element$iv = charSequence.charAt(i);
            int n = index$iv++;
            char c2 = element$iv;
            List list2 = accumulator$iv;
            int i2 = n;
            if (c == 10) {
                Collection collection = (Collection)offsets;
                Integer n2 = i2 + 1;
                collection.add(n2);
            }
            accumulator$iv = offsets;
        }
        List offsets = accumulator$iv;
        for (Anno anno : annotationResult.getAnnotations()) {
            Annotation annotation;
            int offset;
            PsiElement element;
            int row = anno.component1();
            int col = anno.component2();
            boolean error = anno.component3();
            String message2 = anno.component4();
            if (row >= offsets.size() || (element = file2.findElementAt(offset = ((Number)offsets.get(row)).intValue() + col)) == null || PsiTreeUtil.getParentOfType((PsiElement)element, PsiDocComment.class) == null) continue;
            String string = text2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"text");
            TextRange range = this.adjust(element, string, offset);
            String description = StringUtil.capitalize((String)message2);
            Annotation annotation2 = annotation = error ? holder.createErrorAnnotation(range, description) : holder.createWarningAnnotation(range, description);
            Intrinsics.checkExpressionValueIsNotNull((Object)annotation2, (String)"annotation");
            this.registerFix(annotation2);
        }
    }

    private final boolean isJava8SourceFile(PsiFile file2) {
        return file2.isValid() && file2 instanceof PsiJavaFile && ((PsiJavaFile)file2).getLanguageLevel().isAtLeast(LanguageLevel.JDK_1_8) && ((PsiJavaFile)file2).getVirtualFile() != null && ProjectFileIndex.SERVICE.getInstance((Project)((PsiJavaFile)file2).getProject()).isInSourceContent(((PsiJavaFile)file2).getVirtualFile());
    }

    private final File createTempFile(byte[] bytes) {
        File tempFile = FileUtil.createTempFile((File)new File(PathManager.getTempPath()), (String)"javadocHtmlLint", (String)".java");
        FilesKt.writeBytes((File)tempFile, (byte[])bytes);
        File file2 = tempFile;
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"tempFile");
        return file2;
    }

    private final GeneralCommandLine toolCommand(VirtualFile file2, Project project2, File copy) {
        File toolsJar;
        SimpleJavaParameters parameters2 = new SimpleJavaParameters();
        Sdk jdk = this.findJdk(file2, project2);
        parameters2.setJdk(jdk);
        if (!JavaSdkUtil.isJdkAtLeast(jdk, JavaSdkVersion.JDK_1_9) && (toolsJar = FileUtil.findFirstThatExist((String[])new String[]{"" + jdk.getHomePath() + "/lib/tools.jar", "" + jdk.getHomePath() + "/../lib/tools.jar"})) != null) {
            parameters2.getClassPath().add(toolsJar.getPath());
        }
        parameters2.setCharset(file2.getCharset());
        parameters2.getVMParametersList().addProperty("user.language", "en");
        parameters2.setMainClass(Reflection.getOrCreateKotlinClass(DocLint.class).getQualifiedName());
        parameters2.getProgramParametersList().add(this.lintOptions);
        parameters2.getProgramParametersList().add(copy.getPath());
        GeneralCommandLine generalCommandLine = parameters2.toCommandLine();
        Intrinsics.checkExpressionValueIsNotNull((Object)generalCommandLine, (String)"parameters.toCommandLine()");
        return generalCommandLine;
    }

    private final Sdk findJdk(VirtualFile file2, Project project2) {
        Sdk sdk;
        ProjectRootManager rootManager = ProjectRootManager.getInstance((Project)project2);
        Module module2 = rootManager.getFileIndex().getModuleForFile(file2);
        if (module2 != null && this.isJdk8(sdk = ModuleRootManager.getInstance((Module)module2).getSdk())) {
            Sdk sdk2 = sdk;
            if (sdk2 == null) {
                Intrinsics.throwNpe();
            }
            return sdk2;
        }
        sdk = rootManager.getProjectSdk();
        if (this.isJdk8(sdk)) {
            Sdk sdk3 = sdk;
            if (sdk3 == null) {
                Intrinsics.throwNpe();
            }
            return sdk3;
        }
        Sdk sdk4 = JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk();
        Intrinsics.checkExpressionValueIsNotNull((Object)sdk4, (String)"JavaAwareProjectJdkTable\u2026tInstanceEx().internalJdk");
        return sdk4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isJdk8(Sdk sdk) {
        if (sdk == null) return false;
        if (!JavaSdkUtil.isJdkAtLeast(sdk, JavaSdkVersion.JDK_1_8)) return false;
        String string = sdk.getHomePath();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        if (!JdkUtil.checkForJre((String)string)) return false;
        return true;
    }

    private final List<Anno> parse(List<String> lines2) {
        List result2 = new ArrayList();
        Iterator<String> i = lines2.iterator();
        while (i.hasNext()) {
            CharSequence charSequence;
            String line = i.next();
            Matcher matcher = this.lintPattern.matcher(line);
            if (!matcher.matches() || !i.hasNext() || (charSequence = (CharSequence)i.next()).length() == 0 || !i.hasNext()) continue;
            String string = matcher.group(1);
            int row = Integer.parseInt(string) - 1;
            int col = StringsKt.indexOf$default((CharSequence)i.next(), (char)'^', (int)0, (boolean)false, (int)6, null);
            boolean error = Intrinsics.areEqual((Object)matcher.group(2), (Object)"error");
            String message2 = matcher.group(3);
            Collection collection = result2;
            String string2 = message2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"message");
            Anno anno = new Anno(row, col, error, string2);
            collection.add(anno);
        }
        return result2;
    }

    private final TextRange adjust(PsiElement element, String text2, int offset) {
        TextRange range = element.getTextRange();
        if (text2.charAt(offset) == '<') {
            int right = StringsKt.indexOf$default((CharSequence)text2, (char)'>', (int)offset, (boolean)false, (int)4, null);
            if (right > 0) {
                return new TextRange(offset, Integer.min(right + 1, range.getEndOffset()));
            }
        } else if (text2.charAt(offset) == '&') {
            int right = StringsKt.indexOf$default((CharSequence)text2, (char)';', (int)offset, (boolean)false, (int)4, null);
            if (right > 0) {
                return new TextRange(offset, Integer.min(right + 1, range.getEndOffset()));
            }
        } else {
            int right = text2.charAt(offset);
            if (Character.isLetter((char)right) && !Character.isLetter((char)(right = text2.charAt(offset - 1)))) {
                char c;
                for (right = offset + 1; Character.isLetter(c = text2.charAt(right)) && right <= range.getEndOffset(); ++right) {
                }
                return new TextRange(offset, right);
            }
        }
        TextRange textRange = range;
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"range");
        return textRange;
    }

    private final void registerFix(Annotation annotation) {
        annotation.registerFix((IntentionAction)new EmptyIntentionAction(InspectionsBundle.message((String)"inspection.javadoc.lint.display.name", (Object[])new Object[0])), null, (HighlightDisplayKey)this.key.getValue());
    }

    public JavadocHtmlLintAnnotator() {
        Pattern pattern;
        String string = "^.+:(\\d+):\\s+(error|warning):\\s+(.+)$";
        JavadocHtmlLintAnnotator javadocHtmlLintAnnotator = this;
        int n = 0;
        Pattern pattern2 = Pattern.compile(string, n);
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern2, (String)"java.util.regex.Pattern.compile(this, flags)");
        javadocHtmlLintAnnotator.lintPattern = pattern = pattern2;
    }

    public static final /* synthetic */ boolean access$isJava8SourceFile(JavadocHtmlLintAnnotator $this, @NotNull PsiFile file2) {
        return $this.isJava8SourceFile(file2);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/intellij/codeInspection/javaDoc/JavadocHtmlLintAnnotator$Info;", "", "file", "Lcom/intellij/psi/PsiFile;", "(Lcom/intellij/psi/PsiFile;)V", "getFile", "()Lcom/intellij/psi/PsiFile;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "java-impl"})
    public static final class Info {
        @NotNull
        private final PsiFile file;

        @NotNull
        public final PsiFile getFile() {
            return this.file;
        }

        public Info(@NotNull PsiFile file2) {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            this.file = file2;
        }

        @NotNull
        public final PsiFile component1() {
            return this.file;
        }

        @NotNull
        public final Info copy(@NotNull PsiFile file2) {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            return new Info(file2);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Info copy$default(Info info, PsiFile psiFile, int n, Object object) {
            if ((n & 1) != 0) {
                psiFile = info.file;
            }
            return info.copy(psiFile);
        }

        public String toString() {
            return "Info(file=" + this.file + ")";
        }

        public int hashCode() {
            PsiFile psiFile = this.file;
            return psiFile != null ? psiFile.hashCode() : 0;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Info)) break block3;
                    Info info = (Info)object;
                    if (!Intrinsics.areEqual((Object)this.file, (Object)info.file)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0012\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\bH\u00c6\u0003J1\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00062\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\bH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/intellij/codeInspection/javaDoc/JavadocHtmlLintAnnotator$Anno;", "", "row", "", "col", "error", "", "message", "", "(IIZLjava/lang/String;)V", "getCol", "()I", "getError", "()Z", "getMessage", "()Ljava/lang/String;", "getRow", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "toString", "java-impl"})
    public static final class Anno {
        private final int row;
        private final int col;
        private final boolean error;
        @NotNull
        private final String message;

        public final int getRow() {
            return this.row;
        }

        public final int getCol() {
            return this.col;
        }

        public final boolean getError() {
            return this.error;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        public Anno(int row, int col, boolean error, @NotNull String message2) {
            Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
            this.row = row;
            this.col = col;
            this.error = error;
            this.message = message2;
        }

        public final int component1() {
            return this.row;
        }

        public final int component2() {
            return this.col;
        }

        public final boolean component3() {
            return this.error;
        }

        @NotNull
        public final String component4() {
            return this.message;
        }

        @NotNull
        public final Anno copy(int row, int col, boolean error, @NotNull String message2) {
            Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
            return new Anno(row, col, error, message2);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Anno copy$default(Anno anno, int n, int n2, boolean bl, String string, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = anno.row;
            }
            if ((n3 & 2) != 0) {
                n2 = anno.col;
            }
            if ((n3 & 4) != 0) {
                bl = anno.error;
            }
            if ((n3 & 8) != 0) {
                string = anno.message;
            }
            return anno.copy(n, n2, bl, string);
        }

        public String toString() {
            return "Anno(row=" + this.row + ", col=" + this.col + ", error=" + this.error + ", message=" + this.message + ")";
        }

        public int hashCode() {
            int n = (Integer.hashCode(this.row) * 31 + Integer.hashCode(this.col)) * 31;
            int n2 = this.error ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            String string = this.message;
            return (n + n2) * 31 + (string != null ? string.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Anno)) break block3;
                    Anno anno = (Anno)object;
                    if (!(this.row == anno.row) || !(this.col == anno.col) || !(this.error == anno.error) || !Intrinsics.areEqual((Object)this.message, (Object)anno.message)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/codeInspection/javaDoc/JavadocHtmlLintAnnotator$Result;", "", "annotations", "", "Lcom/intellij/codeInspection/javaDoc/JavadocHtmlLintAnnotator$Anno;", "(Ljava/util/List;)V", "getAnnotations", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "java-impl"})
    public static final class Result {
        @NotNull
        private final List<Anno> annotations;

        @NotNull
        public final List<Anno> getAnnotations() {
            return this.annotations;
        }

        public Result(@NotNull List<Anno> annotations2) {
            Intrinsics.checkParameterIsNotNull(annotations2, (String)"annotations");
            this.annotations = annotations2;
        }

        @NotNull
        public final List<Anno> component1() {
            return this.annotations;
        }

        @NotNull
        public final Result copy(@NotNull List<Anno> annotations2) {
            Intrinsics.checkParameterIsNotNull(annotations2, (String)"annotations");
            return new Result(annotations2);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Result copy$default(Result result2, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = result2.annotations;
            }
            return result2.copy(list2);
        }

        public String toString() {
            return "Result(annotations=" + this.annotations + ")";
        }

        public int hashCode() {
            List<Anno> list2 = this.annotations;
            return list2 != null ? ((Object)list2).hashCode() : 0;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Result)) break block3;
                    Result result2 = (Result)object;
                    if (!Intrinsics.areEqual(this.annotations, result2.annotations)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

