/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.naming;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.naming.NamingConventionBean;
import com.intellij.psi.PsiNameIdentifierOwner;

public abstract class NamingConvention<T extends PsiNameIdentifierOwner> {
    public abstract boolean isApplicable(T var1);

    public abstract String getElementDescription();

    public abstract String getShortName();

    public abstract NamingConventionBean createDefaultBean();

    public boolean isEnabledByDefault() {
        return false;
    }

    public String createErrorMessage(String name2, NamingConventionBean bean) {
        int length = name2.length();
        if (length < bean.m_minLength) {
            return InspectionsBundle.message((String)"naming.convention.problem.descriptor.short", (Object[])new Object[]{this.getElementDescription(), length, bean.m_minLength});
        }
        if (bean.m_maxLength > 0 && length > bean.m_maxLength) {
            return InspectionsBundle.message((String)"naming.convention.problem.descriptor.long", (Object[])new Object[]{this.getElementDescription(), length, bean.m_maxLength});
        }
        return InspectionsBundle.message((String)"naming.convention.problem.descriptor.regex.mismatch", (Object[])new Object[]{this.getElementDescription(), bean.m_regex});
    }

    public boolean isValid(T member, NamingConventionBean bean) {
        String name2 = member.getName();
        return name2 != null && bean.isValid(name2);
    }
}

