/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.sillyAssignment;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.sillyAssignment.SillyAssignmentInspectionBase;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class SillyAssignmentInspection
extends SillyAssignmentInspectionBase {
    @Override
    protected LocalQuickFix createRemoveAssignmentFix(PsiReferenceExpression expression2) {
        PsiVariable variable;
        PsiElement parent = expression2.getParent();
        if (parent instanceof PsiVariable && (variable = (PsiVariable)parent).hasModifierProperty("final")) {
            return null;
        }
        return new RemoveSillyAssignmentFix();
    }

    private static class RemoveSillyAssignmentFix
    implements LocalQuickFix {
        private RemoveSillyAssignmentFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"assignment.to.itself.quickfix.name", (Object[])new Object[0]);
            if (string == null) {
                RemoveSillyAssignmentFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            PsiElement element;
            if (project2 == null) {
                RemoveSillyAssignmentFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                RemoveSillyAssignmentFix.$$$reportNull$$$0(2);
            }
            if (!((element = descriptor2.getPsiElement()) instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)element.getParent());
            if (parent instanceof PsiVariable) {
                element.delete();
            }
            if (!(parent instanceof PsiAssignmentExpression)) {
                return;
            }
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
            PsiExpression lhs = assignmentExpression.getLExpression();
            PsiExpression rhs = assignmentExpression.getRExpression();
            if (PsiTreeUtil.isAncestor((PsiElement)lhs, (PsiElement)element, (boolean)false)) {
                if (rhs != null) {
                    assignmentExpression.replace((PsiElement)rhs);
                } else {
                    assignmentExpression.delete();
                }
            } else {
                PsiElement grandParent = assignmentExpression.getParent();
                if (grandParent instanceof PsiExpressionStatement) {
                    grandParent.delete();
                } else {
                    assignmentExpression.replace(element);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/sillyAssignment/SillyAssignmentInspection$RemoveSillyAssignmentFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/sillyAssignment/SillyAssignmentInspection$RemoveSillyAssignmentFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

