/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.SuppressableInspectionTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.WeakStringInterner;
import com.intellij.xml.util.XmlStringUtil;
import gnu.trove.TObjectIntHashMap;
import java.util.function.IntSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProblemDescriptionNode
extends SuppressableInspectionTreeNode {
    private final CommonProblemDescriptor myDescriptor;
    private final HighlightDisplayLevel myLevel;
    protected final int myLineNumber;
    protected final RefEntity myElement;
    private static final WeakStringInterner NAME_INTERNER = new WeakStringInterner();

    public ProblemDescriptionNode(RefEntity element, CommonProblemDescriptor descriptor2, @NotNull InspectionToolPresentation presentation) {
        if (presentation == null) {
            ProblemDescriptionNode.$$$reportNull$$$0(0);
        }
        this(element, descriptor2, presentation, true, null);
    }

    protected ProblemDescriptionNode(@Nullable RefEntity element, CommonProblemDescriptor descriptor2, @NotNull InspectionToolPresentation presentation, boolean doInit, @Nullable IntSupplier lineNumberCounter) {
        if (presentation == null) {
            ProblemDescriptionNode.$$$reportNull$$$0(1);
        }
        super((Object)descriptor2, presentation);
        this.myElement = element;
        this.myDescriptor = descriptor2;
        InspectionProfileImpl profile2 = presentation.getContext().getCurrentProfile();
        String shortName = presentation.getToolWrapper().getShortName();
        HighlightDisplayLevel highlightDisplayLevel = this.myLevel = descriptor2 instanceof ProblemDescriptor ? profile2.getErrorLevel(HighlightDisplayKey.find((String)shortName), ((ProblemDescriptor)descriptor2).getStartElement()) : profile2.getTools(shortName, presentation.getContext().getProject()).getLevel();
        if (doInit) {
            this.init(presentation.getContext().getProject());
        }
        this.myLineNumber = this.myDescriptor instanceof ProblemDescriptor ? ((ProblemDescriptor)this.myDescriptor).getLineNumber() : (lineNumberCounter == null ? -1 : lineNumberCounter.getAsInt());
    }

    @Override
    public final boolean isAlreadySuppressedFromView() {
        return this.myDescriptor != null && this.getPresentation().isSuppressed(this.myDescriptor);
    }

    public int getLineNumber() {
        return this.myLineNumber;
    }

    @Override
    public boolean canSuppress() {
        return super.canSuppress() && !this.isQuickFixAppliedFromView();
    }

    @NotNull
    public InspectionToolWrapper getToolWrapper() {
        InspectionToolWrapper inspectionToolWrapper = this.getPresentation().getToolWrapper();
        if (inspectionToolWrapper == null) {
            ProblemDescriptionNode.$$$reportNull$$$0(2);
        }
        return inspectionToolWrapper;
    }

    @Override
    @Nullable
    public RefEntity getElement() {
        return this.myElement;
    }

    @Override
    @Nullable
    public CommonProblemDescriptor getDescriptor() {
        return this.myDescriptor;
    }

    @Override
    public void excludeElement() {
        CommonProblemDescriptor descriptor2 = this.getDescriptor();
        if (descriptor2 != null) {
            this.getPresentation().exclude(descriptor2);
        }
    }

    @Override
    public void amnestyElement() {
        CommonProblemDescriptor descriptor2 = this.getDescriptor();
        if (descriptor2 != null) {
            this.getPresentation().amnesty(descriptor2);
        }
    }

    @Override
    protected void visitProblemSeverities(TObjectIntHashMap<HighlightDisplayLevel> counter) {
        if (this.isValid() && !this.isExcluded() && !this.isQuickFixAppliedFromView() && !this.isAlreadySuppressedFromView()) {
            counter.put((Object)this.myLevel, counter.get((Object)this.myLevel) + 1);
        }
    }

    @Override
    protected boolean calculateIsValid() {
        if (this.myDescriptor == null) {
            return false;
        }
        if (this.myElement == null || !this.myElement.isValid()) {
            return false;
        }
        if (this.myDescriptor instanceof ProblemDescriptor) {
            PsiElement psiElement = ((ProblemDescriptor)this.myDescriptor).getPsiElement();
            return psiElement != null && psiElement.isValid();
        }
        return true;
    }

    @Override
    protected void dropCache(Project project2) {
        if (!this.isQuickFixAppliedFromView()) {
            super.dropCache(project2);
        }
    }

    @Override
    public boolean isExcluded() {
        return this.getPresentation().isExcluded(this.getDescriptor());
    }

    @Override
    @NotNull
    protected String calculatePresentableName() {
        CommonProblemDescriptor descriptor2 = this.getDescriptor();
        if (descriptor2 == null) {
            if ("" == null) {
                ProblemDescriptionNode.$$$reportNull$$$0(3);
            }
            return "";
        }
        PsiElement element = descriptor2 instanceof ProblemDescriptor ? ((ProblemDescriptor)descriptor2).getPsiElement() : null;
        String string = NAME_INTERNER.intern(XmlStringUtil.stripHtml((String)ProblemDescriptorUtil.renderDescriptionMessage(descriptor2, element, 4)));
        if (string == null) {
            ProblemDescriptionNode.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public boolean isQuickFixAppliedFromView() {
        return this.myDescriptor != null && this.getPresentation().isProblemResolved(this.myDescriptor) && !this.isAlreadySuppressedFromView();
    }

    @Override
    @Nullable
    public String getTailText() {
        if (this.isQuickFixAppliedFromView()) {
            return "";
        }
        String text2 = super.getTailText();
        return text2 == null ? "" : text2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ui/ProblemDescriptionNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ui/ProblemDescriptionNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWrapper";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "calculatePresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

