/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui.util;

import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiFunction;

public abstract class SynchronizedBidiMultiMap<K, V> {
    private final Map<K, V[]> myKey2Values = new THashMap();
    private final Map<V, K> myValue2Keys = new THashMap();

    public synchronized Collection<K> keys() {
        return new ArrayList<K>(this.myKey2Values.keySet());
    }

    public synchronized boolean containsKey(K key2) {
        return this.myKey2Values.containsKey(key2);
    }

    public synchronized boolean containsValue(V value2) {
        return this.myValue2Keys.containsKey(value2);
    }

    public synchronized K getKeyFor(V value2) {
        return this.myValue2Keys.get(value2);
    }

    public synchronized V[] get(K key2) {
        return this.myKey2Values.get(key2);
    }

    public synchronized V[] getOrDefault(K key2, V[] defaultValue) {
        V[] values = this.get(key2);
        return values == null ? defaultValue : values;
    }

    public synchronized void put(K key2, V ... values) {
        this.myKey2Values.merge(key2, (Object[][])values, (BiFunction<Object[][], Object[][], Object[][]>)((BiFunction<Object[], Object[], Object[]>)this::merge));
        for (V value2 : values) {
            this.myValue2Keys.put(value2, key2);
        }
    }

    public synchronized V[] remove(K key2, V value2) {
        Object[] newValues = this.myKey2Values.computeIfPresent(key2, (k, vs) -> {
            Object[] removed = ArrayUtil.remove((Object[])vs, (Object)value2, this.arrayFactory());
            if (removed.length == 0) {
                return null;
            }
            return removed;
        });
        this.myValue2Keys.remove(value2);
        return newValues;
    }

    public synchronized K removeValue(V value2) {
        K key2 = this.myValue2Keys.get(value2);
        if (key2 != null) {
            this.remove(key2, value2);
        }
        return key2;
    }

    public synchronized V[] remove(K key2) {
        V[] removed = this.myKey2Values.remove(key2);
        if (removed != null) {
            for (V v : removed) {
                this.myValue2Keys.remove(v);
            }
        }
        return removed;
    }

    public synchronized Collection<V> getValues() {
        return this.myValue2Keys.keySet();
    }

    public synchronized boolean isEmpty() {
        return this.myValue2Keys.isEmpty();
    }

    public abstract V[] merge(V[] var1, V[] var2);

    public abstract ArrayFactory<V> arrayFactory();
}

