/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.ExternalCompilerConfigurationStorageKt;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.ModuleManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import com.intellij.openapi.roots.ProjectModelElement;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.util.JdomKt;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ExternalCompilerConfiguration", storages={@Storage(value="compiler.xml")}, externalStorageOnly=true)
@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0002H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0016R@\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010\b@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/compiler/ExternalCompilerConfigurationStorage;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "Lcom/intellij/openapi/roots/ProjectModelElement;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "<set-?>", "", "", "loadedState", "getLoadedState", "()Ljava/util/Map;", "setLoadedState", "(Ljava/util/Map;)V", "getExternalSource", "Lcom/intellij/openapi/roots/ProjectModelExternalSource;", "getState", "loadState", "", "state", "compiler-impl"})
public final class ExternalCompilerConfigurationStorage
implements PersistentStateComponent<Element>,
ProjectModelElement {
    @Nullable
    private Map<String, String> loadedState;
    private final Project project;

    @Nullable
    public final Map<String, String> getLoadedState() {
        return this.loadedState;
    }

    private final void setLoadedState(Map<String, String> map) {
        this.loadedState = map;
    }

    @NotNull
    public Element getState() {
        Map<String, String> map;
        Element e = new Element("state");
        if (!ProjectUtilCore.isExternalStorageEnabled((Project)this.project)) {
            return e;
        }
        CompilerConfiguration compilerConfiguration = CompilerConfigurationImpl.getInstance((Project)this.project);
        if (compilerConfiguration == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.compiler.CompilerConfigurationImpl");
        }
        Map<String, String> map2 = map = ((CompilerConfigurationImpl)compilerConfiguration).getModulesBytecodeTargetMap();
        Intrinsics.checkExpressionValueIsNotNull(map2, (String)"map");
        List<String> moduleNames = ExternalCompilerConfigurationStorageKt.getFilteredModuleNameList(this.project, map2, true);
        Collection collection = moduleNames;
        if (!collection.isEmpty()) {
            ExternalCompilerConfigurationStorageKt.writeBytecodeTarget(moduleNames, map, JdomKt.element((Element)e, (String)"bytecodeTargetLevel"));
        }
        return e;
    }

    public void loadState(@NotNull Element state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        THashMap result2 = new THashMap();
        ExternalCompilerConfigurationStorageKt.readByteTargetLevel(state, (Map)result2);
        this.loadedState = (Map)result2;
    }

    @Nullable
    public ProjectModelExternalSource getExternalSource() {
        ExternalProjectSystemRegistry externalProjectSystemRegistry = ExternalProjectSystemRegistry.getInstance();
        Module[] moduleArray = ModuleManagerImpl.getInstanceImpl(this.project).getModules();
        for (int i = 0; i < moduleArray.length; ++i) {
            ProjectModelExternalSource projectModelExternalSource;
            Module module2 = moduleArray[i];
            ProjectModelExternalSource projectModelExternalSource2 = externalProjectSystemRegistry.getExternalSource(module2);
            if (projectModelExternalSource2 == null) continue;
            ProjectModelExternalSource it = projectModelExternalSource = projectModelExternalSource2;
            return it;
        }
        return null;
    }

    public ExternalCompilerConfigurationStorage(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        this.project = project2;
    }
}

