/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.FileBasedStorage;
import com.intellij.configurationStore.ReloadComponentStoreStatus;
import com.intellij.configurationStore.StateStorageBase;
import com.intellij.configurationStore.StateStorageManager;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.StateStorageManagerKt;
import com.intellij.configurationStore.StorageManagerListener;
import com.intellij.configurationStore.StoreAwareProjectManagerKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.impl.stores.BatchUpdateListener;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileManagerListener;
import com.intellij.openapi.vfs.ex.VirtualFileManagerAdapter;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.SingleAlarm;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBus;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001f\u001a\u00020\u0014H\u0002J\b\u0010 \u001a\u00020\u0011H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/configurationStore/StoreAwareProjectManager;", "Lcom/intellij/openapi/project/impl/ProjectManagerImpl;", "virtualFileManager", "Lcom/intellij/openapi/vfs/VirtualFileManager;", "progressManager", "Lcom/intellij/openapi/progress/ProgressManager;", "(Lcom/intellij/openapi/vfs/VirtualFileManager;Lcom/intellij/openapi/progress/ProgressManager;)V", "changedApplicationFiles", "Ljava/util/LinkedHashSet;", "Lcom/intellij/openapi/components/StateStorage;", "changedFilesAlarm", "Lcom/intellij/util/SingleAlarm;", "reloadBlockCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "restartApplicationOrReloadProjectTask", "Ljava/lang/Runnable;", "blockReloadingProjectOnExternalChanges", "", "flushChangedProjectFileAlarm", "isReloadUnblocked", "", "registerChangedStorage", "storage", "componentManager", "Lcom/intellij/openapi/components/ComponentManager;", "reloadProject", "project", "Lcom/intellij/openapi/project/Project;", "saveChangedProjectFile", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "tryToReloadApplication", "unblockReloadingProjectOnExternalChanges", "configuration-store-impl"})
public final class StoreAwareProjectManager
extends ProjectManagerImpl {
    private final AtomicInteger reloadBlockCount;
    private final LinkedHashSet<StateStorage> changedApplicationFiles;
    private final Runnable restartApplicationOrReloadProjectTask;
    private final SingleAlarm changedFilesAlarm;

    private final boolean isReloadUnblocked() {
        int count = this.reloadBlockCount.get();
        Logger $receiver$iv = ComponentStoreImplKt.getLOG();
        Exception e$iv = null;
        if ($receiver$iv.isDebugEnabled()) {
            Logger logger = $receiver$iv;
            String string = "[RELOAD] myReloadBlockCount = " + count;
            logger.debug(string, (Throwable)e$iv);
        }
        return count == 0;
    }

    @Override
    public void saveChangedProjectFile(@NotNull VirtualFile file2, @NotNull Project project2) {
        block3: {
            FileBasedStorage fileBasedStorage;
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            IComponentStore iComponentStore = ServiceKt.getStateStore((ComponentManager)project2);
            if (iComponentStore == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.ComponentStoreImpl");
            }
            StateStorageManager stateStorageManager = ((ComponentStoreImpl)iComponentStore).getStorageManager();
            if (!(stateStorageManager instanceof StateStorageManagerImpl)) {
                stateStorageManager = null;
            }
            StateStorageManagerImpl stateStorageManagerImpl = (StateStorageManagerImpl)stateStorageManager;
            if (stateStorageManagerImpl == null) {
                return;
            }
            StateStorageManagerImpl storageManager2 = stateStorageManagerImpl;
            String string = file2.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.path");
            FileBasedStorage fileBasedStorage2 = (FileBasedStorage)CollectionsKt.firstOrNull((Iterable)StateStorageManagerImpl.getCachedFileStorages$default(storageManager2, CollectionsKt.listOf((Object)storageManager2.collapseMacros(string)), null, 2, null));
            if (fileBasedStorage2 == null) break block3;
            FileBasedStorage it = fileBasedStorage = fileBasedStorage2;
            this.registerChangedStorage(it, (ComponentManager)project2);
        }
    }

    @Override
    public void blockReloadingProjectOnExternalChanges() {
        this.reloadBlockCount.incrementAndGet();
    }

    @Override
    public void unblockReloadingProjectOnExternalChanges() {
        boolean bl;
        boolean bl2 = bl = this.reloadBlockCount.get() > 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (this.reloadBlockCount.decrementAndGet() == 0 && this.changedFilesAlarm.isEmpty()) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.changedFilesAlarm.request(true);
            } else {
                ApplicationManager.getApplication().invokeLater(this.restartApplicationOrReloadProjectTask, ModalityState.NON_MODAL);
            }
        }
    }

    @Override
    public void flushChangedProjectFileAlarm() {
        this.changedFilesAlarm.flush();
    }

    @Override
    public void reloadProject(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        StoreAwareProjectManagerKt.access$getCHANGED_FILES_KEY$p().set((UserDataHolder)project2, null);
        super.reloadProject(project2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void registerChangedStorage(StateStorage storage2, ComponentManager componentManager) {
        MultiMap changes;
        Project project2;
        ComponentManager componentManager2;
        if (ComponentStoreImplKt.getLOG().isDebugEnabled()) {
            ComponentStoreImplKt.getLOG().debug("[RELOAD] Registering project to reload: " + storage2, (Throwable)new Exception());
        }
        Object object = (componentManager2 = componentManager) instanceof Project ? (Project)componentManager : (project2 = componentManager2 instanceof Module ? ((Module)componentManager).getProject() : null);
        if (project2 == null) {
            changes = this.changedApplicationFiles;
            synchronized (changes) {
                boolean bl = changes.add(storage2);
            }
        }
        changes = (MultiMap)StoreAwareProjectManagerKt.access$getCHANGED_FILES_KEY$p().get((UserDataHolder)project2);
        if (changes == null) {
            changes = MultiMap.createLinkedSet();
            StoreAwareProjectManagerKt.access$getCHANGED_FILES_KEY$p().set((UserDataHolder)project2, (Object)changes);
        }
        MultiMap multiMap = changes;
        synchronized (multiMap) {
            IComponentStore iComponentStore = ServiceKt.getStateStore(componentManager);
            if (iComponentStore == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.ComponentStoreImpl");
            }
            changes.putValue((Object)((ComponentStoreImpl)iComponentStore), (Object)storage2);
            Unit unit = Unit.INSTANCE;
        }
        if (storage2 instanceof StateStorageBase) {
            ((StateStorageBase)storage2).disableSaving();
        }
        if (this.isReloadUnblocked()) {
            this.changedFilesAlarm.cancelAndRequest();
        }
    }

    private final boolean tryToReloadApplication() {
        if (ApplicationManager.getApplication().isDisposed()) {
            return false;
        }
        if (this.changedApplicationFiles.isEmpty()) {
            return true;
        }
        LinkedHashSet changes = new LinkedHashSet(this.changedApplicationFiles);
        this.changedApplicationFiles.clear();
        return StoreAwareProjectManagerKt.reloadAppStore(changes);
    }

    public StoreAwareProjectManager(@NotNull VirtualFileManager virtualFileManager, @NotNull ProgressManager progressManager) {
        Intrinsics.checkParameterIsNotNull((Object)virtualFileManager, (String)"virtualFileManager");
        Intrinsics.checkParameterIsNotNull((Object)progressManager, (String)"progressManager");
        super(progressManager);
        this.reloadBlockCount = new AtomicInteger();
        this.changedApplicationFiles = new LinkedHashSet();
        this.restartApplicationOrReloadProjectTask = new Runnable(this){
            final /* synthetic */ StoreAwareProjectManager this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void run() {
                if (!StoreAwareProjectManager.access$isReloadUnblocked(this.this$0) || !StoreAwareProjectManager.access$tryToReloadApplication(this.this$0)) {
                    return;
                }
                THashSet projectsToReload = new THashSet();
                Project[] projectArray = this.this$0.getOpenProjects();
                for (int i = 0; i < projectArray.length; ++i) {
                    MessageBus messageBus$iv;
                    MultiMap changes;
                    Project project2 = projectArray[i];
                    if (project2.isDisposed()) continue;
                    if ((MultiMap)StoreAwareProjectManagerKt.access$getCHANGED_FILES_KEY$p().get((UserDataHolder)project2) == null) {
                        continue;
                    }
                    StoreAwareProjectManagerKt.access$getCHANGED_FILES_KEY$p().set((UserDataHolder)project2, null);
                    if (changes.isEmpty()) continue;
                    Intrinsics.checkExpressionValueIsNotNull((Object)project2.getMessageBus(), (String)"project.messageBus");
                    BatchUpdateListener publisher$iv = (BatchUpdateListener)messageBus$iv.syncPublisher(BatchUpdateListener.TOPIC);
                    publisher$iv.onBatchUpdateStarted();
                    try {
                        Iterator<E> iterator = changes.entrySet().iterator();
                        while (iterator.hasNext()) {
                            StateStorageManagerImpl stateStorageManagerImpl;
                            Map.Entry entry;
                            Map.Entry entry2 = entry = (Map.Entry)iterator.next();
                            ComponentStoreImpl store = (ComponentStoreImpl)entry2.getKey();
                            entry2 = entry;
                            Collection storages = (Collection)entry2.getValue();
                            StateStorageManager stateStorageManager = store.getStorageManager();
                            if (!(stateStorageManager instanceof StateStorageManagerImpl)) {
                                stateStorageManager = null;
                            }
                            if ((stateStorageManagerImpl = (StateStorageManagerImpl)stateStorageManager) != null && (stateStorageManagerImpl = stateStorageManagerImpl.getComponentManager()) != null) {
                                if (stateStorageManagerImpl.isDisposed()) {
                                    continue;
                                }
                            }
                            Collection collection = storages;
                            if (collection == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Set<com.intellij.openapi.components.StateStorage>");
                            }
                            Set set2 = (Set)collection;
                            ComponentStoreImpl componentStoreImpl = store;
                            Intrinsics.checkExpressionValueIsNotNull((Object)componentStoreImpl, (String)"store");
                            if (!Intrinsics.areEqual((Object)((Object)StoreAwareProjectManagerKt.reloadStore(set2, componentStoreImpl)), (Object)((Object)ReloadComponentStoreStatus.RESTART_AGREED))) continue;
                            projectsToReload.add((Object)project2);
                        }
                        Unit unit = Unit.INSTANCE;
                        continue;
                    }
                    finally {
                        publisher$iv.onBatchUpdateFinished();
                    }
                }
                for (Project project2 : projectsToReload) {
                    ProjectManagerImpl.doReloadProject(project2);
                }
            }
            {
                this.this$0 = storeAwareProjectManager;
            }
        };
        this.changedFilesAlarm = new SingleAlarm(this.restartApplicationOrReloadProjectTask, 300, this);
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(StateStorageManagerKt.getSTORAGE_TOPIC(), (Object)new StorageManagerListener(){

            @Override
            public void storageFileChanged(@NotNull VFileEvent event, @NotNull StateStorage storage2, @NotNull ComponentManager componentManager) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                Intrinsics.checkParameterIsNotNull((Object)storage2, (String)"storage");
                Intrinsics.checkParameterIsNotNull((Object)componentManager, (String)"componentManager");
                if (event instanceof VFilePropertyChangeEvent) {
                    return;
                }
                if (event.getRequestor() instanceof StateStorage.SaveSession || event.getRequestor() instanceof StateStorage || event.getRequestor() instanceof ProjectManagerImpl) {
                    return;
                }
                this.registerChangedStorage(storage2, componentManager);
            }
        });
        virtualFileManager.addVirtualFileManagerListener((VirtualFileManagerListener)new VirtualFileManagerAdapter(){

            @Override
            public void beforeRefreshStart(boolean asynchronous) {
                this.blockReloadingProjectOnExternalChanges();
            }

            @Override
            public void afterRefreshFinish(boolean asynchronous) {
                this.unblockReloadingProjectOnExternalChanges();
            }
        });
    }

    public static final /* synthetic */ boolean access$isReloadUnblocked(StoreAwareProjectManager $this) {
        return $this.isReloadUnblocked();
    }

    public static final /* synthetic */ boolean access$tryToReloadApplication(StoreAwareProjectManager $this) {
        return $this.tryToReloadApplication();
    }
}

