/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.settings.JavaDebuggerSettings;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.TabbedConfigurable;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.JBUI;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class CustomizeContextViewAction
extends XDebuggerTreeActionBase {
    private static int ourLastSelectedTabIndex = 0;

    @Override
    public void actionPerformed(AnActionEvent e) {
        this.perform(null, "", e);
    }

    @Override
    protected void perform(XValueNodeImpl node, @NotNull String nodeName, AnActionEvent e) {
        if (nodeName == null) {
            CustomizeContextViewAction.$$$reportNull$$$0(0);
        }
        Project project2 = e.getProject();
        final MyTabbedConfigurable configurable = new MyTabbedConfigurable();
        SingleConfigurableEditor editor = new SingleConfigurableEditor(project2, (Configurable)configurable){

            @Override
            protected void doOKAction() {
                ourLastSelectedTabIndex = configurable.getSelectedIndex();
                super.doOKAction();
            }

            @Override
            public void doCancelAction() {
                ourLastSelectedTabIndex = configurable.getSelectedIndex();
                super.doCancelAction();
            }
        };
        editor.show();
    }

    @Override
    public void update(AnActionEvent e) {
        e.getPresentation().setText(ActionsBundle.actionText((String)"Debugger.CustomizeContextView"));
        e.getPresentation().setEnabledAndVisible(DebuggerUtilsEx.isInJavaSession(e));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeName", "com/intellij/debugger/actions/CustomizeContextViewAction", "perform"));
    }

    private static class MyTabbedConfigurable
    extends TabbedConfigurable {
        private MyTabbedConfigurable() {
        }

        @Override
        @NotNull
        protected List<Configurable> createConfigurables() {
            List<Configurable> list2 = JavaDebuggerSettings.createDataViewsConfigurable();
            if (list2 == null) {
                MyTabbedConfigurable.$$$reportNull$$$0(0);
            }
            return list2;
        }

        @Override
        public void apply() throws ConfigurationException {
            super.apply();
            NodeRendererSettings.getInstance().fireRenderersChanged();
        }

        public String getDisplayName() {
            return DebuggerBundle.message((String)"title.customize.data.views", (Object[])new Object[0]);
        }

        public String getHelpTopic() {
            return "reference.debug.customize.data.view";
        }

        @Override
        protected void createConfigurableTabs() {
            for (Configurable configurable : this.getConfigurables()) {
                JComponent component = configurable.createComponent();
                assert (component != null);
                component.setBorder((Border)JBUI.Borders.empty((int)8, (int)8));
                this.myTabbedPane.addTab(configurable.getDisplayName(), component);
            }
            this.myTabbedPane.setSelectedIndex(ourLastSelectedTabIndex);
        }

        int getSelectedIndex() {
            return this.myTabbedPane.getSelectedIndex();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/actions/CustomizeContextViewAction$MyTabbedConfigurable", "createConfigurables"));
        }
    }
}

