/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.EvaluatingComputable;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.NamedMethodFilter;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.Range;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicStepMethodFilter
implements NamedMethodFilter {
    private static final Logger LOG = Logger.getInstance(BasicStepMethodFilter.class);
    @NotNull
    protected final JVMName myDeclaringClassName;
    @NotNull
    private final String myTargetMethodName;
    @Nullable
    protected final JVMName myTargetMethodSignature;
    private final Range<Integer> myCallingExpressionLines;

    public BasicStepMethodFilter(@NotNull PsiMethod psiMethod, Range<Integer> callingExpressionLines) {
        if (psiMethod == null) {
            BasicStepMethodFilter.$$$reportNull$$$0(0);
        }
        this(JVMNameUtil.getJVMQualifiedName(psiMethod.getContainingClass()), JVMNameUtil.getJVMMethodName(psiMethod), JVMNameUtil.getJVMSignature(psiMethod), callingExpressionLines);
    }

    protected BasicStepMethodFilter(@NotNull JVMName declaringClassName, @NotNull String targetMethodName, @Nullable JVMName targetMethodSignature, Range<Integer> callingExpressionLines) {
        if (declaringClassName == null) {
            BasicStepMethodFilter.$$$reportNull$$$0(1);
        }
        if (targetMethodName == null) {
            BasicStepMethodFilter.$$$reportNull$$$0(2);
        }
        this.myDeclaringClassName = declaringClassName;
        this.myTargetMethodName = targetMethodName;
        this.myTargetMethodSignature = targetMethodSignature;
        this.myCallingExpressionLines = callingExpressionLines;
    }

    @Override
    @NotNull
    public String getMethodName() {
        String string = this.myTargetMethodName;
        if (string == null) {
            BasicStepMethodFilter.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public boolean locationMatches(DebugProcessImpl process2, Location location) throws EvaluateException {
        return this.locationMatches(process2, location, () -> null);
    }

    @Override
    public boolean locationMatches(DebugProcessImpl process2, Location location, @NotNull EvaluatingComputable<ObjectReference> thisProvider) throws EvaluateException {
        ObjectReference thisObject;
        Method method;
        String name2;
        if (thisProvider == null) {
            BasicStepMethodFilter.$$$reportNull$$$0(4);
        }
        if (!this.myTargetMethodName.equals(name2 = (method = location.method()).name())) {
            if (DebuggerUtilsEx.isLambdaName(name2)) {
                SourcePosition position = process2.getPositionManager().getSourcePosition(location);
                return (Boolean)ReadAction.compute(() -> {
                    PsiElement psiMethod = DebuggerUtilsEx.getContainingMethod(position);
                    if (psiMethod instanceof PsiLambdaExpression) {
                        PsiType type2 = ((PsiLambdaExpression)psiMethod).getFunctionalInterfaceType();
                        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)type2);
                        if (type2 != null && interfaceMethod != null && this.myTargetMethodName.equals(interfaceMethod.getName())) {
                            try {
                                return InheritanceUtil.isInheritor((PsiType)type2, (String)this.myDeclaringClassName.getName(process2).replace('$', '.'));
                            }
                            catch (EvaluateException e) {
                                LOG.info((Throwable)e);
                            }
                        }
                    }
                    return false;
                });
            }
            return false;
        }
        if (this.myTargetMethodSignature != null && !BasicStepMethodFilter.signatureMatches(method, this.myTargetMethodSignature.getName(process2))) {
            return false;
        }
        if (method.isBridge()) {
            return false;
        }
        String declaringClassNameName = this.myDeclaringClassName.getName(process2);
        boolean res = DebuggerUtilsEx.isAssignableFrom(declaringClassNameName, location.declaringType());
        if (!res && !method.isStatic() && (thisObject = thisProvider.compute()) != null) {
            res = DebuggerUtilsEx.isAssignableFrom(declaringClassNameName, thisObject.referenceType());
        }
        return res;
    }

    private static boolean signatureMatches(Method method, String expectedSignature) throws EvaluateException {
        if (expectedSignature.equals(method.signature())) {
            return true;
        }
        for (Method candidate : method.declaringType().methodsByName(method.name())) {
            if (candidate == method || !candidate.isBridge() || !expectedSignature.equals(candidate.signature())) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Range<Integer> getCallingExpressionLines() {
        return this.myCallingExpressionLines;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaringClassName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetMethodName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/BasicStepMethodFilter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/BasicStepMethodFilter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "locationMatches";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

