/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.BasicStepMethodFilter;
import com.intellij.debugger.engine.BreakpointStepMethodFilter;
import com.intellij.debugger.engine.ClassInstanceMethodFilter;
import com.intellij.debugger.engine.LambdaMethodFilter;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.breakpoints.StepIntoBreakpoint;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiMethod;
import com.intellij.util.containers.ContainerUtil;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import com.sun.jdi.event.LocatableEvent;
import org.jetbrains.annotations.NotNull;

public class LambdaAsyncMethodFilter
extends BasicStepMethodFilter {
    private final int myParamNo;
    private final LambdaMethodFilter myMethodFilter;

    public LambdaAsyncMethodFilter(@NotNull PsiMethod callerMethod, int paramNo, LambdaMethodFilter methodFilter) {
        if (callerMethod == null) {
            LambdaAsyncMethodFilter.$$$reportNull$$$0(0);
        }
        super(callerMethod, methodFilter.getCallingExpressionLines());
        this.myParamNo = paramNo;
        this.myMethodFilter = methodFilter;
    }

    @Override
    public int onReached(SuspendContextImpl context, RequestHint hint) {
        try {
            SourcePosition pos;
            Value lambdaReference;
            StackFrameProxyImpl proxy = context.getFrameProxy();
            if (proxy != null && (lambdaReference = (Value)ContainerUtil.getOrElse(proxy.getArgumentValues(), (int)this.myParamNo, null)) instanceof ObjectReference && (pos = this.myMethodFilter.getBreakpointPosition()) != null) {
                Project project2 = context.getDebugProcess().getProject();
                long lambdaId = ((ObjectReference)lambdaReference).uniqueID();
                LambdaInstanceBreakpoint breakpoint = new LambdaInstanceBreakpoint(project2, lambdaId, pos, this.myMethodFilter);
                ClassInstanceMethodFilter.setUpStepIntoBreakpoint(context, breakpoint, hint);
                return -100;
            }
        }
        catch (EvaluateException evaluateException) {
            // empty catch block
        }
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callerMethod", "com/intellij/debugger/engine/LambdaAsyncMethodFilter", "<init>"));
    }

    private static class LambdaInstanceBreakpoint
    extends StepIntoBreakpoint {
        private final long myLambdaId;

        /*
         * WARNING - void declaration
         */
        public LambdaInstanceBreakpoint(@NotNull Project project2, long lambdaId, @NotNull SourcePosition pos, @NotNull BreakpointStepMethodFilter breakpointStepMethodFilter) {
            void filter2;
            if (project2 == null) {
                LambdaInstanceBreakpoint.$$$reportNull$$$0(0);
            }
            if (pos == null) {
                LambdaInstanceBreakpoint.$$$reportNull$$$0(1);
            }
            if (breakpointStepMethodFilter == null) {
                LambdaInstanceBreakpoint.$$$reportNull$$$0(2);
            }
            super(project2, pos, (BreakpointStepMethodFilter)filter2);
            this.myLambdaId = lambdaId;
        }

        @Override
        public boolean evaluateCondition(EvaluationContextImpl context, LocatableEvent event) throws EvaluateException {
            if (!super.evaluateCondition(context, event)) {
                return false;
            }
            if (!DebuggerUtilsEx.isLambda(event.location().method())) {
                return false;
            }
            ObjectReference lambdaReference = null;
            StackFrameProxyImpl parentFrame = context.getSuspendContext().getThread().frame(1);
            if (parentFrame != null) {
                try {
                    lambdaReference = parentFrame.thisObject();
                }
                catch (EvaluateException evaluateException) {
                    // empty catch block
                }
            }
            return lambdaReference != null && lambdaReference.uniqueID() == this.myLambdaId;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pos";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "filter";
                    break;
                }
            }
            objectArray[1] = "com/intellij/debugger/engine/LambdaAsyncMethodFilter$LambdaInstanceBreakpoint";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

